/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.SideSkipPredicate;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;
import xfacthd.framedblocks.common.data.property.StairsType;
import xfacthd.framedblocks.common.data.skippreds.FlatInnerSlopePanelCornerSkipPredicate;

public final class FlatExtendedSlopePanelCornerSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        if (side == dir) {
            return SideSkipPredicate.CTM.test(level, pos, state, adjState, side);
        }
        HorizontalRotation rot = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
        HorizontalRotation perpRot = rot.rotate(Rotation.COUNTERCLOCKWISE_90);
        Direction rotDir = rot.withFacing(dir);
        Direction perpRotDir = perpRot.withFacing(dir);
        Object object = adjState.m_60734_();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType type = (BlockType)object;
            return switch (type) {
                case BlockType.FRAMED_FLAT_EXT_SLOPE_PANEL_CORNER -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstFlatExtendedSlopePanelCorner(level, pos, dir, rot, perpRot, rotDir, perpRotDir, adjState, side);
                case BlockType.FRAMED_FLAT_EXT_INNER_SLOPE_PANEL_CORNER -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstFlatExtendedInnerSlopePanelCorner(level, pos, dir, rot, rotDir, perpRotDir, adjState, side);
                case BlockType.FRAMED_FLAT_INNER_SLOPE_PANEL_CORNER -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstFlatInnerSlopePanelCorner(level, pos, dir, rot, adjState, side);
                case BlockType.FRAMED_FLAT_DOUBLE_SLOPE_PANEL_CORNER -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstFlatDoubleSlopePanelCorner(level, pos, dir, rot, adjState, side);
                case BlockType.FRAMED_FLAT_INV_DOUBLE_SLOPE_PANEL_CORNER -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstFlatInverseDoubleSlopePanelCorner(level, pos, dir, rot, adjState, side);
                case BlockType.FRAMED_FLAT_EXT_DOUBLE_SLOPE_PANEL_CORNER -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstFlatExtendedDoubleSlopePanelCorner(level, pos, dir, rot, perpRot, rotDir, perpRotDir, adjState, side);
                case BlockType.FRAMED_FLAT_EXT_INNER_DOUBLE_SLOPE_PANEL_CORNER -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstFlatExtendedInnerDoubleSlopePanelCorner(level, pos, dir, rot, rotDir, perpRotDir, adjState, side);
                case BlockType.FRAMED_SLOPE_PANEL -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstSlopePanel(level, pos, dir, rot, adjState, side);
                case BlockType.FRAMED_EXTENDED_SLOPE_PANEL -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstExtendedSlopePanel(level, pos, dir, rot, perpRot, rotDir, perpRotDir, adjState, side);
                case BlockType.FRAMED_DOUBLE_SLOPE_PANEL -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstDoubleSlopePanel(level, pos, dir, rot, adjState, side);
                case BlockType.FRAMED_INV_DOUBLE_SLOPE_PANEL -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstInverseDoubleSlopePanel(level, pos, dir, rot, perpRot, rotDir, perpRotDir, adjState, side);
                case BlockType.FRAMED_EXTENDED_DOUBLE_SLOPE_PANEL -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstExtendedDoubleSlopePanel(level, pos, dir, rot, perpRot, rotDir, perpRotDir, adjState, side);
                case BlockType.FRAMED_SLAB_EDGE -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstSlabEdge(level, pos, dir, rot, adjState, side);
                case BlockType.FRAMED_PANEL -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstPanel(level, pos, dir, rot, adjState, side);
                case BlockType.FRAMED_DOUBLE_PANEL -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstDoublePanel(level, pos, dir, rot, adjState, side);
                case BlockType.FRAMED_CORNER_PILLAR -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstCornerPillar(level, pos, dir, rot, adjState, side);
                case BlockType.FRAMED_STAIRS -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstStairs(level, pos, dir, rot, adjState, side);
                case BlockType.FRAMED_DOUBLE_STAIRS -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstDoubleStairs(level, pos, dir, rot, adjState, side);
                case BlockType.FRAMED_VERTICAL_STAIRS -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstVerticalStairs(level, pos, dir, rot, adjState, side);
                case BlockType.FRAMED_VERTICAL_DOUBLE_STAIRS -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstVerticalDoubleStairs(level, pos, dir, rot, adjState, side);
                case BlockType.FRAMED_HALF_STAIRS -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstHalfStairs(level, pos, dir, rot, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    private static boolean testAgainstFlatExtendedSlopePanelCorner(BlockGetter level, BlockPos pos, Direction dir, HorizontalRotation rot, HorizontalRotation perpRot, Direction rotDir, Direction perpRotDir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (adjDir != dir) {
            return false;
        }
        if (FlatExtendedSlopePanelCornerSkipPredicate.isPanelSide(dir, rot, side) && FlatExtendedSlopePanelCornerSkipPredicate.isPanelSide(adjDir, adjRot, side.m_122424_())) {
            return SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        if (side == perpRotDir.m_122424_() && adjRot == rot.rotate(Rotation.CLOCKWISE_90)) {
            return SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        if (side == rotDir.m_122424_() && adjRot == perpRot) {
            return SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        return false;
    }

    private static boolean testAgainstFlatExtendedInnerSlopePanelCorner(BlockGetter level, BlockPos pos, Direction dir, HorizontalRotation rot, Direction rotDir, Direction perpRotDir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (adjDir == dir && adjRot == rot && (side == rotDir.m_122424_() || side == perpRotDir.m_122424_())) {
            return SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        return false;
    }

    private static boolean testAgainstFlatInnerSlopePanelCorner(BlockGetter level, BlockPos pos, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        if (!FlatExtendedSlopePanelCornerSkipPredicate.isPanelSide(dir, rot, side)) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        if (FlatInnerSlopePanelCornerSkipPredicate.isPanelSide(adjDir, adjRot, side.m_122424_()) && (adjDir == dir && !adjFront || adjDir == dir.m_122424_() && adjFront)) {
            return SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstFlatDoubleSlopePanelCorner(BlockGetter level, BlockPos pos, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        if (!FlatExtendedSlopePanelCornerSkipPredicate.isPanelSide(dir, rot, side)) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        if (FlatInnerSlopePanelCornerSkipPredicate.isPanelSide(adjDir, adjRot, side.m_122424_()) && (adjDir == dir && !adjFront || adjDir == dir.m_122424_() && adjFront)) {
            return SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstFlatInverseDoubleSlopePanelCorner(BlockGetter level, BlockPos pos, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        if (!FlatExtendedSlopePanelCornerSkipPredicate.isPanelSide(dir, rot, side)) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (adjDir == dir && FlatInnerSlopePanelCornerSkipPredicate.isPanelSide(adjDir, adjRot, side.m_122424_())) {
            return SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstFlatExtendedDoubleSlopePanelCorner(BlockGetter level, BlockPos pos, Direction dir, HorizontalRotation rot, HorizontalRotation perpRot, Direction rotDir, Direction perpRotDir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (FlatExtendedSlopePanelCornerSkipPredicate.isPanelSide(dir, rot, side) && FlatExtendedSlopePanelCornerSkipPredicate.isPanelSide(adjDir, adjRot, side.m_122424_())) {
            return adjDir.m_122434_() == dir.m_122434_() && SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        if (adjDir != dir) {
            return false;
        }
        if (side == perpRotDir.m_122424_() && adjRot == rot.rotate(Rotation.CLOCKWISE_90)) {
            return SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        if (side == rotDir.m_122424_() && adjRot == perpRot) {
            return SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        return false;
    }

    private static boolean testAgainstFlatExtendedInnerDoubleSlopePanelCorner(BlockGetter level, BlockPos pos, Direction dir, HorizontalRotation rot, Direction rotDir, Direction perpRotDir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (adjDir == dir && adjRot == rot && (side == rotDir.m_122424_() || side == perpRotDir.m_122424_())) {
            return SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        return false;
    }

    private static boolean testAgainstSlopePanel(BlockGetter level, BlockPos pos, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        if (!FlatExtendedSlopePanelCornerSkipPredicate.isPanelSide(dir, rot, side)) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        if (adjRot.withFacing(adjDir) == side && (adjDir == dir && !adjFront || adjDir == dir.m_122424_() && adjFront)) {
            return SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstExtendedSlopePanel(BlockGetter level, BlockPos pos, Direction dir, HorizontalRotation rot, HorizontalRotation perpRot, Direction rotDir, Direction perpRotDir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (adjDir != dir) {
            return false;
        }
        if (FlatExtendedSlopePanelCornerSkipPredicate.isPanelSide(dir, rot, side) && adjRot.withFacing(adjDir) == side.m_122424_()) {
            return SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        if (side == rotDir.m_122424_() && adjRot == perpRot) {
            return SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        if (side == perpRotDir.m_122424_() && adjRot == rot) {
            return SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        return false;
    }

    private static boolean testAgainstDoubleSlopePanel(BlockGetter level, BlockPos pos, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        if (!FlatExtendedSlopePanelCornerSkipPredicate.isPanelSide(dir, rot, side)) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        if (adjRot.withFacing(adjDir).m_122434_() == side.m_122434_() && (adjDir == dir && !adjFront || adjDir == dir.m_122424_() && adjFront)) {
            return SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstInverseDoubleSlopePanel(BlockGetter level, BlockPos pos, Direction dir, HorizontalRotation rot, HorizontalRotation perpRot, Direction rotDir, Direction perpRotDir, BlockState adjState, Direction side) {
        if (!FlatExtendedSlopePanelCornerSkipPredicate.isPanelSide(dir, rot, side)) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (side == rotDir) {
            if (adjDir == dir && rot.isSameDir(dir, adjRot.getOpposite(), adjDir)) {
                return SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
            }
            if (adjDir == dir.m_122424_() && rot.isSameDir(dir, adjRot, adjDir)) {
                return SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
            }
        } else if (side == perpRotDir) {
            if (adjDir == dir && perpRot.isSameDir(dir, adjRot.getOpposite(), adjDir)) {
                return SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
            }
            if (adjDir == dir.m_122424_() && perpRot.isSameDir(dir, adjRot, adjDir)) {
                return SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
            }
        }
        return false;
    }

    private static boolean testAgainstExtendedDoubleSlopePanel(BlockGetter level, BlockPos pos, Direction dir, HorizontalRotation rot, HorizontalRotation perpRot, Direction rotDir, Direction perpRotDir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (FlatExtendedSlopePanelCornerSkipPredicate.isPanelSide(dir, rot, side) && adjDir.m_122434_() == dir.m_122434_() && adjRot.withFacing(adjDir) == side.m_122424_()) {
            return SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        if (adjDir != dir) {
            return false;
        }
        if (side == rotDir.m_122424_() && adjRot == perpRot) {
            return SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        if (side == perpRotDir.m_122424_() && adjRot == rot) {
            return SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        return false;
    }

    private static boolean testAgainstSlabEdge(BlockGetter level, BlockPos pos, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        if (!Utils.isY(side) || !FlatExtendedSlopePanelCornerSkipPredicate.isPanelSide(dir, rot, side)) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (adjDir == dir && (side == Direction.DOWN && adjTop || side == Direction.UP && !adjTop)) {
            return SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        return false;
    }

    private static boolean testAgainstPanel(BlockGetter level, BlockPos pos, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        if (!FlatExtendedSlopePanelCornerSkipPredicate.isPanelSide(dir, rot, side)) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        return adjDir == dir && SideSkipPredicate.compareState(level, pos, side, dir, dir);
    }

    private static boolean testAgainstDoublePanel(BlockGetter level, BlockPos pos, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        if (!FlatExtendedSlopePanelCornerSkipPredicate.isPanelSide(dir, rot, side)) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_NE);
        return adjDir.m_122434_() == dir.m_122434_() && SideSkipPredicate.compareState(level, pos, side, dir, dir);
    }

    private static boolean testAgainstCornerPillar(BlockGetter level, BlockPos pos, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        if (Utils.isY(side) || !FlatExtendedSlopePanelCornerSkipPredicate.isPanelSide(dir, rot, side)) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        if (side == dir.m_122427_() && adjDir == dir || side == dir.m_122428_() && adjDir == dir.m_122427_()) {
            return SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstStairs(BlockGetter level, BlockPos pos, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        boolean adjTop;
        if (!FlatExtendedSlopePanelCornerSkipPredicate.isPanelSide(dir, rot, side)) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)StairBlock.f_56841_);
        StairsShape adjShape = (StairsShape)adjState.m_61143_((Property)StairBlock.f_56843_);
        boolean bl = adjTop = adjState.m_61143_((Property)StairBlock.f_56842_) == Half.TOP;
        if (adjShape != StairsShape.STRAIGHT || adjDir != dir) {
            return false;
        }
        if (side == Direction.DOWN && !adjTop || side == Direction.UP && adjTop) {
            return SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        return false;
    }

    private static boolean testAgainstDoubleStairs(BlockGetter level, BlockPos pos, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        if (!FlatExtendedSlopePanelCornerSkipPredicate.isPanelSide(dir, rot, side)) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (adjDir.m_122434_() == dir.m_122434_() && (side == Direction.DOWN && !adjTop || side == Direction.UP && adjTop)) {
            return SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        return false;
    }

    private static boolean testAgainstVerticalStairs(BlockGetter level, BlockPos pos, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        if (!FlatExtendedSlopePanelCornerSkipPredicate.isPanelSide(dir, rot, side)) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        StairsType adjType = (StairsType)((Object)adjState.m_61143_(PropertyHolder.STAIRS_TYPE));
        if (adjType != StairsType.VERTICAL) {
            return false;
        }
        if (side == dir.m_122427_() && adjDir == dir.m_122427_() || side == dir.m_122428_() && adjDir == dir) {
            return SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        return false;
    }

    private static boolean testAgainstVerticalDoubleStairs(BlockGetter level, BlockPos pos, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        if (!FlatExtendedSlopePanelCornerSkipPredicate.isPanelSide(dir, rot, side)) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        if (side == dir.m_122427_() && (adjDir == dir.m_122427_() || adjDir == dir.m_122424_())) {
            return SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        if (side == dir.m_122428_() && (adjDir == dir || adjDir == dir.m_122428_())) {
            return SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        return false;
    }

    private static boolean testAgainstHalfStairs(BlockGetter level, BlockPos pos, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        if (!FlatExtendedSlopePanelCornerSkipPredicate.isPanelSide(dir, rot, side)) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        boolean adjRight = (Boolean)adjState.m_61143_((Property)PropertyHolder.RIGHT);
        if (side == Direction.UP && !adjTop || side == Direction.DOWN && adjTop) {
            if (adjDir == dir.m_122427_() && !adjRight || adjDir == dir.m_122428_() && adjRight) {
                return SideSkipPredicate.compareState(level, pos, side, dir, dir);
            }
        } else if (!Utils.isY(side)) {
            if (side == dir.m_122427_() && adjDir == dir.m_122428_() && adjRight) {
                return SideSkipPredicate.compareState(level, pos, side, dir, dir);
            }
            if (side == dir.m_122428_() && adjDir == dir.m_122427_() && !adjRight) {
                return SideSkipPredicate.compareState(level, pos, side, dir, dir);
            }
        }
        return false;
    }

    public static boolean isPanelSide(Direction dir, HorizontalRotation rot, Direction side) {
        return side == rot.withFacing(dir) || side == rot.rotate(Rotation.COUNTERCLOCKWISE_90).withFacing(dir);
    }
}

