/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.SideSkipPredicate;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;
import xfacthd.framedblocks.common.data.property.StairsType;
import xfacthd.framedblocks.common.data.skippreds.FlatExtendedSlopePanelCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.FlatInnerSlopePanelCornerSkipPredicate;

public final class ExtendedSlopePanelSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation rot = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
        Direction rotDir = rot.withFacing(dir);
        if (side == dir || side == rotDir.m_122424_()) {
            return SideSkipPredicate.CTM.test(level, pos, state, adjState, side);
        }
        Object object = adjState.m_60734_();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType type = (BlockType)object;
            return switch (type) {
                case BlockType.FRAMED_EXTENDED_SLOPE_PANEL -> ExtendedSlopePanelSkipPredicate.testAgainstExtendedSlopePanel(level, pos, adjState, side, dir, rot, rotDir);
                case BlockType.FRAMED_SLOPE_PANEL -> ExtendedSlopePanelSkipPredicate.testAgainstSlopePanel(level, pos, adjState, side, dir, rot, rotDir);
                case BlockType.FRAMED_DOUBLE_SLOPE_PANEL -> ExtendedSlopePanelSkipPredicate.testAgainstDoubleSlopePanel(level, pos, adjState, side, dir, rot, rotDir);
                case BlockType.FRAMED_INV_DOUBLE_SLOPE_PANEL -> ExtendedSlopePanelSkipPredicate.testAgainstInverseDoubleSlopePanel(level, pos, adjState, side, dir, rot, rotDir);
                case BlockType.FRAMED_EXTENDED_DOUBLE_SLOPE_PANEL -> ExtendedSlopePanelSkipPredicate.testAgainstExtendedDoubleSlopePanel(level, pos, adjState, side, dir, rot, rotDir);
                case BlockType.FRAMED_FLAT_INNER_SLOPE_PANEL_CORNER -> ExtendedSlopePanelSkipPredicate.testAgainstFlatInnerSlopePanelCorner(level, pos, adjState, side, dir, rotDir);
                case BlockType.FRAMED_FLAT_EXT_SLOPE_PANEL_CORNER -> ExtendedSlopePanelSkipPredicate.testAgainstFlatExtendedSlopePanelCorner(level, pos, adjState, side, dir, rot, rotDir);
                case BlockType.FRAMED_FLAT_EXT_INNER_SLOPE_PANEL_CORNER -> ExtendedSlopePanelSkipPredicate.testAgainstFlatExtendedInnerSlopePanelCorner(level, pos, adjState, side, dir, rot);
                case BlockType.FRAMED_FLAT_DOUBLE_SLOPE_PANEL_CORNER -> ExtendedSlopePanelSkipPredicate.testAgainstFlatDoubleSlopePanelCorner(level, pos, adjState, side, dir, rotDir);
                case BlockType.FRAMED_FLAT_INV_DOUBLE_SLOPE_PANEL_CORNER -> ExtendedSlopePanelSkipPredicate.testAgainstFlatInverseDoubleSlopePanelCorner(level, pos, adjState, side, dir, rotDir);
                case BlockType.FRAMED_FLAT_EXT_DOUBLE_SLOPE_PANEL_CORNER -> ExtendedSlopePanelSkipPredicate.testAgainstFlatExtendedDoubleSlopePanelCorner(level, pos, adjState, side, dir, rot, rotDir);
                case BlockType.FRAMED_FLAT_EXT_INNER_DOUBLE_SLOPE_PANEL_CORNER -> ExtendedSlopePanelSkipPredicate.testAgainstFlatExtendedInnerDoubleSlopePanelCorner(level, pos, adjState, side, dir, rot);
                case BlockType.FRAMED_SLAB_EDGE -> ExtendedSlopePanelSkipPredicate.testAgainstSlabEdge(level, pos, adjState, side, dir, rot, rotDir);
                case BlockType.FRAMED_PANEL -> ExtendedSlopePanelSkipPredicate.testAgainstPanel(level, pos, adjState, side, dir, rotDir);
                case BlockType.FRAMED_DOUBLE_PANEL -> ExtendedSlopePanelSkipPredicate.testAgainstDoublePanel(level, pos, adjState, side, dir, rotDir);
                case BlockType.FRAMED_CORNER_PILLAR -> ExtendedSlopePanelSkipPredicate.testAgainstCornerPillar(level, pos, adjState, side, dir, rot, rotDir);
                case BlockType.FRAMED_STAIRS -> ExtendedSlopePanelSkipPredicate.testAgainstStairs(level, pos, adjState, side, dir, rot, rotDir);
                case BlockType.FRAMED_DOUBLE_STAIRS -> ExtendedSlopePanelSkipPredicate.testAgainstDoubleStairs(level, pos, adjState, side, dir, rot, rotDir);
                case BlockType.FRAMED_VERTICAL_STAIRS -> ExtendedSlopePanelSkipPredicate.testAgainstVerticalStairs(level, pos, adjState, side, dir, rot, rotDir);
                case BlockType.FRAMED_VERTICAL_DOUBLE_STAIRS -> ExtendedSlopePanelSkipPredicate.testAgainstVerticalDoubleStairs(level, pos, adjState, side, dir, rot, rotDir);
                case BlockType.FRAMED_HALF_STAIRS -> ExtendedSlopePanelSkipPredicate.testAgainstHalfStairs(level, pos, adjState, side, dir, rot, rotDir);
                default -> false;
            };
        }
        return false;
    }

    private static boolean testAgainstExtendedSlopePanel(BlockGetter level, BlockPos pos, BlockState adjState, Direction side, Direction dir, HorizontalRotation rot, Direction rotDir) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (side == rotDir && adjDir == dir && adjRot == rot.getOpposite()) {
            return SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        if (side != dir.m_122424_() && adjDir == dir && adjRot == rot) {
            return SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        return false;
    }

    private static boolean testAgainstSlopePanel(BlockGetter level, BlockPos pos, BlockState adjState, Direction side, Direction dir, HorizontalRotation rot, Direction rotDir) {
        if (side != rotDir) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        if (adjRot == rot && (adjDir == dir && !adjFront || adjDir == dir.m_122424_() && adjFront)) {
            return SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstDoubleSlopePanel(BlockGetter level, BlockPos pos, BlockState adjState, Direction side, Direction dir, HorizontalRotation rot, Direction rotDir) {
        if (side != rotDir) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        if ((adjRot == rot || adjRot == rot.getOpposite()) && (adjDir == dir && !adjFront || adjDir == dir.m_122424_() && adjFront)) {
            return SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstInverseDoubleSlopePanel(BlockGetter level, BlockPos pos, BlockState adjState, Direction side, Direction dir, HorizontalRotation rot, Direction rotDir) {
        if (side != rotDir) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (adjRot == rot.getOpposite() && adjDir.m_122434_() == dir.m_122434_()) {
            return SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstExtendedDoubleSlopePanel(BlockGetter level, BlockPos pos, BlockState adjState, Direction side, Direction dir, HorizontalRotation rot, Direction rotDir) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (side == rotDir ? adjRot == rot && adjDir == dir.m_122424_() || adjRot == rot.getOpposite() && adjDir == dir : side.m_122434_() != rotDir.m_122434_() && side.m_122434_() != dir.m_122434_() && adjDir == dir && adjRot == rot) {
            return SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        return false;
    }

    private static boolean testAgainstFlatInnerSlopePanelCorner(BlockGetter level, BlockPos pos, BlockState adjState, Direction side, Direction dir, Direction rotDir) {
        if (side != rotDir) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (FlatInnerSlopePanelCornerSkipPredicate.isPanelSide(adjDir, adjRot, side.m_122424_()) && (adjDir == dir && !adjFront || adjDir == dir.m_122424_() && adjFront)) {
            return SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstFlatExtendedSlopePanelCorner(BlockGetter level, BlockPos pos, BlockState adjState, Direction side, Direction dir, HorizontalRotation rot, Direction rotDir) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (adjDir != dir) {
            return false;
        }
        if (FlatExtendedSlopePanelCornerSkipPredicate.isPanelSide(adjDir, adjRot, side.m_122424_()) && side == rotDir) {
            return SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        if (side == rot.rotate(Rotation.CLOCKWISE_90).withFacing(dir) && adjRot == rot.rotate(Rotation.CLOCKWISE_90)) {
            return SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        if (side == rot.rotate(Rotation.COUNTERCLOCKWISE_90).withFacing(dir) && adjRot == rot) {
            return SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        return false;
    }

    private static boolean testAgainstFlatExtendedInnerSlopePanelCorner(BlockGetter level, BlockPos pos, BlockState adjState, Direction side, Direction dir, HorizontalRotation rot) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (adjDir != dir) {
            return false;
        }
        if (side == rot.rotate(Rotation.CLOCKWISE_90).withFacing(dir) && adjRot == rot) {
            return SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        if (side == rot.rotate(Rotation.COUNTERCLOCKWISE_90).withFacing(dir) && adjRot == rot.rotate(Rotation.CLOCKWISE_90)) {
            return SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        return false;
    }

    private static boolean testAgainstFlatDoubleSlopePanelCorner(BlockGetter level, BlockPos pos, BlockState adjState, Direction side, Direction dir, Direction rotDir) {
        if (side != rotDir) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (FlatInnerSlopePanelCornerSkipPredicate.isPanelSide(adjDir, adjRot, side.m_122424_()) && (adjDir == dir && !adjFront || adjDir == dir.m_122424_() && adjFront)) {
            return SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstFlatInverseDoubleSlopePanelCorner(BlockGetter level, BlockPos pos, BlockState adjState, Direction side, Direction dir, Direction rotDir) {
        if (side != rotDir) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (adjDir == dir && FlatInnerSlopePanelCornerSkipPredicate.isPanelSide(adjDir, adjRot, side.m_122424_())) {
            return SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstFlatExtendedDoubleSlopePanelCorner(BlockGetter level, BlockPos pos, BlockState adjState, Direction side, Direction dir, HorizontalRotation rot, Direction rotDir) {
        HorizontalRotation adjRot;
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        if (FlatExtendedSlopePanelCornerSkipPredicate.isPanelSide(adjDir, adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION)), side.m_122424_()) && side == rotDir) {
            return adjDir.m_122434_() == dir.m_122434_() && SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        if (adjDir != dir) {
            return false;
        }
        if (side == rot.rotate(Rotation.CLOCKWISE_90).withFacing(dir) && adjRot == rot.rotate(Rotation.CLOCKWISE_90)) {
            return SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        if (side == rot.rotate(Rotation.COUNTERCLOCKWISE_90).withFacing(dir) && adjRot == rot) {
            return SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        return false;
    }

    private static boolean testAgainstFlatExtendedInnerDoubleSlopePanelCorner(BlockGetter level, BlockPos pos, BlockState adjState, Direction side, Direction dir, HorizontalRotation rot) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (adjDir != dir) {
            return false;
        }
        if (side == rot.rotate(Rotation.CLOCKWISE_90).withFacing(dir) && adjRot == rot) {
            return SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        if (side == rot.rotate(Rotation.COUNTERCLOCKWISE_90).withFacing(dir) && adjRot == rot.rotate(Rotation.CLOCKWISE_90)) {
            return SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        return false;
    }

    private static boolean testAgainstSlabEdge(BlockGetter level, BlockPos pos, BlockState adjState, Direction side, Direction dir, HorizontalRotation rot, Direction rotDir) {
        if (!rot.isVertical() || side != rotDir) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return adjDir == dir && adjTop == (rot == HorizontalRotation.DOWN) && SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
    }

    private static boolean testAgainstPanel(BlockGetter level, BlockPos pos, BlockState adjState, Direction side, Direction dir, Direction rotDir) {
        if (side != rotDir) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        return adjDir == dir && SideSkipPredicate.compareState(level, pos, side, dir, dir);
    }

    private static boolean testAgainstDoublePanel(BlockGetter level, BlockPos pos, BlockState adjState, Direction side, Direction dir, Direction rotDir) {
        if (side != rotDir) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_NE);
        return (adjDir == dir || adjDir == dir.m_122424_()) && SideSkipPredicate.compareState(level, pos, side, dir, dir);
    }

    private static boolean testAgainstCornerPillar(BlockGetter level, BlockPos pos, BlockState adjState, Direction side, Direction dir, HorizontalRotation rot, Direction rotDir) {
        if (rot.isVertical() || side != rotDir) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        if (rot == HorizontalRotation.RIGHT && adjDir == dir || rot == HorizontalRotation.LEFT && adjDir == dir.m_122427_()) {
            return SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        return false;
    }

    private static boolean testAgainstStairs(BlockGetter level, BlockPos pos, BlockState adjState, Direction side, Direction dir, HorizontalRotation rot, Direction rotDir) {
        boolean straight;
        if (!rot.isVertical() || side != rotDir) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)StairBlock.f_56841_);
        boolean adjTop = adjState.m_61143_((Property)StairBlock.f_56842_) == Half.TOP;
        boolean bl = straight = adjState.m_61143_((Property)StairBlock.f_56843_) == StairsShape.STRAIGHT;
        return straight && adjDir == dir && adjTop == (rot == HorizontalRotation.UP) && SideSkipPredicate.compareState(level, pos, side, dir, dir);
    }

    private static boolean testAgainstDoubleStairs(BlockGetter level, BlockPos pos, BlockState adjState, Direction side, Direction dir, HorizontalRotation rot, Direction rotDir) {
        if (!rot.isVertical() || side != rotDir) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)StairBlock.f_56841_);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return adjDir.m_122434_() == dir.m_122434_() && adjTop == (rot == HorizontalRotation.UP) && SideSkipPredicate.compareState(level, pos, side, dir, dir);
    }

    private static boolean testAgainstVerticalStairs(BlockGetter level, BlockPos pos, BlockState adjState, Direction side, Direction dir, HorizontalRotation rot, Direction rotDir) {
        boolean adjVert;
        if (rot.isVertical() || side != rotDir) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean bl = adjVert = adjState.m_61143_(PropertyHolder.STAIRS_TYPE) == StairsType.VERTICAL;
        if (adjVert && (rot == HorizontalRotation.RIGHT && adjDir == dir.m_122427_() || rot == HorizontalRotation.LEFT && adjDir == dir)) {
            return SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        return false;
    }

    private static boolean testAgainstVerticalDoubleStairs(BlockGetter level, BlockPos pos, BlockState adjState, Direction side, Direction dir, HorizontalRotation rot, Direction rotDir) {
        if (rot.isVertical() || side != rotDir) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        if (rot == HorizontalRotation.RIGHT && (adjDir == dir.m_122427_() || adjDir == dir.m_122424_())) {
            return SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        if (rot == HorizontalRotation.LEFT && (adjDir == dir || adjDir == dir.m_122428_())) {
            return SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        return false;
    }

    private static boolean testAgainstHalfStairs(BlockGetter level, BlockPos pos, BlockState adjState, Direction side, Direction dir, HorizontalRotation rot, Direction rotDir) {
        if (side != rotDir) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        boolean adjRight = (Boolean)adjState.m_61143_((Property)PropertyHolder.RIGHT);
        if (rot.isVertical() && adjTop == (rot == HorizontalRotation.DOWN) && (!adjRight && adjDir == dir.m_122427_() || adjRight && adjDir == dir.m_122428_())) {
            return SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        if (!rot.isVertical() && (adjDir == dir.m_122428_() && adjRight || adjDir == dir.m_122427_() && !adjRight)) {
            return adjRight == (rot == HorizontalRotation.RIGHT) && SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        return false;
    }
}

