/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.SideSkipPredicate;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.skippreds.FlatElevatedSlopeSlabCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.FlatInnerSlopeSlabCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.StairsSkipPredicate;

public final class ElevatedSlopeSlabSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
        if (side == dir || top && side == Direction.UP || !top && side == Direction.DOWN) {
            return SideSkipPredicate.CTM.test(level, pos, state, adjState, side);
        }
        Object object = adjState.m_60734_();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType type = (BlockType)object;
            return switch (type) {
                case BlockType.FRAMED_ELEVATED_SLOPE_SLAB -> ElevatedSlopeSlabSkipPredicate.testAgainstElevatedSlopeSlab(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_SLOPE_SLAB, BlockType.FRAMED_DOUBLE_SLOPE_SLAB -> ElevatedSlopeSlabSkipPredicate.testAgainstSlopeSlab(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_INV_DOUBLE_SLOPE_SLAB -> ElevatedSlopeSlabSkipPredicate.testAgainstInverseDoubleSlopeSlab(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_ELEVATED_DOUBLE_SLOPE_SLAB -> ElevatedSlopeSlabSkipPredicate.testAgainstElevatedDoubleSlopeSlab(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_FLAT_INNER_SLOPE_SLAB_CORNER -> ElevatedSlopeSlabSkipPredicate.testAgainstFlatInnerSlopeSlabCorner(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_FLAT_ELEV_SLOPE_SLAB_CORNER -> ElevatedSlopeSlabSkipPredicate.testAgainstFlatElevatedSlopeSlabCorner(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_FLAT_ELEV_INNER_SLOPE_SLAB_CORNER -> ElevatedSlopeSlabSkipPredicate.testAgainstFlatElevatedInnerSlopeSlabCorner(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_FLAT_DOUBLE_SLOPE_SLAB_CORNER -> ElevatedSlopeSlabSkipPredicate.testAgainstFlatDoubleSlopeSlabCorner(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_FLAT_INV_DOUBLE_SLOPE_SLAB_CORNER -> ElevatedSlopeSlabSkipPredicate.testAgainstFlatInverseDoubleSlopeSlabCorner(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_FLAT_ELEV_DOUBLE_SLOPE_SLAB_CORNER -> ElevatedSlopeSlabSkipPredicate.testAgainstFlatElevatedDoubleSlopeSlabCorner(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_FLAT_ELEV_INNER_DOUBLE_SLOPE_SLAB_CORNER -> ElevatedSlopeSlabSkipPredicate.testAgainstFlatElevatedInnerDoubleSlopeSlabCorner(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_SLAB -> ElevatedSlopeSlabSkipPredicate.testAgainstSlab(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_DOUBLE_SLAB -> ElevatedSlopeSlabSkipPredicate.testAgainstDoubleSlab(level, pos, dir, top, side);
                case BlockType.FRAMED_SLAB_EDGE -> ElevatedSlopeSlabSkipPredicate.testAgainstSlabEdge(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_STAIRS -> ElevatedSlopeSlabSkipPredicate.testAgainstStairs(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_DOUBLE_STAIRS -> ElevatedSlopeSlabSkipPredicate.testAgainstDoubleStairs(level, pos, dir, top, adjState, side);
                case BlockType.FRAMED_VERTICAL_HALF_STAIRS -> ElevatedSlopeSlabSkipPredicate.testAgainstVerticalHalfStairs(level, pos, dir, top, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    private static boolean testAgainstElevatedSlopeSlab(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (adjTop != top) {
            return false;
        }
        if (side.m_122434_() == dir.m_122427_().m_122434_() && adjDir == dir) {
            Direction camoDir = top ? Direction.UP : Direction.DOWN;
            return SideSkipPredicate.compareState(level, pos, side, camoDir, camoDir);
        }
        if (side == dir.m_122424_() && adjDir == dir.m_122424_()) {
            Direction camoDir = top ? Direction.UP : Direction.DOWN;
            return SideSkipPredicate.compareState(level, pos, side, camoDir, camoDir);
        }
        return false;
    }

    private static boolean testAgainstSlopeSlab(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTopHalf = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP_HALF);
        if (side == dir.m_122424_() && adjDir == dir && adjTopHalf == top) {
            Direction camoDir = top ? Direction.UP : Direction.DOWN;
            return SideSkipPredicate.compareState(level, pos, side, camoDir, side.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstInverseDoubleSlopeSlab(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        if (side != dir.m_122424_()) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        if (adjDir == dir && top || adjDir == dir.m_122424_() && !top) {
            Direction camoDir = top ? Direction.UP : Direction.DOWN;
            return SideSkipPredicate.compareState(level, pos, side, camoDir, side.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstElevatedDoubleSlopeSlab(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (adjTop == top && side.m_122434_() == dir.m_122427_().m_122434_() && adjDir == dir) {
            Direction camoDir = top ? Direction.UP : Direction.DOWN;
            return SideSkipPredicate.compareState(level, pos, side, camoDir, camoDir);
        }
        if (side == dir.m_122424_() && adjDir == dir.m_122424_()) {
            Direction camoDir = top ? Direction.UP : Direction.DOWN;
            return SideSkipPredicate.compareState(level, pos, side, camoDir, camoDir);
        }
        return false;
    }

    private static boolean testAgainstFlatInnerSlopeSlabCorner(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTopHalf = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP_HALF);
        if (side == dir.m_122424_() && FlatInnerSlopeSlabCornerSkipPredicate.isSlabSide(adjDir, side.m_122424_()) && adjTopHalf == top) {
            Direction camoDir = top ? Direction.UP : Direction.DOWN;
            return SideSkipPredicate.compareState(level, pos, side, camoDir, adjDir);
        }
        return false;
    }

    private static boolean testAgainstFlatElevatedSlopeSlabCorner(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (adjTop != top) {
            return false;
        }
        if (side == dir.m_122424_() && FlatElevatedSlopeSlabCornerSkipPredicate.isSlabSide(adjDir, side.m_122424_())) {
            Direction camoDir = top ? Direction.UP : Direction.DOWN;
            return SideSkipPredicate.compareState(level, pos, side, camoDir, camoDir);
        }
        if (side == dir.m_122427_() && adjDir == dir || side == dir.m_122428_() && adjDir == dir.m_122427_()) {
            Direction camoDir = top ? Direction.UP : Direction.DOWN;
            return SideSkipPredicate.compareState(level, pos, side, camoDir, camoDir);
        }
        return false;
    }

    private static boolean testAgainstFlatElevatedInnerSlopeSlabCorner(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (adjTop != top) {
            return false;
        }
        if (side == dir.m_122428_() && adjDir == dir || side == dir.m_122427_() && adjDir == dir.m_122427_()) {
            Direction camoSide = top ? Direction.UP : Direction.DOWN;
            return SideSkipPredicate.compareState(level, pos, side, camoSide, camoSide);
        }
        return false;
    }

    private static boolean testAgainstFlatDoubleSlopeSlabCorner(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        if (side != dir.m_122424_()) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTopHalf = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP_HALF);
        if (adjTopHalf == top && FlatInnerSlopeSlabCornerSkipPredicate.isSlabSide(adjDir, side.m_122424_())) {
            Direction camoSide = top ? Direction.UP : Direction.DOWN;
            return SideSkipPredicate.compareState(level, pos, side, camoSide, adjDir);
        }
        return false;
    }

    private static boolean testAgainstFlatInverseDoubleSlopeSlabCorner(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        if (side != dir.m_122424_()) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (adjTop == top && FlatInnerSlopeSlabCornerSkipPredicate.isInverseSlabSide(adjDir, side.m_122424_())) {
            Direction camoSide = top ? Direction.UP : Direction.DOWN;
            return SideSkipPredicate.compareState(level, pos, side, camoSide, camoSide);
        }
        return false;
    }

    private static boolean testAgainstFlatElevatedDoubleSlopeSlabCorner(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (adjTop != top) {
            return false;
        }
        if (side == dir.m_122424_() && FlatInnerSlopeSlabCornerSkipPredicate.isInverseSlabSide(adjDir, side.m_122424_())) {
            Direction camoSide = top ? Direction.UP : Direction.DOWN;
            return SideSkipPredicate.compareState(level, pos, side, camoSide, camoSide);
        }
        if (side == dir.m_122427_() && adjDir == dir || side == dir.m_122428_() && adjDir == dir.m_122427_()) {
            Direction camoSide = top ? Direction.UP : Direction.DOWN;
            return SideSkipPredicate.compareState(level, pos, side, camoSide, camoSide);
        }
        return false;
    }

    private static boolean testAgainstFlatElevatedInnerDoubleSlopeSlabCorner(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (adjTop == top && (side == dir.m_122427_() && adjDir == dir.m_122427_() || side == dir.m_122428_() && adjDir == dir)) {
            Direction camoSide = top ? Direction.UP : Direction.DOWN;
            return SideSkipPredicate.compareState(level, pos, side, camoSide, camoSide);
        }
        return false;
    }

    private static boolean testAgainstSlab(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (adjTop == top && side == dir.m_122424_()) {
            Direction camoDir = top ? Direction.UP : Direction.DOWN;
            return SideSkipPredicate.compareState(level, pos, side, camoDir, camoDir);
        }
        return false;
    }

    private static boolean testAgainstDoubleSlab(BlockGetter level, BlockPos pos, Direction dir, boolean top, Direction side) {
        Direction camoSide = top ? Direction.UP : Direction.DOWN;
        return side == dir.m_122424_() && SideSkipPredicate.compareState(level, pos, side, camoSide, camoSide);
    }

    private static boolean testAgainstSlabEdge(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (adjDir == dir && adjTop == top && side == dir.m_122424_()) {
            Direction camoDir = top ? Direction.UP : Direction.DOWN;
            return SideSkipPredicate.compareState(level, pos, side, camoDir, camoDir);
        }
        return false;
    }

    private static boolean testAgainstStairs(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        boolean adjTop;
        Direction adjDir = (Direction)adjState.m_61143_((Property)BlockStateProperties.f_61374_);
        StairsShape adjShape = (StairsShape)adjState.m_61143_((Property)BlockStateProperties.f_61398_);
        boolean bl = adjTop = adjState.m_61143_((Property)BlockStateProperties.f_61402_) == Half.TOP;
        if (adjTop != top || side != dir.m_122424_()) {
            return false;
        }
        if (StairsSkipPredicate.isSlabSide(adjShape, adjDir, side.m_122424_())) {
            Direction camoDir = top ? Direction.UP : Direction.DOWN;
            return SideSkipPredicate.compareState(level, pos, side, camoDir, camoDir);
        }
        return false;
    }

    private static boolean testAgainstDoubleStairs(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)BlockStateProperties.f_61374_);
        if (side != dir.m_122424_() || adjDir != dir.m_122424_()) {
            return false;
        }
        Direction face = top ? Direction.UP : Direction.DOWN;
        return SideSkipPredicate.compareState(level, pos, side, face, face);
    }

    private static boolean testAgainstVerticalHalfStairs(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (side != dir.m_122424_() || adjTop != top) {
            return false;
        }
        if (adjDir == dir || adjDir == dir.m_122427_()) {
            Direction camoDir = top ? Direction.UP : Direction.DOWN;
            return SideSkipPredicate.compareState(level, pos, side, camoDir, camoDir);
        }
        return false;
    }
}

