/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import xfacthd.framedblocks.api.util.SideSkipPredicate;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.blockentity.FramedCollapsibleBlockEntity;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.CollapseFace;

public final class CollapsibleBlockSkipPredicate
implements SideSkipPredicate {
    private static final Table<CollapseFace, Direction, VertexPair> EDGE_MAPPING = CollapsibleBlockSkipPredicate.makeEdgeMappings();

    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        CollapseFace face = (CollapseFace)((Object)state.m_61143_(PropertyHolder.COLLAPSED_FACE));
        if (face == CollapseFace.NONE || side == face.toDirection().m_122424_()) {
            return SideSkipPredicate.CTM.test(level, pos, state, adjState, side);
        }
        if (side == face.toDirection() || !adjState.m_60713_((Block)FBContent.blockFramedCollapsibleBlock.get()) || adjState.m_61143_(PropertyHolder.COLLAPSED_FACE) != face) {
            return false;
        }
        BlockEntity be = Utils.getBlockEntitySafe(level, pos);
        BlockEntity adjBe = Utils.getBlockEntitySafe(level, pos.m_142300_(side));
        if (be instanceof FramedCollapsibleBlockEntity) {
            FramedCollapsibleBlockEntity cbe = (FramedCollapsibleBlockEntity)be;
            if (adjBe instanceof FramedCollapsibleBlockEntity) {
                byte[] adjOffsets;
                FramedCollapsibleBlockEntity adjCbe = (FramedCollapsibleBlockEntity)adjBe;
                VertexPair verts = (VertexPair)Preconditions.checkNotNull((Object)((VertexPair)EDGE_MAPPING.get((Object)face, (Object)side)));
                VertexPair adjVerts = (VertexPair)Preconditions.checkNotNull((Object)((VertexPair)EDGE_MAPPING.get((Object)face, (Object)side.m_122424_())));
                byte[] offsets = cbe.getVertexOffsets();
                if (offsets[verts.v1] == (adjOffsets = adjCbe.getVertexOffsets())[adjVerts.v2] && offsets[verts.v2] == adjOffsets[adjVerts.v1]) {
                    return SideSkipPredicate.compareState(level, pos, side);
                }
            }
        }
        return false;
    }

    private static Table<CollapseFace, Direction, VertexPair> makeEdgeMappings() {
        HashBasedTable table = HashBasedTable.create((int)6, (int)4);
        table.put((Object)CollapseFace.UP, (Object)Direction.NORTH, (Object)new VertexPair(0, 3));
        table.put((Object)CollapseFace.UP, (Object)Direction.EAST, (Object)new VertexPair(3, 2));
        table.put((Object)CollapseFace.UP, (Object)Direction.SOUTH, (Object)new VertexPair(2, 1));
        table.put((Object)CollapseFace.UP, (Object)Direction.WEST, (Object)new VertexPair(1, 0));
        table.put((Object)CollapseFace.DOWN, (Object)Direction.NORTH, (Object)new VertexPair(1, 2));
        table.put((Object)CollapseFace.DOWN, (Object)Direction.EAST, (Object)new VertexPair(2, 3));
        table.put((Object)CollapseFace.DOWN, (Object)Direction.SOUTH, (Object)new VertexPair(3, 0));
        table.put((Object)CollapseFace.DOWN, (Object)Direction.WEST, (Object)new VertexPair(0, 1));
        table.put((Object)CollapseFace.NORTH, (Object)Direction.UP, (Object)new VertexPair(0, 3));
        table.put((Object)CollapseFace.NORTH, (Object)Direction.WEST, (Object)new VertexPair(3, 2));
        table.put((Object)CollapseFace.NORTH, (Object)Direction.DOWN, (Object)new VertexPair(2, 1));
        table.put((Object)CollapseFace.NORTH, (Object)Direction.EAST, (Object)new VertexPair(1, 0));
        table.put((Object)CollapseFace.EAST, (Object)Direction.UP, (Object)new VertexPair(0, 3));
        table.put((Object)CollapseFace.EAST, (Object)Direction.NORTH, (Object)new VertexPair(3, 2));
        table.put((Object)CollapseFace.EAST, (Object)Direction.DOWN, (Object)new VertexPair(2, 1));
        table.put((Object)CollapseFace.EAST, (Object)Direction.SOUTH, (Object)new VertexPair(1, 0));
        table.put((Object)CollapseFace.SOUTH, (Object)Direction.UP, (Object)new VertexPair(0, 3));
        table.put((Object)CollapseFace.SOUTH, (Object)Direction.EAST, (Object)new VertexPair(3, 2));
        table.put((Object)CollapseFace.SOUTH, (Object)Direction.DOWN, (Object)new VertexPair(2, 1));
        table.put((Object)CollapseFace.SOUTH, (Object)Direction.WEST, (Object)new VertexPair(1, 0));
        table.put((Object)CollapseFace.WEST, (Object)Direction.UP, (Object)new VertexPair(0, 3));
        table.put((Object)CollapseFace.WEST, (Object)Direction.SOUTH, (Object)new VertexPair(3, 2));
        table.put((Object)CollapseFace.WEST, (Object)Direction.DOWN, (Object)new VertexPair(2, 1));
        table.put((Object)CollapseFace.WEST, (Object)Direction.NORTH, (Object)new VertexPair(1, 0));
        return table;
    }

    private record VertexPair(int v1, int v2) {
    }
}

