/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Locale;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.type.IBlockType;
import xfacthd.framedblocks.api.util.CtmPredicate;
import xfacthd.framedblocks.api.util.SideSkipPredicate;
import xfacthd.framedblocks.api.util.VoxelShapeGenerator;
import xfacthd.framedblocks.common.block.FramedCollapsibleBlock;
import xfacthd.framedblocks.common.block.FramedCornerPillarBlock;
import xfacthd.framedblocks.common.block.FramedCornerSlopeBlock;
import xfacthd.framedblocks.common.block.FramedDoorBlock;
import xfacthd.framedblocks.common.block.FramedDoubleCornerBlock;
import xfacthd.framedblocks.common.block.FramedDoublePanelBlock;
import xfacthd.framedblocks.common.block.FramedDoubleSlopeBlock;
import xfacthd.framedblocks.common.block.FramedDoubleSlopePanelBlock;
import xfacthd.framedblocks.common.block.FramedDoubleSlopeSlabBlock;
import xfacthd.framedblocks.common.block.FramedDoubleStairsBlock;
import xfacthd.framedblocks.common.block.FramedDoubleThreewayCornerBlock;
import xfacthd.framedblocks.common.block.FramedElevatedDoubleSlopeSlabBlock;
import xfacthd.framedblocks.common.block.FramedElevatedSlopeSlabBlock;
import xfacthd.framedblocks.common.block.FramedExtendedDoubleSlopePanelBlock;
import xfacthd.framedblocks.common.block.FramedExtendedSlopePanelBlock;
import xfacthd.framedblocks.common.block.FramedFenceBlock;
import xfacthd.framedblocks.common.block.FramedFenceGateBlock;
import xfacthd.framedblocks.common.block.FramedFlatDoubleSlopePanelCornerBlock;
import xfacthd.framedblocks.common.block.FramedFlatDoubleSlopeSlabCornerBlock;
import xfacthd.framedblocks.common.block.FramedFlatElevatedDoubleSlopeSlabCornerBlock;
import xfacthd.framedblocks.common.block.FramedFlatElevatedSlopeSlabCornerBlock;
import xfacthd.framedblocks.common.block.FramedFlatExtendedDoubleSlopePanelCornerBlock;
import xfacthd.framedblocks.common.block.FramedFlatExtendedSlopePanelCornerBlock;
import xfacthd.framedblocks.common.block.FramedFlatInverseDoubleSlopePanelCornerBlock;
import xfacthd.framedblocks.common.block.FramedFlatInverseDoubleSlopeSlabCornerBlock;
import xfacthd.framedblocks.common.block.FramedFlatSlopePanelCornerBlock;
import xfacthd.framedblocks.common.block.FramedFlatSlopeSlabCornerBlock;
import xfacthd.framedblocks.common.block.FramedFloorBlock;
import xfacthd.framedblocks.common.block.FramedHalfPillarBlock;
import xfacthd.framedblocks.common.block.FramedHalfStairsBlock;
import xfacthd.framedblocks.common.block.FramedHorizontalPaneBlock;
import xfacthd.framedblocks.common.block.FramedInverseDoubleSlopePanelBlock;
import xfacthd.framedblocks.common.block.FramedInverseDoubleSlopeSlabBlock;
import xfacthd.framedblocks.common.block.FramedLatticeBlock;
import xfacthd.framedblocks.common.block.FramedPanelBlock;
import xfacthd.framedblocks.common.block.FramedPillarBlock;
import xfacthd.framedblocks.common.block.FramedPrismBlock;
import xfacthd.framedblocks.common.block.FramedPrismCornerBlock;
import xfacthd.framedblocks.common.block.FramedPyramidBlock;
import xfacthd.framedblocks.common.block.FramedSlabBlock;
import xfacthd.framedblocks.common.block.FramedSlabCornerBlock;
import xfacthd.framedblocks.common.block.FramedSlabEdgeBlock;
import xfacthd.framedblocks.common.block.FramedSlopeBlock;
import xfacthd.framedblocks.common.block.FramedSlopePanelBlock;
import xfacthd.framedblocks.common.block.FramedSlopeSlabBlock;
import xfacthd.framedblocks.common.block.FramedSlopedPrismBlock;
import xfacthd.framedblocks.common.block.FramedStairsBlock;
import xfacthd.framedblocks.common.block.FramedThreewayCornerBlock;
import xfacthd.framedblocks.common.block.FramedTrapDoorBlock;
import xfacthd.framedblocks.common.block.FramedVerticalDoubleStairsBlock;
import xfacthd.framedblocks.common.block.FramedVerticalHalfStairsBlock;
import xfacthd.framedblocks.common.block.FramedVerticalStairsBlock;
import xfacthd.framedblocks.common.block.FramedWallBoardBlock;
import xfacthd.framedblocks.common.block.FramedWallSignBlock;
import xfacthd.framedblocks.common.data.skippreds.CollapsibleBlockSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.CornerPillarSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.CornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.DoorSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.ElevatedSlopeSlabSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.ExtendedSlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.FlatElevatedInnerSlopeSlabCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.FlatElevatedSlopeSlabCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.FlatExtendedInnerSlopePanelCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.FlatExtendedSlopePanelCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.FlatInnerSlopePanelCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.FlatInnerSlopeSlabCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.FlatSlopePanelCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.FlatSlopeSlabCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.GateSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.HalfPillarSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.HalfStairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.InnerCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.InnerThreewayCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.PaneSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.PanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.PillarSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.PostSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.SlabCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.SlabEdgeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.SlabSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.SlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.SlopeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.SlopeSlabSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.StairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.ThreewayCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.TrapdoorSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.VerticalHalfStairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.VerticalStairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.WallSkipPredicate;

public enum BlockType implements IBlockType
{
    FRAMED_CUBE(true, false, false, false, true, true, false, false, CtmPredicate.TRUE, SideSkipPredicate.CTM, Shapes.m_83144_()),
    FRAMED_SLOPE(true, true, false, true, true, true, false, false, FramedSlopeBlock.CTM_PREDICATE, (SideSkipPredicate)new SlopeSkipPredicate(), FramedSlopeBlock::generateShapes),
    FRAMED_CORNER_SLOPE(true, true, false, true, true, true, false, false, FramedCornerSlopeBlock.CTM_PREDICATE, (SideSkipPredicate)new CornerSkipPredicate(), FramedCornerSlopeBlock::generateCornerShapes),
    FRAMED_INNER_CORNER_SLOPE(true, true, false, true, true, true, false, false, FramedCornerSlopeBlock.CTM_PREDICATE_INNER, (SideSkipPredicate)new InnerCornerSkipPredicate(), FramedCornerSlopeBlock::generateInnerCornerShapes),
    FRAMED_PRISM_CORNER(true, true, false, true, true, true, false, false, CtmPredicate.FALSE, (SideSkipPredicate)new ThreewayCornerSkipPredicate(), FramedPrismCornerBlock::generatePrismShapes),
    FRAMED_INNER_PRISM_CORNER(true, true, false, true, true, true, false, false, FramedThreewayCornerBlock.CTM_PREDICATE, (SideSkipPredicate)new InnerThreewayCornerSkipPredicate(), FramedPrismCornerBlock::generateInnerPrismShapes),
    FRAMED_THREEWAY_CORNER(true, true, false, true, true, true, false, false, CtmPredicate.FALSE, (SideSkipPredicate)new ThreewayCornerSkipPredicate(), FramedThreewayCornerBlock::generateThreewayShapes),
    FRAMED_INNER_THREEWAY_CORNER(true, true, false, true, true, true, false, false, FramedThreewayCornerBlock.CTM_PREDICATE, (SideSkipPredicate)new InnerThreewayCornerSkipPredicate(), FramedThreewayCornerBlock::generateInnerThreewayShapes),
    FRAMED_SLAB(true, false, false, true, true, true, false, false, CtmPredicate.TOP, (SideSkipPredicate)new SlabSkipPredicate(), FramedSlabBlock::generateShapes),
    FRAMED_SLAB_EDGE(false, false, false, true, true, true, false, false, CtmPredicate.FALSE, (SideSkipPredicate)new SlabEdgeSkipPredicate(), FramedSlabEdgeBlock::generateShapes),
    FRAMED_SLAB_CORNER(false, false, false, true, true, true, false, false, CtmPredicate.FALSE, (SideSkipPredicate)new SlabCornerSkipPredicate(), FramedSlabCornerBlock::generateShapes),
    FRAMED_PANEL(true, false, false, true, true, true, false, false, CtmPredicate.HOR_DIR, (SideSkipPredicate)new PanelSkipPredicate(), FramedPanelBlock::generateShapes),
    FRAMED_CORNER_PILLAR(false, false, false, true, true, true, false, false, CtmPredicate.FALSE, (SideSkipPredicate)new CornerPillarSkipPredicate(), FramedCornerPillarBlock::generateShapes),
    FRAMED_STAIRS(true, false, false, true, true, true, false, true, FramedStairsBlock.CTM_PREDICATE, new StairsSkipPredicate()),
    FRAMED_WALL(false, false, false, true, true, false, false, true, CtmPredicate.FALSE, new WallSkipPredicate()),
    FRAMED_FENCE(false, false, false, true, true, false, false, true, CtmPredicate.FALSE, FramedFenceBlock.SKIP_PREDICATE),
    FRAMED_GATE(false, false, false, true, true, false, false, false, CtmPredicate.FALSE, FramedFenceGateBlock.SKIP_PREDICATE),
    FRAMED_DOOR(true, false, false, false, true, false, false, false, FramedDoorBlock.CTM_PREDICATE, new DoorSkipPredicate()),
    FRAMED_IRON_DOOR(true, false, false, false, true, false, false, false, FramedDoorBlock.CTM_PREDICATE, new DoorSkipPredicate()),
    FRAMED_TRAPDOOR(true, false, false, true, true, false, false, false, FramedTrapDoorBlock.CTM_PREDICATE, new TrapdoorSkipPredicate()),
    FRAMED_IRON_TRAPDOOR(true, false, false, true, true, false, false, false, FramedTrapDoorBlock.CTM_PREDICATE, new TrapdoorSkipPredicate()),
    FRAMED_PRESSURE_PLATE(false, false, false, false, true, false, false, false),
    FRAMED_STONE_PRESSURE_PLATE(false, false, false, false, true, false, false, false),
    FRAMED_OBSIDIAN_PRESSURE_PLATE(false, false, false, false, true, false, false, false),
    FRAMED_IRON_PRESSURE_PLATE(false, false, false, false, true, false, false, false),
    FRAMED_GOLD_PRESSURE_PLATE(false, false, false, false, true, false, false, false),
    FRAMED_LADDER(false, false, false, true, true, false, false, false),
    FRAMED_BUTTON(false, false, false, false, true, false, false, false),
    FRAMED_STONE_BUTTON(false, false, false, false, true, false, false, false),
    FRAMED_LEVER(false, false, false, false, true, false, false, false),
    FRAMED_SIGN(false, false, true, false, true, false, false, false),
    FRAMED_WALL_SIGN(false, false, true, false, false, false, false, false, FramedWallSignBlock::generateShapes),
    FRAMED_DOUBLE_SLAB(true, false, true, false, true, true, true, false, CtmPredicate.Y_AXIS, Shapes.m_83144_()),
    FRAMED_DOUBLE_PANEL(true, false, true, false, true, true, true, false, FramedDoublePanelBlock.CTM_PREDICATE, Shapes.m_83144_()),
    FRAMED_DOUBLE_SLOPE(true, false, true, false, true, true, true, false, FramedDoubleSlopeBlock.CTM_PREDICATE, Shapes.m_83144_()),
    FRAMED_DOUBLE_CORNER(true, false, true, false, true, true, true, false, FramedDoubleCornerBlock.CTM_PREDICATE, Shapes.m_83144_()),
    FRAMED_DOUBLE_PRISM_CORNER(true, false, true, false, true, true, true, false, FramedDoubleThreewayCornerBlock.CTM_PREDICATE, Shapes.m_83144_()),
    FRAMED_DOUBLE_THREEWAY_CORNER(true, false, true, false, true, true, true, false, FramedDoubleThreewayCornerBlock.CTM_PREDICATE, Shapes.m_83144_()),
    FRAMED_TORCH(false, false, false, false, true, false, false, false),
    FRAMED_WALL_TORCH(false, false, false, false, false, false, false, false),
    FRAMED_SOUL_TORCH(false, false, false, false, true, false, false, false),
    FRAMED_SOUL_WALL_TORCH(false, false, false, false, false, false, false, false),
    FRAMED_REDSTONE_TORCH(false, false, false, false, true, false, false, false),
    FRAMED_REDSTONE_WALL_TORCH(false, false, false, false, false, false, false, false),
    FRAMED_FLOOR_BOARD(true, false, false, true, true, true, false, false, CtmPredicate.TOP, FramedFloorBlock.SKIP_PREDICATE, FramedFloorBlock::generateShapes),
    FRAMED_LATTICE_BLOCK(false, false, false, true, true, true, false, true, CtmPredicate.FALSE, FramedLatticeBlock.SKIP_PREDICATE, FramedLatticeBlock::generateShapes),
    FRAMED_VERTICAL_STAIRS(true, false, false, true, true, true, false, true, FramedVerticalStairsBlock.CTM_PREDICATE, (SideSkipPredicate)new VerticalStairsSkipPredicate(), FramedVerticalStairsBlock::generateShapes),
    FRAMED_CHEST(false, false, true, true, true, false, false, false, Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.875, (double)0.9375)),
    FRAMED_BARS(false, false, false, true, true, true, false, true),
    FRAMED_PANE(false, false, false, true, true, true, false, true, CtmPredicate.FALSE, new PaneSkipPredicate()),
    FRAMED_RAIL_SLOPE(true, true, false, true, true, false, false, false, FramedSlopeBlock.CTM_PREDICATE, (SideSkipPredicate)new SlopeSkipPredicate(), FramedSlopeBlock::generateShapes),
    FRAMED_FLOWER_POT(false, false, true, false, true, false, false, false, Shapes.m_83048_((double)0.3125, (double)0.0, (double)0.3125, (double)0.6875, (double)0.375, (double)0.6875)),
    FRAMED_PILLAR(false, false, false, true, true, true, false, false, CtmPredicate.FALSE, (SideSkipPredicate)new PillarSkipPredicate(), FramedPillarBlock::generatePillarShapes),
    FRAMED_HALF_PILLAR(false, false, false, true, true, true, false, false, CtmPredicate.FALSE, (SideSkipPredicate)new HalfPillarSkipPredicate(), FramedHalfPillarBlock::generateShapes),
    FRAMED_POST(false, false, false, true, true, true, false, false, CtmPredicate.FALSE, (SideSkipPredicate)new PostSkipPredicate(), FramedPillarBlock::generatePostShapes),
    FRAMED_COLLAPSIBLE_BLOCK(false, true, true, true, true, true, false, false, FramedCollapsibleBlock.CTM_PREDICATE, new CollapsibleBlockSkipPredicate()),
    FRAMED_HALF_STAIRS(false, false, false, true, true, true, false, false, CtmPredicate.FALSE, (SideSkipPredicate)new HalfStairsSkipPredicate(), FramedHalfStairsBlock::generateShapes),
    FRAMED_BOUNCY_CUBE(true, false, false, false, true, false, false, false, CtmPredicate.TRUE, SideSkipPredicate.CTM, Shapes.m_83144_()),
    FRAMED_SECRET_STORAGE(true, false, true, false, true, false, false, false, CtmPredicate.TRUE, SideSkipPredicate.CTM, Shapes.m_83144_()),
    FRAMED_REDSTONE_BLOCK(true, false, false, false, true, true, false, false, CtmPredicate.TRUE, SideSkipPredicate.CTM, Shapes.m_83144_()),
    FRAMED_PRISM(true, true, false, true, true, true, false, false, FramedPrismBlock.CTM_PREDICATE, FramedPrismBlock.SKIP_PREDICATE, FramedPrismBlock::generateShapes),
    FRAMED_SLOPED_PRISM(true, true, false, true, true, true, false, false, FramedSlopedPrismBlock.CTM_PREDICATE, FramedSlopedPrismBlock.SKIP_PREDICATE, FramedSlopedPrismBlock::generateShapes),
    FRAMED_SLOPE_SLAB(true, true, false, true, true, true, false, false, FramedSlopeSlabBlock.CTM_PREDICATE, (SideSkipPredicate)new SlopeSlabSkipPredicate(), FramedSlopeSlabBlock::generateShapes),
    FRAMED_ELEVATED_SLOPE_SLAB(true, true, true, true, true, true, false, false, FramedElevatedSlopeSlabBlock.CTM_PREDICATE, (SideSkipPredicate)new ElevatedSlopeSlabSkipPredicate(), FramedElevatedSlopeSlabBlock::generateShapes),
    FRAMED_DOUBLE_SLOPE_SLAB(true, false, true, true, true, true, true, false, FramedDoubleSlopeSlabBlock.CTM_PREDICATE),
    FRAMED_INV_DOUBLE_SLOPE_SLAB(true, true, true, true, true, true, true, false, CtmPredicate.FALSE, FramedInverseDoubleSlopeSlabBlock::generateShapes),
    FRAMED_ELEVATED_DOUBLE_SLOPE_SLAB(true, false, true, false, true, true, true, false, FramedElevatedDoubleSlopeSlabBlock.CTM_PREDICATE, Shapes.m_83144_()),
    FRAMED_FLAT_SLOPE_SLAB_CORNER(true, true, false, true, true, true, false, false, FramedFlatSlopeSlabCornerBlock.CTM_PREDICATE, (SideSkipPredicate)new FlatSlopeSlabCornerSkipPredicate(), FramedFlatSlopeSlabCornerBlock::generateShapes),
    FRAMED_FLAT_INNER_SLOPE_SLAB_CORNER(true, true, false, true, true, true, false, false, FramedFlatSlopeSlabCornerBlock.CTM_PREDICATE, (SideSkipPredicate)new FlatInnerSlopeSlabCornerSkipPredicate(), FramedFlatSlopeSlabCornerBlock::generateInnerShapes),
    FRAMED_FLAT_ELEV_SLOPE_SLAB_CORNER(true, true, false, true, true, true, false, false, FramedFlatElevatedSlopeSlabCornerBlock.CTM_PREDICATE, (SideSkipPredicate)new FlatElevatedSlopeSlabCornerSkipPredicate(), FramedFlatElevatedSlopeSlabCornerBlock::generateShapes),
    FRAMED_FLAT_ELEV_INNER_SLOPE_SLAB_CORNER(true, true, false, true, true, true, false, false, FramedFlatElevatedSlopeSlabCornerBlock.CTM_PREDICATE_INNER, (SideSkipPredicate)new FlatElevatedInnerSlopeSlabCornerSkipPredicate(), FramedFlatElevatedSlopeSlabCornerBlock::generateInnerShapes),
    FRAMED_FLAT_DOUBLE_SLOPE_SLAB_CORNER(true, false, true, true, true, true, true, false, FramedFlatDoubleSlopeSlabCornerBlock.CTM_PREDICATE, FramedFlatDoubleSlopeSlabCornerBlock::generateShapes),
    FRAMED_FLAT_INV_DOUBLE_SLOPE_SLAB_CORNER(true, true, true, true, true, true, true, false, FramedFlatInverseDoubleSlopeSlabCornerBlock::generateShapes),
    FRAMED_FLAT_ELEV_DOUBLE_SLOPE_SLAB_CORNER(true, false, true, false, true, true, true, false, CtmPredicate.Y_AXIS, Shapes.m_83144_()),
    FRAMED_FLAT_ELEV_INNER_DOUBLE_SLOPE_SLAB_CORNER(true, false, true, false, true, true, true, false, FramedFlatElevatedDoubleSlopeSlabCornerBlock.CTM_PREDICATE, Shapes.m_83144_()),
    FRAMED_VERTICAL_HALF_STAIRS(false, false, false, true, true, false, false, false, CtmPredicate.FALSE, (SideSkipPredicate)new VerticalHalfStairsSkipPredicate(), FramedVerticalHalfStairsBlock::generateShapes),
    FRAMED_SLOPE_PANEL(true, true, false, true, true, true, false, false, FramedSlopePanelBlock.CTM_PREDICATE, (SideSkipPredicate)new SlopePanelSkipPredicate(), FramedSlopePanelBlock::generateShapes),
    FRAMED_EXTENDED_SLOPE_PANEL(true, true, true, true, true, true, false, false, FramedExtendedSlopePanelBlock.CTM_PREDICATE, (SideSkipPredicate)new ExtendedSlopePanelSkipPredicate(), FramedExtendedSlopePanelBlock::generateShapes),
    FRAMED_DOUBLE_SLOPE_PANEL(true, false, true, true, true, true, true, false, FramedDoubleSlopePanelBlock.CTM_PREDICATE, FramedDoubleSlopePanelBlock::generateShapes),
    FRAMED_INV_DOUBLE_SLOPE_PANEL(true, true, true, true, true, true, true, false, CtmPredicate.FALSE, FramedInverseDoubleSlopePanelBlock::generateShapes),
    FRAMED_EXTENDED_DOUBLE_SLOPE_PANEL(true, false, true, false, true, true, true, false, FramedExtendedDoubleSlopePanelBlock.CTM_PREDICATE, Shapes.m_83144_()),
    FRAMED_FLAT_SLOPE_PANEL_CORNER(true, true, false, true, true, true, false, false, FramedSlopePanelBlock.CTM_PREDICATE, (SideSkipPredicate)new FlatSlopePanelCornerSkipPredicate(), FramedFlatSlopePanelCornerBlock::generateShapes),
    FRAMED_FLAT_INNER_SLOPE_PANEL_CORNER(true, true, false, true, true, true, false, false, FramedSlopePanelBlock.CTM_PREDICATE, (SideSkipPredicate)new FlatInnerSlopePanelCornerSkipPredicate(), FramedFlatSlopePanelCornerBlock::generateInnerShapes),
    FRAMED_FLAT_EXT_SLOPE_PANEL_CORNER(true, true, false, true, true, true, false, false, CtmPredicate.HOR_DIR, (SideSkipPredicate)new FlatExtendedSlopePanelCornerSkipPredicate(), FramedFlatExtendedSlopePanelCornerBlock::generateShapes),
    FRAMED_FLAT_EXT_INNER_SLOPE_PANEL_CORNER(true, true, false, true, true, true, false, false, FramedFlatExtendedSlopePanelCornerBlock.CTM_PREDICATE, (SideSkipPredicate)new FlatExtendedInnerSlopePanelCornerSkipPredicate(), FramedFlatExtendedSlopePanelCornerBlock::generateInnerShapes),
    FRAMED_FLAT_DOUBLE_SLOPE_PANEL_CORNER(true, false, true, true, true, true, true, false, FramedFlatDoubleSlopePanelCornerBlock.CTM_PREDICATE, FramedFlatDoubleSlopePanelCornerBlock::generateShapes),
    FRAMED_FLAT_INV_DOUBLE_SLOPE_PANEL_CORNER(true, true, true, true, true, true, true, false, FramedFlatInverseDoubleSlopePanelCornerBlock::generateShapes),
    FRAMED_FLAT_EXT_DOUBLE_SLOPE_PANEL_CORNER(true, false, true, false, true, true, true, false, CtmPredicate.HOR_DIR_AXIS, Shapes.m_83144_()),
    FRAMED_FLAT_EXT_INNER_DOUBLE_SLOPE_PANEL_CORNER(true, false, true, false, true, true, true, false, FramedFlatExtendedDoubleSlopePanelCornerBlock.CTM_PREDICATE, Shapes.m_83144_()),
    FRAMED_DOUBLE_STAIRS(true, false, true, false, true, true, true, false, FramedDoubleStairsBlock.CTM_PREDICATE, Shapes.m_83144_()),
    FRAMED_VERTICAL_DOUBLE_STAIRS(true, false, true, false, true, true, true, false, FramedVerticalDoubleStairsBlock.CTM_PREDICATE, Shapes.m_83144_()),
    FRAMED_WALL_BOARD(true, false, false, true, true, true, false, false, CtmPredicate.HOR_DIR, FramedWallBoardBlock.SKIP_PREDICATE, FramedWallBoardBlock::generateShapes),
    FRAMED_GLOWING_CUBE(true, false, false, false, true, true, false, false, CtmPredicate.TRUE, SideSkipPredicate.CTM, Shapes.m_83144_()),
    FRAMED_PYRAMID(true, true, false, true, true, true, false, false, CtmPredicate.DIR_OPPOSITE, SideSkipPredicate.CTM, FramedPyramidBlock::generateShapes),
    FRAMED_PYRAMID_SLAB(true, true, false, true, true, true, false, false, CtmPredicate.DIR_OPPOSITE, SideSkipPredicate.CTM, FramedPyramidBlock::generateSlabShapes),
    FRAMED_LARGE_BUTTON(false, false, false, false, true, false, false, false),
    FRAMED_LARGE_STONE_BUTTON(false, false, false, false, true, false, false, false),
    FRAMED_HORIZONTAL_PANE(true, false, false, true, true, true, false, false, CtmPredicate.FALSE, FramedHorizontalPaneBlock.SKIP_PREDICATE, Shapes.m_83048_((double)0.0, (double)0.4375, (double)0.0, (double)1.0, (double)0.5625, (double)1.0)),
    FRAMED_TARGET(true, false, false, false, true, true, false, false, CtmPredicate.TRUE, SideSkipPredicate.CTM, Shapes.m_83144_()),
    FRAMED_GATE_DOOR(true, false, false, false, true, false, false, false, FramedDoorBlock.CTM_PREDICATE, new GateSkipPredicate()),
    FRAMED_IRON_GATE_DOOR(true, false, false, false, true, false, false, false, FramedDoorBlock.CTM_PREDICATE, new GateSkipPredicate());

    private final String name = this.toString().toLowerCase(Locale.ROOT);
    private final boolean canOcclude;
    private final boolean specialHitbox;
    private final boolean specialTile;
    private final boolean waterloggable;
    private final boolean blockItem;
    private final boolean allowIntangible;
    private final boolean doubleBlock;
    private final boolean lockable;
    private final CtmPredicate ctmPredicate;
    private final SideSkipPredicate skipPredicate;
    private final VoxelShapeGenerator shapeGen;

    private BlockType(boolean canOcclude, boolean specialHitbox, boolean specialTile, boolean waterloggable, boolean blockItem, boolean allowIntangible, boolean doubleBlock, boolean lockable) {
        this(canOcclude, specialHitbox, specialTile, waterloggable, blockItem, allowIntangible, doubleBlock, lockable, CtmPredicate.FALSE, SideSkipPredicate.FALSE, VoxelShapeGenerator.EMTPTY);
    }

    private BlockType(boolean canOcclude, boolean specialHitbox, boolean specialTile, boolean waterloggable, boolean blockItem, boolean allowIntangible, boolean doubleBlock, boolean lockable, VoxelShape shape) {
        this(canOcclude, specialHitbox, specialTile, waterloggable, blockItem, allowIntangible, doubleBlock, lockable, CtmPredicate.FALSE, SideSkipPredicate.FALSE, shape);
    }

    private BlockType(boolean canOcclude, boolean specialHitbox, boolean specialTile, boolean waterloggable, boolean blockItem, boolean allowIntangible, boolean doubleBlock, boolean lockable, VoxelShapeGenerator shapeGen) {
        this(canOcclude, specialHitbox, specialTile, waterloggable, blockItem, allowIntangible, doubleBlock, lockable, CtmPredicate.FALSE, SideSkipPredicate.FALSE, shapeGen);
    }

    private BlockType(boolean canOcclude, boolean specialHitbox, boolean specialTile, boolean waterloggable, boolean blockItem, boolean allowIntangible, boolean doubleBlock, boolean lockable, CtmPredicate ctmPredicate) {
        this(canOcclude, specialHitbox, specialTile, waterloggable, blockItem, allowIntangible, doubleBlock, lockable, ctmPredicate, SideSkipPredicate.FALSE, VoxelShapeGenerator.EMTPTY);
    }

    private BlockType(boolean canOcclude, boolean specialHitbox, boolean specialTile, boolean waterloggable, boolean blockItem, boolean allowIntangible, boolean doubleBlock, boolean lockable, CtmPredicate ctmPredicate, VoxelShape shape) {
        this(canOcclude, specialHitbox, specialTile, waterloggable, blockItem, allowIntangible, doubleBlock, lockable, ctmPredicate, SideSkipPredicate.FALSE, shape);
    }

    private BlockType(boolean canOcclude, boolean specialHitbox, boolean specialTile, boolean waterloggable, boolean blockItem, boolean allowIntangible, boolean doubleBlock, boolean lockable, CtmPredicate ctmPredicate, VoxelShapeGenerator shapeGen) {
        this(canOcclude, specialHitbox, specialTile, waterloggable, blockItem, allowIntangible, doubleBlock, lockable, ctmPredicate, SideSkipPredicate.FALSE, shapeGen);
    }

    private BlockType(boolean canOcclude, boolean specialHitbox, boolean specialTile, boolean waterloggable, boolean blockItem, boolean allowIntangible, boolean doubleBlock, boolean lockable, CtmPredicate ctmPredicate, SideSkipPredicate skipPredicate) {
        this(canOcclude, specialHitbox, specialTile, waterloggable, blockItem, allowIntangible, doubleBlock, lockable, ctmPredicate, skipPredicate, VoxelShapeGenerator.EMTPTY);
    }

    private BlockType(boolean canOcclude, boolean specialHitbox, boolean specialTile, boolean waterloggable, boolean blockItem, boolean allowIntangible, boolean doubleBlock, boolean lockable, CtmPredicate ctmPredicate, SideSkipPredicate skipPredicate, VoxelShape shape) {
        this(canOcclude, specialHitbox, specialTile, waterloggable, blockItem, allowIntangible, doubleBlock, lockable, ctmPredicate, skipPredicate, VoxelShapeGenerator.singleShape(shape));
    }

    private BlockType(boolean canOcclude, boolean specialHitbox, boolean specialTile, boolean waterloggable, boolean blockItem, boolean allowIntangible, boolean doubleBlock, boolean lockable, CtmPredicate ctmPredicate, SideSkipPredicate skipPredicate, VoxelShapeGenerator shapeGen) {
        this.canOcclude = canOcclude;
        this.specialHitbox = specialHitbox;
        this.specialTile = specialTile;
        this.waterloggable = waterloggable;
        this.blockItem = blockItem;
        this.allowIntangible = allowIntangible;
        this.doubleBlock = doubleBlock;
        this.lockable = lockable;
        this.ctmPredicate = ctmPredicate;
        this.skipPredicate = skipPredicate;
        this.shapeGen = shapeGen;
    }

    @Override
    public boolean canOccludeWithSolidCamo() {
        return this.canOcclude;
    }

    @Override
    public boolean hasSpecialHitbox() {
        return this.specialHitbox;
    }

    @Override
    public CtmPredicate getCtmPredicate() {
        return this.ctmPredicate;
    }

    @Override
    public SideSkipPredicate getSideSkipPredicate() {
        return this.skipPredicate;
    }

    @Override
    public ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        return this.shapeGen.generate(states);
    }

    @Override
    public boolean hasSpecialTile() {
        return this.specialTile;
    }

    @Override
    public boolean hasBlockItem() {
        return this.blockItem;
    }

    @Override
    public boolean supportsWaterLogging() {
        return this.waterloggable;
    }

    @Override
    public boolean allowMakingIntangible() {
        return this.allowIntangible;
    }

    @Override
    public boolean isDoubleBlock() {
        return this.doubleBlock;
    }

    @Override
    public boolean canLockState() {
        return this.lockable;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int compareTo(IBlockType other) {
        if (!(other instanceof BlockType)) {
            return 1;
        }
        BlockType type = (BlockType)other;
        return this.compareTo(type);
    }
}

