/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.blockentity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.blockentity.FramedDoubleBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;
import xfacthd.framedblocks.common.util.DoubleSoundMode;

public class FramedFlatExtendedDoubleSlopePanelCornerBlockEntity
extends FramedDoubleBlockEntity {
    private final boolean isInner = this.getBlockType() == BlockType.FRAMED_FLAT_EXT_INNER_DOUBLE_SLOPE_PANEL_CORNER;

    public FramedFlatExtendedDoubleSlopePanelCornerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FBContent.blockEntityTypeFramedFlatExtendedDoubleSlopePanelCorner.get(), pos, state);
    }

    @Override
    protected boolean hitSecondary(BlockHitResult hit) {
        double perpHor;
        Direction perpDir;
        double hor;
        Direction facing;
        Direction side = hit.m_82434_();
        if (side == (facing = (Direction)this.m_58900_().m_61143_((Property)FramedProperties.FACING_HOR))) {
            return false;
        }
        if (side == facing.m_122424_()) {
            return true;
        }
        HorizontalRotation rotation = (HorizontalRotation)((Object)this.m_58900_().m_61143_(PropertyHolder.ROTATION));
        Direction rotDir = rotation.withFacing(facing);
        Direction perpRotDir = rotation.rotate(Rotation.COUNTERCLOCKWISE_90).withFacing(facing);
        if (this.isInner && (side == rotDir.m_122424_() || side == perpRotDir.m_122424_())) {
            return false;
        }
        Vec3 vec = Utils.fraction(hit.m_82450_());
        double d = hor = Utils.isX(facing) ? vec.m_7096_() : vec.m_7094_();
        if (!Utils.isPositive(facing)) {
            hor = 1.0 - hor;
        }
        if (this.isInner) {
            perpDir = side == rotDir ? perpRotDir : rotDir;
        } else {
            Direction direction = perpDir = side == rotDir.m_122424_() ? perpRotDir.m_122424_() : rotDir.m_122424_();
        }
        double d2 = perpHor = Utils.isY(perpDir) ? vec.m_7098_() : (Utils.isX(facing) ? vec.m_7094_() : vec.m_7096_());
        if ((perpDir == Direction.DOWN || !Utils.isY(perpDir) && !Utils.isPositive(perpDir)) == this.isInner) {
            perpHor = 1.0 - perpHor;
        }
        return hor * 2.0 < perpHor;
    }

    @Override
    public DoubleSoundMode getSoundMode() {
        HorizontalRotation rotation;
        if (this.isInner && ((rotation = (HorizontalRotation)((Object)this.m_58900_().m_61143_(PropertyHolder.ROTATION))) == HorizontalRotation.UP || rotation == HorizontalRotation.RIGHT)) {
            return DoubleSoundMode.FIRST;
        }
        return DoubleSoundMode.EITHER;
    }

    @Override
    public BlockState getCamoState(Direction side) {
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)FramedProperties.FACING_HOR);
        if (side == facing) {
            return this.getCamoState();
        }
        if (side == facing.m_122424_()) {
            return this.getCamoStateTwo();
        }
        HorizontalRotation rotation = (HorizontalRotation)((Object)this.m_58900_().m_61143_(PropertyHolder.ROTATION));
        Direction rotDir = rotation.withFacing(facing);
        Direction perpRotDir = rotation.rotate(Rotation.COUNTERCLOCKWISE_90).withFacing(facing);
        if (side == rotDir || side == perpRotDir) {
            return this.getCamoStateTwo();
        }
        return this.getCamoState();
    }

    @Override
    public boolean isSolidSide(Direction side) {
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)FramedProperties.FACING_HOR);
        if (side == facing) {
            return this.getCamoState().m_60804_((BlockGetter)this.f_58857_, this.f_58858_);
        }
        if (side == facing.m_122424_()) {
            return this.getCamoStateTwo().m_60804_((BlockGetter)this.f_58857_, this.f_58858_);
        }
        if (this.isInner) {
            HorizontalRotation rotation = (HorizontalRotation)((Object)this.m_58900_().m_61143_(PropertyHolder.ROTATION));
            Direction rotDir = rotation.withFacing(facing);
            Direction perpRotDir = rotation.rotate(Rotation.COUNTERCLOCKWISE_90).withFacing(facing);
            if (side == rotDir.m_122424_() || side == perpRotDir.m_122424_()) {
                return this.getCamoState().m_60804_((BlockGetter)this.f_58857_, this.f_58858_);
            }
        }
        return false;
    }

    @Override
    protected Tuple<BlockState, BlockState> getBlockPair(BlockState state) {
        if (((IFramedBlock)state.m_60734_()).getBlockType() == BlockType.FRAMED_FLAT_EXT_INNER_DOUBLE_SLOPE_PANEL_CORNER) {
            return FramedFlatExtendedDoubleSlopePanelCornerBlockEntity.getInnerBlockPair((Direction)state.m_61143_((Property)FramedProperties.FACING_HOR), (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION)));
        }
        return FramedFlatExtendedDoubleSlopePanelCornerBlockEntity.getBlockPair((Direction)state.m_61143_((Property)FramedProperties.FACING_HOR), (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION)));
    }

    public static Tuple<BlockState, BlockState> getBlockPair(Direction facing, HorizontalRotation rotation) {
        HorizontalRotation backRot = rotation.rotate(rotation.isVertical() ? Rotation.COUNTERCLOCKWISE_90 : Rotation.CLOCKWISE_90);
        return new Tuple((Object)((BlockState)((BlockState)((Block)FBContent.blockFramedFlatExtendedSlopePanelCorner.get()).m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)facing)).m_61124_(PropertyHolder.ROTATION, (Comparable)((Object)rotation))), (Object)((BlockState)((BlockState)((Block)FBContent.blockFramedFlatInnerSlopePanelCorner.get()).m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)facing.m_122424_())).m_61124_(PropertyHolder.ROTATION, (Comparable)((Object)backRot))));
    }

    public static Tuple<BlockState, BlockState> getInnerBlockPair(Direction facing, HorizontalRotation rotation) {
        HorizontalRotation backRot = rotation.rotate(rotation.isVertical() ? Rotation.COUNTERCLOCKWISE_90 : Rotation.CLOCKWISE_90);
        return new Tuple((Object)((BlockState)((BlockState)((Block)FBContent.blockFramedFlatExtendedInnerSlopePanelCorner.get()).m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)facing)).m_61124_(PropertyHolder.ROTATION, (Comparable)((Object)rotation))), (Object)((BlockState)((BlockState)((Block)FBContent.blockFramedFlatSlopePanelCorner.get()).m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)facing.m_122424_())).m_61124_(PropertyHolder.ROTATION, (Comparable)((Object)backRot))));
    }
}

