/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.data.BlockType;

public class FramedPyramidBlock
extends FramedBlock {
    public FramedPyramidBlock(BlockType type) {
        super(type);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)Direction.UP));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BlockStateProperties.f_61372_, FramedProperties.SOLID, FramedProperties.GLOWING, BlockStateProperties.f_61362_});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)context.m_43719_());
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61122_((Property)BlockStateProperties.f_61372_);
    }

    public static ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape shapeUp = Shapes.m_83124_((VoxelShape)FramedPyramidBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.5, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedPyramidBlock.m_49796_((double)0.5, (double)0.5, (double)0.5, (double)15.5, (double)4.0, (double)15.5), FramedPyramidBlock.m_49796_((double)2.0, (double)4.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0), FramedPyramidBlock.m_49796_((double)4.0, (double)8.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0), FramedPyramidBlock.m_49796_((double)6.0, (double)12.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0)});
        VoxelShape shapeDown = Shapes.m_83124_((VoxelShape)FramedPyramidBlock.m_49796_((double)0.0, (double)15.5, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedPyramidBlock.m_49796_((double)0.5, (double)12.0, (double)0.5, (double)15.5, (double)15.5, (double)15.5), FramedPyramidBlock.m_49796_((double)2.0, (double)8.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0), FramedPyramidBlock.m_49796_((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0), FramedPyramidBlock.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)4.0, (double)10.0)});
        VoxelShape shapeNorth = Shapes.m_83124_((VoxelShape)FramedPyramidBlock.m_49796_((double)0.0, (double)0.0, (double)15.5, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedPyramidBlock.m_49796_((double)0.5, (double)0.5, (double)12.0, (double)15.5, (double)15.5, (double)15.5), FramedPyramidBlock.m_49796_((double)2.0, (double)2.0, (double)8.0, (double)14.0, (double)14.0, (double)12.0), FramedPyramidBlock.m_49796_((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)8.0), FramedPyramidBlock.m_49796_((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)4.0)});
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
            VoxelShape shape = switch (facing) {
                case Direction.UP -> shapeUp;
                case Direction.DOWN -> shapeDown;
                default -> Utils.rotateShape(Direction.NORTH, facing, shapeNorth);
            };
            builder.put((Object)state, (Object)shape);
        }
        return builder.build();
    }

    public static ImmutableMap<BlockState, VoxelShape> generateSlabShapes(ImmutableList<BlockState> states) {
        VoxelShape shapeUp = Shapes.m_83124_((VoxelShape)FramedPyramidBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.5, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedPyramidBlock.m_49796_((double)0.5, (double)0.5, (double)0.5, (double)15.5, (double)2.0, (double)15.5), FramedPyramidBlock.m_49796_((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0), FramedPyramidBlock.m_49796_((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)6.0, (double)12.0), FramedPyramidBlock.m_49796_((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)8.0, (double)10.0)});
        VoxelShape shapeDown = Shapes.m_83124_((VoxelShape)FramedPyramidBlock.m_49796_((double)0.0, (double)15.5, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedPyramidBlock.m_49796_((double)0.5, (double)14.0, (double)0.5, (double)15.5, (double)15.5, (double)15.5), FramedPyramidBlock.m_49796_((double)2.0, (double)12.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0), FramedPyramidBlock.m_49796_((double)4.0, (double)10.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0), FramedPyramidBlock.m_49796_((double)6.0, (double)8.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0)});
        VoxelShape shapeNorth = Shapes.m_83124_((VoxelShape)FramedPyramidBlock.m_49796_((double)0.0, (double)0.0, (double)15.5, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedPyramidBlock.m_49796_((double)0.5, (double)0.5, (double)14.0, (double)15.5, (double)15.5, (double)15.5), FramedPyramidBlock.m_49796_((double)2.0, (double)2.0, (double)12.0, (double)14.0, (double)14.0, (double)14.0), FramedPyramidBlock.m_49796_((double)4.0, (double)4.0, (double)10.0, (double)12.0, (double)12.0, (double)12.0), FramedPyramidBlock.m_49796_((double)6.0, (double)6.0, (double)8.0, (double)10.0, (double)10.0, (double)10.0)});
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
            VoxelShape shape = switch (facing) {
                case Direction.UP -> shapeUp;
                case Direction.DOWN -> shapeDown;
                default -> Utils.rotateShape(Direction.NORTH, facing, shapeNorth);
            };
            builder.put((Object)state, (Object)shape);
        }
        return builder.build();
    }
}

