/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.block.FramedSlopePanelBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;

public class FramedFlatSlopePanelCornerBlock
extends FramedBlock {
    public FramedFlatSlopePanelCornerBlock(BlockType type) {
        super(type);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)PropertyHolder.FRONT, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FramedProperties.FACING_HOR, PropertyHolder.ROTATION, PropertyHolder.FRONT, FramedProperties.SOLID, FramedProperties.GLOWING, BlockStateProperties.f_61362_});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return FramedFlatSlopePanelCornerBlock.getStateForPlacement(this, true, context);
    }

    public static BlockState getStateForPlacement(Block block, boolean hasFront, BlockPlaceContext context) {
        return FramedFlatSlopePanelCornerBlock.getStateForPlacement(block, hasFront, true, context);
    }

    public static BlockState getStateForPlacement(Block block, boolean hasFront, boolean hasWater, BlockPlaceContext context) {
        Direction facing = context.m_8125_();
        Direction side = context.m_43719_();
        HorizontalRotation rotation = side == facing.m_122424_() ? HorizontalRotation.fromWallCorner(context.m_43720_(), side) : HorizontalRotation.fromDirection(facing, side);
        BlockState state = (BlockState)((BlockState)block.m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)facing)).m_61124_(PropertyHolder.ROTATION, (Comparable)((Object)rotation));
        if (hasFront) {
            boolean front = false;
            if (side.m_122434_() != facing.m_122434_()) {
                Vec3 subHit = Utils.fraction(context.m_43720_());
                double xz = Utils.isX(facing) ? subHit.f_82479_ : subHit.f_82481_;
                front = xz < 0.5 == Utils.isPositive(facing);
            }
            state = (BlockState)state.m_61124_((Property)PropertyHolder.FRONT, (Comparable)Boolean.valueOf(front));
        }
        if (hasWater) {
            state = FramedFlatSlopePanelCornerBlock.withWater(state, (LevelReader)context.m_43725_(), context.m_8083_());
        }
        return state;
    }

    @Override
    public BlockState rotate(BlockState state, BlockHitResult hit, Rotation rot) {
        Direction face = hit.m_82434_();
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation rotation = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
        Direction rotDir = rotation.withFacing(dir);
        Direction perpRotDir = rotation.rotate(Rotation.COUNTERCLOCKWISE_90).withFacing(dir);
        if (face == rotDir || face == perpRotDir) {
            if (this.getBlockType() == BlockType.FRAMED_FLAT_SLOPE_PANEL_CORNER) {
                face = dir.m_122424_();
            } else {
                double vert;
                Direction perpDir;
                double hor;
                Vec3 vec = Utils.fraction(hit.m_82450_());
                double d = hor = Utils.isX(dir) ? vec.m_7096_() : vec.m_7094_();
                if (!Utils.isPositive(dir)) {
                    hor = 1.0 - hor;
                }
                if (!((Boolean)state.m_61143_((Property)PropertyHolder.FRONT)).booleanValue()) {
                    hor -= 0.5;
                }
                Direction direction = perpDir = face == rotDir ? perpRotDir : rotDir;
                double d2 = Utils.isY(perpDir) ? vec.m_7098_() : (vert = Utils.isX(dir) ? vec.m_7094_() : vec.m_7096_());
                if (perpDir == Direction.DOWN || !Utils.isY(perpDir) && !Utils.isPositive(perpDir)) {
                    vert = 1.0 - vert;
                }
                if (hor * 2.0 < vert) {
                    face = dir.m_122424_();
                }
            }
        }
        return this.rotate(state, face, rot);
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation rotation = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
        if (face.m_122434_() == dir.m_122434_()) {
            return (BlockState)state.m_61124_(PropertyHolder.ROTATION, (Comparable)((Object)rotation.rotate(rot)));
        }
        if (Utils.isY(face)) {
            return (BlockState)state.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)rot.m_55954_(dir));
        }
        if (rot != Rotation.NONE) {
            return (BlockState)state.m_61122_((Property)PropertyHolder.FRONT);
        }
        return state;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return this.rotate(state, Direction.UP, rot);
    }

    public static ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            HorizontalRotation rot = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
            VoxelShape shape = Shapes.m_83113_((VoxelShape)FramedSlopePanelBlock.SHAPES.get((Object)rot), (VoxelShape)FramedSlopePanelBlock.SHAPES.get((Object)rot.rotate(Rotation.COUNTERCLOCKWISE_90)), (BooleanOp)BooleanOp.f_82689_);
            if (((Boolean)state.m_61143_((Property)PropertyHolder.FRONT)).booleanValue()) {
                shape = shape.m_83216_(0.0, 0.0, 0.5);
            }
            Direction facing = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, facing, shape));
        }
        return builder.build();
    }

    public static ImmutableMap<BlockState, VoxelShape> generateInnerShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            HorizontalRotation rot = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
            VoxelShape shape = Shapes.m_83110_((VoxelShape)FramedSlopePanelBlock.SHAPES.get((Object)rot), (VoxelShape)FramedSlopePanelBlock.SHAPES.get((Object)rot.rotate(Rotation.COUNTERCLOCKWISE_90)));
            if (((Boolean)state.m_61143_((Property)PropertyHolder.FRONT)).booleanValue()) {
                shape = shape.m_83216_(0.0, 0.0, 0.5);
            }
            Direction facing = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, facing, shape));
        }
        return builder.build();
    }
}

