/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.UnmodifiableIterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.util.CtmPredicate;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.blockentity.FramedFlatDoubleSlopeSlabCornerBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;

public class FramedFlatDoubleSlopeSlabCornerBlock
extends AbstractFramedDoubleBlock {
    public static final CtmPredicate CTM_PREDICATE = (state, side) -> {
        boolean topHalf = (Boolean)state.m_61143_((Property)PropertyHolder.TOP_HALF);
        return topHalf ? side == Direction.UP : side == Direction.DOWN;
    };

    public FramedFlatDoubleSlopeSlabCornerBlock() {
        super(BlockType.FRAMED_FLAT_DOUBLE_SLOPE_SLAB_CORNER);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)PropertyHolder.TOP_HALF, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FramedProperties.FACING_HOR, FramedProperties.TOP, PropertyHolder.TOP_HALF, BlockStateProperties.f_61362_});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction face = context.m_43719_();
        Direction facing = Utils.isY(face) ? context.m_8125_() : face.m_122424_();
        BlockState state = (BlockState)this.m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)facing);
        state = FramedFlatDoubleSlopeSlabCornerBlock.withTop(state, (Property<Boolean>)PropertyHolder.TOP_HALF, context.m_43719_(), context.m_43720_());
        state = (BlockState)state.m_61124_((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(context.m_43723_() != null && context.m_43723_().m_6144_()));
        return FramedFlatDoubleSlopeSlabCornerBlock.withWater(state, (LevelReader)context.m_43725_(), context.m_8083_());
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        if (Utils.isY(face)) {
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            return (BlockState)state.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)rot.m_55954_(dir));
        }
        if (rot != Rotation.NONE) {
            return (BlockState)state.m_61122_((Property)PropertyHolder.TOP_HALF);
        }
        return state;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return this.rotate(state, Direction.UP, rot);
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new FramedFlatDoubleSlopeSlabCornerBlockEntity(pos, state);
    }

    public static ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape shapeBot = FramedFlatDoubleSlopeSlabCornerBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
        VoxelShape shapeTop = FramedFlatDoubleSlopeSlabCornerBlock.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        UnmodifiableIterator unmodifiableIterator = states.iterator();
        while (unmodifiableIterator.hasNext()) {
            BlockState state;
            boolean topHalf = (Boolean)(state = (BlockState)unmodifiableIterator.next()).m_61143_((Property)PropertyHolder.TOP_HALF);
            builder.put((Object)state, (Object)(topHalf ? shapeTop : shapeBot));
        }
        return builder.build();
    }
}

