/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.util.CtmPredicate;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.block.FramedSlopeBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.CornerType;

public class FramedCornerSlopeBlock
extends FramedBlock {
    public static final CtmPredicate CTM_PREDICATE = (state, dir) -> {
        CornerType type = (CornerType)((Object)((Object)state.m_61143_(PropertyHolder.CORNER_TYPE)));
        if (type == CornerType.TOP) {
            return dir == Direction.UP;
        }
        if (type == CornerType.BOTTOM) {
            return dir == Direction.DOWN;
        }
        return state.m_61143_((Property)FramedProperties.FACING_HOR) == dir;
    };
    public static final CtmPredicate CTM_PREDICATE_INNER = (state, dir) -> {
        CornerType type = (CornerType)((Object)((Object)state.m_61143_(PropertyHolder.CORNER_TYPE)));
        if ((type == CornerType.TOP || type.isHorizontal() && type.isTop()) && dir == Direction.UP) {
            return true;
        }
        if ((type == CornerType.BOTTOM || type.isHorizontal() && !type.isTop()) && dir == Direction.DOWN) {
            return true;
        }
        Direction facing = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        if (type.isHorizontal()) {
            return facing == dir || type.isRight() && facing.m_122427_() == dir || !type.isRight() && facing.m_122428_() == dir;
        }
        return facing == dir || facing.m_122428_() == dir;
    };

    public FramedCornerSlopeBlock(BlockType type) {
        super(type);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FramedProperties.FACING_HOR, PropertyHolder.CORNER_TYPE, BlockStateProperties.f_61362_, FramedProperties.SOLID, FramedProperties.GLOWING});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = this.m_49966_();
        Direction side = context.m_43719_();
        Vec3 hitPoint = Utils.fraction(context.m_43720_());
        if (!Utils.isY(side)) {
            if (hitPoint.m_7098_() < 0.1875) {
                side = Direction.UP;
            } else if (hitPoint.m_7098_() > 0.8125) {
                side = Direction.DOWN;
            }
        }
        Direction facing = context.m_8125_();
        state = FramedCornerSlopeBlock.withCornerType(state, context, side, hitPoint, facing);
        return FramedCornerSlopeBlock.withWater(state, (LevelReader)context.m_43725_(), context.m_8083_());
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        CornerType type = (CornerType)((Object)state.m_61143_(PropertyHolder.CORNER_TYPE));
        if (type.isHorizontal()) {
            return (BlockState)state.m_61124_(PropertyHolder.CORNER_TYPE, (Comparable)((Object)type.rotate(rot)));
        }
        Direction dir = rot.m_55954_((Direction)state.m_61143_((Property)FramedProperties.FACING_HOR));
        return (BlockState)state.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)dir);
    }

    public static ImmutableMap<BlockState, VoxelShape> generateCornerShapes(ImmutableList<BlockState> states) {
        VoxelShape shapeTop = Shapes.m_83113_((VoxelShape)FramedSlopeBlock.SHAPE_TOP, (VoxelShape)Utils.rotateShape(Direction.NORTH, Direction.WEST, FramedSlopeBlock.SHAPE_TOP), (BooleanOp)BooleanOp.f_82689_);
        VoxelShape shapeBottom = Shapes.m_83113_((VoxelShape)FramedSlopeBlock.SHAPE_BOTTOM, (VoxelShape)Utils.rotateShape(Direction.NORTH, Direction.WEST, FramedSlopeBlock.SHAPE_BOTTOM), (BooleanOp)BooleanOp.f_82689_);
        VoxelShape shapeBottomLeft = Shapes.m_83113_((VoxelShape)FramedSlopeBlock.SHAPE_BOTTOM, (VoxelShape)FramedSlopeBlock.SHAPE_HORIZONTAL, (BooleanOp)BooleanOp.f_82689_);
        VoxelShape shapeBottomRight = Shapes.m_83113_((VoxelShape)FramedSlopeBlock.SHAPE_BOTTOM, (VoxelShape)Utils.rotateShape(Direction.NORTH, Direction.EAST, FramedSlopeBlock.SHAPE_HORIZONTAL), (BooleanOp)BooleanOp.f_82689_);
        VoxelShape shapeTopLeft = Shapes.m_83113_((VoxelShape)FramedSlopeBlock.SHAPE_TOP, (VoxelShape)FramedSlopeBlock.SHAPE_HORIZONTAL, (BooleanOp)BooleanOp.f_82689_);
        VoxelShape shapeTopRight = Shapes.m_83113_((VoxelShape)FramedSlopeBlock.SHAPE_TOP, (VoxelShape)Utils.rotateShape(Direction.NORTH, Direction.EAST, FramedSlopeBlock.SHAPE_HORIZONTAL), (BooleanOp)BooleanOp.f_82689_);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            CornerType type = (CornerType)((Object)state.m_61143_(PropertyHolder.CORNER_TYPE));
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            if (type.isHorizontal()) {
                VoxelShape shape = switch (type) {
                    case CornerType.HORIZONTAL_BOTTOM_LEFT -> shapeBottomLeft;
                    case CornerType.HORIZONTAL_BOTTOM_RIGHT -> shapeBottomRight;
                    case CornerType.HORIZONTAL_TOP_LEFT -> shapeTopLeft;
                    case CornerType.HORIZONTAL_TOP_RIGHT -> shapeTopRight;
                    default -> Shapes.m_83144_();
                };
                builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, dir, shape));
                continue;
            }
            builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, dir, type.isTop() ? shapeTop : shapeBottom));
        }
        return builder.build();
    }

    public static ImmutableMap<BlockState, VoxelShape> generateInnerCornerShapes(ImmutableList<BlockState> states) {
        VoxelShape shapeTop = Shapes.m_83110_((VoxelShape)FramedSlopeBlock.SHAPE_TOP, (VoxelShape)Utils.rotateShape(Direction.NORTH, Direction.WEST, FramedSlopeBlock.SHAPE_TOP));
        VoxelShape shapeBottom = Shapes.m_83110_((VoxelShape)FramedSlopeBlock.SHAPE_BOTTOM, (VoxelShape)Utils.rotateShape(Direction.NORTH, Direction.WEST, FramedSlopeBlock.SHAPE_BOTTOM));
        VoxelShape shapeBottomLeft = Shapes.m_83110_((VoxelShape)FramedSlopeBlock.SHAPE_BOTTOM, (VoxelShape)FramedSlopeBlock.SHAPE_HORIZONTAL);
        VoxelShape shapeBottomRight = Shapes.m_83110_((VoxelShape)FramedSlopeBlock.SHAPE_BOTTOM, (VoxelShape)Utils.rotateShape(Direction.NORTH, Direction.EAST, FramedSlopeBlock.SHAPE_HORIZONTAL));
        VoxelShape shapeTopLeft = Shapes.m_83110_((VoxelShape)FramedSlopeBlock.SHAPE_TOP, (VoxelShape)FramedSlopeBlock.SHAPE_HORIZONTAL);
        VoxelShape shapeTopRight = Shapes.m_83110_((VoxelShape)FramedSlopeBlock.SHAPE_TOP, (VoxelShape)Utils.rotateShape(Direction.NORTH, Direction.EAST, FramedSlopeBlock.SHAPE_HORIZONTAL));
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            CornerType type = (CornerType)((Object)state.m_61143_(PropertyHolder.CORNER_TYPE));
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            if (type.isHorizontal()) {
                VoxelShape shape = switch (type) {
                    case CornerType.HORIZONTAL_BOTTOM_LEFT -> shapeBottomLeft;
                    case CornerType.HORIZONTAL_BOTTOM_RIGHT -> shapeBottomRight;
                    case CornerType.HORIZONTAL_TOP_LEFT -> shapeTopLeft;
                    case CornerType.HORIZONTAL_TOP_RIGHT -> shapeTopRight;
                    default -> Shapes.m_83144_();
                };
                builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, dir, shape));
                continue;
            }
            builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, dir, type.isTop() ? shapeTop : shapeBottom));
        }
        return builder.build();
    }
}

