/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.render.outline;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.render.Quaternions;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.api.util.client.OutlineRender;
import xfacthd.framedblocks.client.render.outline.PrismOutlineRenderer;
import xfacthd.framedblocks.common.data.PropertyHolder;

public final class SlopedPrismOutlineRenderer
extends PrismOutlineRenderer {
    private static final Quaternion[][] ZP_DIR = SlopedPrismOutlineRenderer.makeQuaternionArray();

    @Override
    public void drawCenterAndTriangle(PoseStack pstack, VertexConsumer builder) {
        OutlineRender.drawLine(builder, pstack, 0.5, 0.5, 0.5, 0.5, 0.5, 1.0);
        OutlineRender.drawLine(builder, pstack, 0.0, 0.0, 0.0, 0.5, 0.5, 0.5);
        OutlineRender.drawLine(builder, pstack, 0.5, 0.5, 0.5, 1.0, 0.0, 0.0);
    }

    @Override
    public void rotateMatrix(PoseStack pstack, BlockState state) {
        Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
        Direction orientation = (Direction)state.m_61143_((Property)PropertyHolder.ORIENTATION);
        if (Utils.isY(facing)) {
            if (orientation != Direction.SOUTH) {
                pstack.m_85845_(YN_DIR[orientation.m_122416_()]);
            }
            if (facing == Direction.DOWN) {
                pstack.m_85845_(Quaternions.ZP_180);
            }
        } else {
            if (facing != Direction.SOUTH) {
                pstack.m_85845_(YN_DIR[facing.m_122416_()]);
            }
            if (orientation != Direction.DOWN) {
                pstack.m_85845_(ZP_DIR[facing.m_122416_()][orientation.ordinal()]);
            }
            pstack.m_85845_(Quaternions.XP_90);
        }
    }

    private static Quaternion[][] makeQuaternionArray() {
        Quaternion[][] array = new Quaternion[4][6];
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            array[dir.m_122416_()] = new Quaternion[6];
            for (Direction orientation : Direction.values()) {
                int mult = 2;
                if (orientation == dir.m_122428_()) {
                    mult = 1;
                } else if (orientation == dir.m_122427_()) {
                    mult = 3;
                }
                array[dir.m_122416_()][orientation.ordinal()] = Vector3f.f_122227_.m_122270_(1.5707964f * (float)mult);
            }
        }
        return array;
    }
}

