/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.render;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.common.MinecraftForge;
import xfacthd.framedblocks.api.ghost.CamoPair;
import xfacthd.framedblocks.api.ghost.GhostRenderBehaviour;
import xfacthd.framedblocks.api.util.FramedBlockData;
import xfacthd.framedblocks.client.util.ClientConfig;
import xfacthd.framedblocks.client.util.CustomRenderType;
import xfacthd.framedblocks.client.util.GhostVertexConsumer;
import xfacthd.framedblocks.common.blockentity.FramedDoubleBlockEntity;

public final class GhostBlockRenderer {
    private static final Random RANDOM = new Random();
    private static final FramedBlockData GHOST_MODEL_DATA = new FramedBlockData(true);
    private static final FramedBlockData GHOST_MODEL_DATA_TWO = new FramedBlockData(true);
    private static final Map<Item, GhostRenderBehaviour> RENDER_BEHAVIOURS = new IdentityHashMap<Item, GhostRenderBehaviour>();
    private static final GhostRenderBehaviour DEFAULT_BEHAVIOUR = new GhostRenderBehaviour(){};
    private static final String PROFILER_KEY = "framedblocks_ghost_block";

    public static void init() {
        GHOST_MODEL_DATA.setCamoState(Blocks.f_50016_.m_49966_());
        GHOST_MODEL_DATA_TWO.setCamoState(Blocks.f_50016_.m_49966_());
        GHOST_MODEL_DATA.setData(FramedDoubleBlockEntity.DATA_LEFT, GHOST_MODEL_DATA);
        GHOST_MODEL_DATA.setData(FramedDoubleBlockEntity.DATA_RIGHT, GHOST_MODEL_DATA_TWO);
        MinecraftForge.EVENT_BUS.addListener(GhostBlockRenderer::onRenderStage);
    }

    public static void onRenderStage(RenderLevelStageEvent event) {
        if (!ClientConfig.showGhostBlocks || event.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            return;
        }
        GhostBlockRenderer.mc().m_91307_().m_6180_(PROFILER_KEY);
        GhostBlockRenderer.tryDrawGhostBlock(event.getPoseStack());
        GhostBlockRenderer.mc().m_91307_().m_7238_();
    }

    private static void tryDrawGhostBlock(PoseStack poseStack) {
        BlockHitResult hit;
        HitResult hitResult = GhostBlockRenderer.mc().f_91077_;
        if (!(hitResult instanceof BlockHitResult) || (hit = (BlockHitResult)hitResult).m_6662_() != HitResult.Type.BLOCK) {
            return;
        }
        ItemStack stack = GhostBlockRenderer.mc().f_91074_.m_21205_();
        if (stack.m_41619_()) {
            return;
        }
        GhostRenderBehaviour behaviour = RENDER_BEHAVIOURS.getOrDefault(stack.m_41720_(), DEFAULT_BEHAVIOUR);
        GhostBlockRenderer.mc().m_91307_().m_6180_("get_stack");
        ItemStack proxiedStack = behaviour.getProxiedStack(stack);
        GhostBlockRenderer.mc().m_91307_().m_7238_();
        GhostBlockRenderer.mc().m_91307_().m_6180_("may_render");
        if (!behaviour.mayRender(stack, proxiedStack)) {
            GhostBlockRenderer.mc().m_91307_().m_7238_();
            return;
        }
        GhostBlockRenderer.mc().m_91307_().m_7238_();
        GhostBlockRenderer.mc().m_91307_().m_6180_("make_context");
        BlockPlaceContext context = new BlockPlaceContext((Player)GhostBlockRenderer.mc().f_91074_, InteractionHand.MAIN_HAND, stack, hit);
        BlockState hitState = GhostBlockRenderer.mc().f_91073_.m_8055_(hit.m_82425_());
        GhostBlockRenderer.mc().m_91307_().m_7238_();
        GhostBlockRenderer.drawGhostBlock(poseStack, behaviour, stack, proxiedStack, hit, context, hitState, false);
    }

    private static void drawGhostBlock(PoseStack poseStack, GhostRenderBehaviour behaviour, ItemStack stack, ItemStack proxiedStack, BlockHitResult hit, BlockPlaceContext context, BlockState hitState, boolean secondPass) {
        GhostBlockRenderer.mc().m_91307_().m_6180_("get_state");
        BlockState renderState = behaviour.getRenderState(stack, proxiedStack, hit, context, hitState, secondPass);
        GhostBlockRenderer.mc().m_91307_().m_7238_();
        if (renderState == null) {
            return;
        }
        GhostBlockRenderer.mc().m_91307_().m_6180_("get_pos");
        BlockPos renderPos = behaviour.getRenderPos(stack, proxiedStack, hit, context, hitState, context.m_8083_(), secondPass);
        GhostBlockRenderer.mc().m_91307_().m_6182_("can_render");
        if (!secondPass && !behaviour.canRenderAt(stack, proxiedStack, hit, context, hitState, renderState, renderPos)) {
            GhostBlockRenderer.mc().m_91307_().m_7238_();
            return;
        }
        GhostBlockRenderer.mc().m_91307_().m_7238_();
        GhostBlockRenderer.mc().m_91307_().m_6180_("get_camo");
        CamoPair camo = behaviour.readCamo(stack, proxiedStack, secondPass);
        camo = behaviour.postProcessCamo(stack, proxiedStack, context, renderState, secondPass, camo);
        GHOST_MODEL_DATA.setCamoState(camo.getCamoOne());
        GHOST_MODEL_DATA_TWO.setCamoState(camo.getCamoTwo());
        GhostBlockRenderer.mc().m_91307_().m_7238_();
        GhostBlockRenderer.mc().m_91307_().m_6180_("append_modeldata");
        IModelData modelData = behaviour.appendModelData(stack, proxiedStack, context, renderState, secondPass, (IModelData)GHOST_MODEL_DATA);
        GhostBlockRenderer.mc().m_91307_().m_7238_();
        MultiBufferSource.BufferSource buffers = GhostBlockRenderer.mc().m_91269_().m_110104_();
        GhostBlockRenderer.doRenderGhostBlock(poseStack, (MultiBufferSource)buffers, renderPos, renderState, camo, modelData);
        GHOST_MODEL_DATA.setCamoState(Blocks.f_50016_.m_49966_());
        GHOST_MODEL_DATA_TWO.setCamoState(Blocks.f_50016_.m_49966_());
        if (!secondPass && behaviour.hasSecondBlock(stack, proxiedStack)) {
            GhostBlockRenderer.drawGhostBlock(poseStack, behaviour, stack, proxiedStack, hit, context, hitState, true);
        }
    }

    private static void doRenderGhostBlock(PoseStack mstack, MultiBufferSource buffers, BlockPos renderPos, BlockState renderState, CamoPair camoPair, IModelData modelData) {
        GhostBlockRenderer.mc().m_91307_().m_6180_("buffer");
        Vec3 offset = Vec3.m_82528_((Vec3i)renderPos).m_82546_(GhostBlockRenderer.mc().f_91063_.m_109153_().m_90583_());
        GhostVertexConsumer builder = new GhostVertexConsumer(buffers.m_6299_(CustomRenderType.GHOST_BLOCK), 170);
        GhostBlockRenderer.mc().m_91307_().m_7238_();
        GhostBlockRenderer.mc().m_91307_().m_6180_("draw");
        BlockState camoState = camoPair.getCamoOne();
        BlockState camoStateTwo = camoPair.getCamoTwo();
        if (camoState.m_60795_() && camoStateTwo.m_60795_()) {
            GhostBlockRenderer.doRenderGhostBlockInLayer(mstack, builder, renderPos, renderState, RenderType.m_110463_(), offset, modelData);
        } else {
            for (RenderType type : RenderType.m_110506_()) {
                if (!GhostBlockRenderer.canRenderInLayer(camoState, type) && !GhostBlockRenderer.canRenderInLayer(camoStateTwo, type)) continue;
                GhostBlockRenderer.doRenderGhostBlockInLayer(mstack, builder, renderPos, renderState, type, offset, modelData);
            }
        }
        GhostBlockRenderer.mc().m_91307_().m_7238_();
        GhostBlockRenderer.mc().m_91307_().m_6180_("upload");
        ((MultiBufferSource.BufferSource)buffers).m_109912_(CustomRenderType.GHOST_BLOCK);
        ForgeHooksClient.setRenderType(null);
        GhostBlockRenderer.mc().m_91307_().m_7238_();
    }

    private static boolean canRenderInLayer(BlockState camoState, RenderType layer) {
        if (camoState.m_60795_()) {
            return layer == RenderType.m_110463_();
        }
        return ItemBlockRenderTypes.canRenderInLayer((BlockState)camoState, (RenderType)layer);
    }

    private static void doRenderGhostBlockInLayer(PoseStack mstack, VertexConsumer builder, BlockPos renderPos, BlockState renderState, RenderType layer, Vec3 offset, IModelData modelData) {
        ForgeHooksClient.setRenderType((RenderType)layer);
        mstack.m_85836_();
        mstack.m_85837_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
        GhostBlockRenderer.mc().m_91289_().renderBatched(renderState, renderPos, (BlockAndTintGetter)GhostBlockRenderer.mc().f_91073_, mstack, builder, false, RANDOM, modelData);
        mstack.m_85849_();
    }

    public static synchronized void registerBehaviour(GhostRenderBehaviour behaviour, Block ... blocks) {
        Preconditions.checkNotNull((Object)behaviour, (Object)"GhostRenderBehaviour must be non-null");
        Preconditions.checkNotNull((Object)blocks, (Object)"Blocks array must be non-null to register a GhostRenderBehaviour");
        Preconditions.checkState((blocks.length > 0 ? 1 : 0) != 0, (Object)"At least one block must be provided to register a GhostRenderBehaviour");
        for (Block block : blocks) {
            Item item = block.m_5456_();
            Preconditions.checkState((boolean)(item instanceof BlockItem), (Object)"Block must have an associated BlockItem");
            GhostBlockRenderer.registerBehaviour(behaviour, item);
        }
    }

    public static synchronized void registerBehaviour(GhostRenderBehaviour behaviour, Item ... items) {
        Preconditions.checkNotNull((Object)behaviour, (Object)"GhostRenderBehaviour must be non-null");
        Preconditions.checkNotNull((Object)items, (Object)"Items array must be non-null to register a GhostRenderBehaviour");
        Preconditions.checkState((items.length > 0 ? 1 : 0) != 0, (Object)"At least one item must be provided to register a GhostRenderBehaviour");
        for (Item item : items) {
            RENDER_BEHAVIOURS.put(item, behaviour);
        }
    }

    public static GhostRenderBehaviour getBehaviour(Item item) {
        return RENDER_BEHAVIOURS.getOrDefault(item, DEFAULT_BEHAVIOUR);
    }

    private static Minecraft mc() {
        return Minecraft.m_91087_();
    }

    private GhostBlockRenderer() {
    }
}

