/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.util.Utils;

public class FramedTrapDoorModel
extends FramedBlockModel {
    private static final float DEPTH = 0.1875f;
    private final Direction dir;
    private final boolean top;
    private final boolean open;

    public FramedTrapDoorModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        this.dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        this.top = state.m_61143_((Property)BlockStateProperties.f_61402_) == Half.TOP;
        this.open = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61446_);
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        Direction quadDir = quad.m_111306_();
        if (this.open) {
            if (quadDir == this.dir) {
                QuadModifier.geometry(quad).apply(Modifiers.setPosition(0.1875f)).export(quadMap.get(null));
            } else if (Utils.isY(quadDir)) {
                QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(this.dir, 0.1875f)).export(quadMap.get(quadDir));
            } else {
                QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(this.dir, 0.1875f)).export(quadMap.get(quadDir));
            }
        } else if (this.top && quad.m_111306_() == Direction.DOWN || !this.top && quad.m_111306_() == Direction.UP) {
            QuadModifier.geometry(quad).apply(Modifiers.setPosition(0.1875f)).export(quadMap.get(null));
        } else if (!Utils.isY(quad.m_111306_())) {
            QuadModifier.geometry(quad).apply(Modifiers.cutSideUpDown(this.top, 0.1875f)).export(quadMap.get(quadDir));
        }
    }
}

