/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.client.model.FramedFlatSlopePanelCornerModel;
import xfacthd.framedblocks.client.model.FramedSlopePanelModel;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;

public class FramedFlatInnerSlopePanelCornerModel
extends FramedBlockModel {
    private final Direction facing;
    private final HorizontalRotation rotation;
    private final HorizontalRotation rotRotation;
    private final Direction orientation;
    private final Direction rotOrientation;
    private final boolean front;

    public FramedFlatInnerSlopePanelCornerModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        this.facing = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        this.rotation = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
        this.rotRotation = this.rotation.rotate(Rotation.COUNTERCLOCKWISE_90);
        this.orientation = this.rotation.withFacing(this.facing);
        this.rotOrientation = this.rotRotation.withFacing(this.facing);
        this.front = (Boolean)state.m_61143_((Property)PropertyHolder.FRONT);
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        Direction face = quad.m_111306_();
        if (face == this.orientation) {
            FramedFlatSlopePanelCornerModel.createSideTriangle(quadMap, quad, this.facing, this.rotRotation, this.front, false);
        } else if (face == this.rotOrientation) {
            FramedFlatSlopePanelCornerModel.createSideTriangle(quadMap, quad, this.facing, this.rotation, this.front, false);
        } else if (face == this.orientation.m_122424_() || face == this.rotOrientation.m_122424_()) {
            Direction cutDir;
            Direction direction = cutDir = this.front ? this.facing : this.facing.m_122424_();
            if (Utils.isY(face)) {
                QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(cutDir, 0.5f)).export(quadMap.get(face));
            } else {
                QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(cutDir, 0.5f)).export(quadMap.get(face));
            }
        } else if (face == this.facing.m_122424_()) {
            QuadModifier.geometry(quad).apply(FramedFlatSlopePanelCornerModel.createSlopeTriangle(this.facing, this.rotOrientation, true)).apply(FramedSlopePanelModel.createSlope(this.facing, this.orientation)).applyIf(Modifiers.offset(this.facing, 0.5f), !this.front).export(quadMap.get(null));
            QuadModifier.geometry(quad).apply(FramedFlatSlopePanelCornerModel.createSlopeTriangle(this.facing, this.orientation, false)).apply(FramedSlopePanelModel.createSlope(this.facing, this.rotOrientation)).applyIf(Modifiers.offset(this.facing, 0.5f), !this.front).export(quadMap.get(null));
        } else if (face == this.facing && this.front) {
            QuadModifier.geometry(quad).apply(Modifiers.setPosition(0.5f)).export(quadMap.get(null));
        }
    }

    @Override
    protected void applyInHandTransformation(PoseStack poseStack, ItemTransforms.TransformType type) {
        poseStack.m_85837_(0.0, 0.5, 0.0);
    }

    public static BlockState itemSource() {
        return (BlockState)((BlockState)((Block)FBContent.blockFramedFlatInnerSlopePanelCorner.get()).m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)Direction.SOUTH)).m_61124_(PropertyHolder.ROTATION, (Comparable)((Object)HorizontalRotation.RIGHT));
    }
}

