/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.util.Utils;

public class FramedFenceGateModel
extends FramedBlockModel {
    private final Direction dir;
    private final boolean inWall;
    private final boolean open;

    public FramedFenceGateModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        this.dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        this.inWall = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61442_);
        this.open = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61446_);
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        float yOff;
        Direction quadDir = quad.m_111306_();
        float f = yOff = this.inWall ? 0.1875f : 0.0f;
        if (Utils.isY(quadDir)) {
            float quadInset = quadDir == Direction.UP ? 1.0f - yOff : 0.6875f + yOff;
            QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(this.dir.m_122427_(), 0.125f)).apply(Modifiers.cutTopBottom(this.dir, 0.5625f)).apply(Modifiers.cutTopBottom(this.dir.m_122424_(), 0.5625f)).apply(Modifiers.setPosition(quadInset)).export(quadMap.get(this.inWall || quadDir == Direction.DOWN ? null : quadDir));
            QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(this.dir.m_122428_(), 0.125f)).apply(Modifiers.cutTopBottom(this.dir, 0.5625f)).apply(Modifiers.cutTopBottom(this.dir.m_122424_(), 0.5625f)).apply(Modifiers.setPosition(quadInset)).export(quadMap.get(this.inWall || quadDir == Direction.DOWN ? null : quadDir));
        } else if (quadDir == this.dir || quadDir == this.dir.m_122424_()) {
            QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(this.dir.m_122427_(), 0.125f)).apply(Modifiers.cutSideUpDown(true, 0.6875f + yOff)).apply(Modifiers.cutSideUpDown(false, 1.0f - yOff)).apply(Modifiers.setPosition(0.5625f)).export(quadMap.get(null));
            QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(this.dir.m_122428_(), 0.125f)).apply(Modifiers.cutSideUpDown(true, 0.6875f + yOff)).apply(Modifiers.cutSideUpDown(false, 1.0f - yOff)).apply(Modifiers.setPosition(0.5625f)).export(quadMap.get(null));
        } else if (quadDir == this.dir.m_122427_() || quadDir == this.dir.m_122428_()) {
            QuadModifier mod = QuadModifier.geometry(quad).apply(Modifiers.cutSide(0.4375f, 0.3125f - yOff, 0.5625f, 1.0f - yOff));
            mod.export(quadMap.get(quadDir));
            mod.apply(Modifiers.setPosition(0.125f)).export(quadMap.get(null));
        }
        if (this.open) {
            this.createGateOpen(quadMap, quad, yOff);
        } else {
            this.createGateClosed(quadMap.get(null), quad, yOff);
        }
    }

    private void createGateClosed(List<BakedQuad> quadList, BakedQuad quad, float yOff) {
        Direction quadDir = quad.m_111306_();
        if (quadDir == this.dir || quadDir == this.dir.m_122424_()) {
            QuadModifier.geometry(quad).apply(Modifiers.cutSide(0.125f, 0.75f - yOff, 0.875f, 0.9375f - yOff)).apply(Modifiers.setPosition(0.5625f)).export(quadList);
            QuadModifier.geometry(quad).apply(Modifiers.cutSide(0.125f, 0.375f - yOff, 0.875f, 0.5625f - yOff)).apply(Modifiers.setPosition(0.5625f)).export(quadList);
            QuadModifier.geometry(quad).apply(Modifiers.cutSide(0.375f, 0.5625f - yOff, 0.625f, 0.75f - yOff)).apply(Modifiers.setPosition(0.5625f)).export(quadList);
        } else if (Utils.isY(quadDir)) {
            QuadModifier mod = QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(this.dir, 0.5625f)).apply(Modifiers.cutTopBottom(this.dir.m_122424_(), 0.5625f)).apply(Modifiers.cutTopBottom(this.dir.m_122427_(), 0.875f)).apply(Modifiers.cutTopBottom(this.dir.m_122428_(), 0.875f));
            if (mod.hasFailed()) {
                return;
            }
            boolean up = quadDir == Direction.UP;
            float height = up ? 0.5625f - yOff : 0.25f + yOff;
            mod.derive().apply(Modifiers.setPosition(up ? 0.9375f - yOff : 0.625f + yOff)).export(quadList);
            mod.derive().apply(Modifiers.cutTopBottom(this.dir.m_122427_(), 0.375f)).apply(Modifiers.setPosition(height)).export(quadList);
            mod.apply(Modifiers.cutTopBottom(this.dir.m_122428_(), 0.375f)).apply(Modifiers.setPosition(height)).export(quadList);
        } else if (quadDir == this.dir.m_122427_() || quadDir == this.dir.m_122428_()) {
            QuadModifier.geometry(quad).apply(Modifiers.cutSide(0.4375f, 0.5625f - yOff, 0.5625f, 0.75f - yOff)).apply(Modifiers.setPosition(0.625f)).export(quadList);
        }
    }

    private void createGateOpen(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad, float yOff) {
        Direction quadDir = quad.m_111306_();
        if (quadDir == this.dir.m_122427_() || quadDir == this.dir.m_122428_()) {
            QuadModifier mod = QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(this.dir.m_122424_(), 0.4375f)).apply(Modifiers.cutSideLeftRight(this.dir, 0.9375f)).apply(Modifiers.cutSideUpDown(false, 0.9375f - yOff)).apply(Modifiers.cutSideUpDown(true, 0.625f + yOff));
            QuadModifier topMod = mod.derive().apply(Modifiers.cutSideUpDown(true, 0.25f + yOff));
            topMod.export(quadMap.get(null));
            topMod.apply(Modifiers.setPosition(0.125f)).export(quadMap.get(null));
            QuadModifier botMod = mod.derive().apply(Modifiers.cutSideUpDown(false, 0.5625f - yOff));
            botMod.export(quadMap.get(null));
            botMod.apply(Modifiers.setPosition(0.125f)).export(quadMap.get(null));
            mod.apply(Modifiers.cutSideUpDown(false, 0.75f - yOff)).apply(Modifiers.cutSideUpDown(true, 0.4375f + yOff)).apply(Modifiers.cutSideLeftRight(this.dir.m_122424_(), 0.1875f)).export(quadMap.get(null));
            mod.apply(Modifiers.setPosition(0.125f)).export(quadMap.get(null));
        } else if (Utils.isY(quadDir)) {
            boolean up = quadDir == Direction.UP;
            float heightOuter = up ? 0.9375f - yOff : 0.625f + yOff;
            float heightInner = up ? 0.5625f - yOff : 0.25f + yOff;
            QuadModifier mod = QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(this.dir, 0.9375f)).apply(Modifiers.cutTopBottom(this.dir.m_122424_(), 0.4375f));
            QuadModifier leftMod = mod.derive().apply(Modifiers.cutTopBottom(this.dir.m_122427_(), 0.125f)).apply(Modifiers.setPosition(heightOuter));
            leftMod.export(quadMap.get(null));
            leftMod.apply(Modifiers.cutTopBottom(this.dir, 0.8125f)).apply(Modifiers.setPosition(heightInner)).export(quadMap.get(null));
            QuadModifier rightMod = mod.apply(Modifiers.cutTopBottom(this.dir.m_122428_(), 0.125f)).apply(Modifiers.setPosition(heightOuter));
            rightMod.export(quadMap.get(null));
            rightMod.apply(Modifiers.cutTopBottom(this.dir, 0.8125f)).apply(Modifiers.setPosition(heightInner)).export(quadMap.get(null));
        } else if (quadDir == this.dir) {
            QuadModifier.geometry(quad).apply(Modifiers.cutSide(0.0f, 0.375f - yOff, 0.125f, 0.9375f - yOff)).apply(Modifiers.setPosition(0.9375f)).export(quadMap.get(null));
            QuadModifier.geometry(quad).apply(Modifiers.cutSide(0.875f, 0.375f - yOff, 1.0f, 0.9375f - yOff)).apply(Modifiers.setPosition(0.9375f)).export(quadMap.get(null));
        } else if (quadDir == this.dir.m_122424_()) {
            QuadModifier.geometry(quad).apply(Modifiers.cutSide(0.0f, 0.5625f - yOff, 0.125f, 0.75f - yOff)).apply(Modifiers.setPosition(0.1875f)).export(quadMap.get(null));
            QuadModifier.geometry(quad).apply(Modifiers.cutSide(0.875f, 0.5625f - yOff, 1.0f, 0.75f - yOff)).apply(Modifiers.setPosition(0.1875f)).export(quadMap.get(null));
        }
    }
}

