/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.data.IModelData;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.client.model.FramedChestModel;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.LatchType;

public class FramedChestLidModel
extends FramedBlockModel {
    private final Direction facing;
    private final LatchType latch;

    public FramedChestLidModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        this.facing = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        this.latch = (LatchType)((Object)state.m_61143_(PropertyHolder.LATCH_TYPE));
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        Direction quadDir = quad.m_111306_();
        if (Utils.isY(quad.m_111306_())) {
            QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(0.0625f, 0.0625f, 0.9375f, 0.9375f)).apply(Modifiers.setPosition(quadDir == Direction.UP ? 0.875f : 0.4375f)).export(quadMap.get(null));
        } else {
            QuadModifier.geometry(quad).apply(Modifiers.cutSide(0.0625f, 0.5625f, 0.9375f, 0.875f)).apply(Modifiers.setPosition(0.9375f)).export(quadMap.get(null));
        }
        if (this.latch == LatchType.CAMO) {
            FramedChestModel.makeChestLatch(quadMap, quad, this.facing);
        }
    }

    @Override
    protected boolean hasAdditionalQuadsInLayer(RenderType layer) {
        return this.latch == LatchType.DEFAULT && layer == RenderType.m_110463_();
    }

    @Override
    protected void getAdditionalQuads(Map<Direction, List<BakedQuad>> quadMap, BlockState state, Random rand, IModelData data, RenderType layer) {
        List quads = this.baseModel.getQuads(state, null, rand, data);
        for (BakedQuad quad : quads) {
            quadMap.get(null).add(quad);
        }
    }
}

