/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.model;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.WeightedBakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import xfacthd.framedblocks.api.FramedBlocksAPI;
import xfacthd.framedblocks.api.FramedBlocksClientAPI;
import xfacthd.framedblocks.api.block.FramedBlockEntity;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.model.BakedModelProxy;
import xfacthd.framedblocks.api.type.IBlockType;
import xfacthd.framedblocks.api.util.FramedBlockData;
import xfacthd.framedblocks.api.util.Utils;

public abstract class FramedBlockModel
extends BakedModelProxy {
    private final Table<BlockState, RenderType, Map<Direction, List<BakedQuad>>> quadCacheTable = HashBasedTable.create();
    private final Map<BlockState, BakedModel> modelCache = new HashMap<BlockState, BakedModel>();
    private final BlockState state;
    private final IBlockType type;
    private final Map<BlockState, BakedModel> fluidModels = new HashMap<BlockState, BakedModel>();
    private static final MethodHandle WBM_WRAPPED_MODEL = Utils.unreflectField(WeightedBakedModel.class, "f_119542_");

    public FramedBlockModel(BlockState state, BakedModel baseModel) {
        super(baseModel);
        this.state = state;
        this.type = ((IFramedBlock)state.m_60734_()).getBlockType();
    }

    public List<BakedQuad> getQuads(BlockState state, Direction side, Random rand, IModelData extraData) {
        boolean baseModelInLayer;
        RenderType layer = MinecraftForgeClient.getRenderType();
        BlockState camoState = Blocks.f_50016_.m_49966_();
        if (state == null) {
            state = this.state;
        }
        if (extraData instanceof FramedBlockData) {
            FramedBlockData data = (FramedBlockData)extraData;
            if (layer != null) {
                boolean camoInLayer;
                if (side != null && data.isSideHidden(side)) {
                    return Collections.emptyList();
                }
                camoState = data.getCamoState();
                if (camoState != null && !camoState.m_60795_() && ((camoInLayer = FramedBlockModel.canRenderInLayer(camoState, layer)) || this.hasAdditionalQuadsInLayer(layer))) {
                    return this.getCamoQuads(state, camoState, side, rand, extraData, layer, camoInLayer, false);
                }
            }
        }
        if (layer == null) {
            layer = RenderType.m_110463_();
        }
        if ((camoState == null || camoState.m_60795_()) && ((baseModelInLayer = this.canRenderBaseModelInLayer(layer)) || this.hasAdditionalQuadsInLayer(layer))) {
            boolean forceUngenerated = baseModelInLayer && this.forceUngeneratedBaseModel();
            return this.getCamoQuads(state, FramedBlocksAPI.getInstance().defaultModelState(), side, rand, extraData, layer, baseModelInLayer, forceUngenerated);
        }
        return Collections.emptyList();
    }

    @Override
    public List<BakedQuad> m_6840_(BlockState state, Direction side, Random rand) {
        if (state == null) {
            state = this.state;
        }
        return this.getCamoQuads(state, FramedBlocksAPI.getInstance().defaultModelState(), side, rand, (IModelData)EmptyModelData.INSTANCE, RenderType.m_110463_(), true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<BakedQuad> getCamoQuads(BlockState state, BlockState camoState, Direction side, Random rand, IModelData extraData, RenderType layer, boolean camoInLayer, boolean noProcessing) {
        if (noProcessing || this.type.getCtmPredicate().test(state, side)) {
            boolean additionalQuads = this.hasAdditionalQuadsInLayer(layer);
            if (!camoInLayer && !additionalQuads) {
                return Collections.emptyList();
            }
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            if (camoInLayer) {
                BakedModel model;
                Map<BlockState, BakedModel> map = this.modelCache;
                synchronized (map) {
                    if (!this.modelCache.containsKey(camoState)) {
                        this.modelCache.put(camoState, this.getCamoModel(camoState));
                    }
                    model = this.modelCache.get(camoState);
                }
                IModelData data = FramedBlockModel.getCamoData(model, camoState, extraData);
                quads.addAll(model.getQuads(camoState, side, rand, data));
            }
            if (additionalQuads) {
                this.getAdditionalQuads(quads, side, state, rand, extraData, layer);
            }
            return quads;
        }
        Table<BlockState, RenderType, Map<Direction, List<BakedQuad>>> table = this.quadCacheTable;
        synchronized (table) {
            if (!this.quadCacheTable.contains((Object)camoState, (Object)layer)) {
                this.quadCacheTable.put((Object)camoState, (Object)layer, this.makeQuads(state, camoState, rand, extraData, layer, camoInLayer));
            }
            return (List)((Map)this.quadCacheTable.get((Object)camoState, (Object)layer)).get(side);
        }
    }

    private Map<Direction, List<BakedQuad>> makeQuads(BlockState state, BlockState camoState, Random rand, IModelData data, RenderType layer, boolean camoInLayer) {
        Object2ObjectArrayMap quadMap = new Object2ObjectArrayMap(7);
        quadMap.put(null, new ArrayList());
        for (Direction dir : Direction.values()) {
            quadMap.put(dir, new ArrayList());
        }
        if (camoInLayer) {
            BakedModel camoModel = this.getCamoModel(camoState);
            List<BakedQuad> quads = FramedBlockModel.getAllQuads(camoModel, camoState, rand).stream().filter(q -> !this.type.getCtmPredicate().test(state, q.m_111306_())).toList();
            for (BakedQuad quad : quads) {
                this.transformQuad((Map<Direction, List<BakedQuad>>)quadMap, quad);
            }
            this.postProcessQuads((Map<Direction, List<BakedQuad>>)quadMap);
        }
        if (this.hasAdditionalQuadsInLayer(layer)) {
            this.getAdditionalQuads((Map<Direction, List<BakedQuad>>)quadMap, state, rand, data, layer);
        }
        return quadMap;
    }

    protected abstract void transformQuad(Map<Direction, List<BakedQuad>> var1, BakedQuad var2);

    protected void postProcessQuads(Map<Direction, List<BakedQuad>> quadMap) {
    }

    protected boolean hasAdditionalQuadsInLayer(RenderType layer) {
        return false;
    }

    protected boolean forceUngeneratedBaseModel() {
        return false;
    }

    protected void getAdditionalQuads(List<BakedQuad> quads, Direction side, BlockState state, Random rand, IModelData data, RenderType layer) {
    }

    protected void getAdditionalQuads(Map<Direction, List<BakedQuad>> quadMap, BlockState state, Random rand, IModelData data, RenderType layer) {
    }

    protected boolean canRenderBaseModelInLayer(RenderType layer) {
        return layer == RenderType.m_110463_();
    }

    @Nonnull
    public IModelData getModelData(@Nonnull BlockAndTintGetter world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull IModelData tileData) {
        BlockEntity blockEntity;
        FramedBlockData data;
        boolean ghostData;
        boolean bl = ghostData = tileData instanceof FramedBlockData && (data = (FramedBlockData)tileData).isGhostData();
        if (!ghostData && (blockEntity = world.m_7702_(pos)) instanceof FramedBlockEntity) {
            FramedBlockEntity be = (FramedBlockEntity)blockEntity;
            tileData = be.getModelData();
        }
        tileData.setData(FramedBlockData.LEVEL, (Object)world);
        tileData.setData(FramedBlockData.POS, (Object)pos);
        return tileData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextureAtlasSprite getParticleIcon(IModelData data) {
        BlockState camoState;
        if (data instanceof FramedBlockData && (camoState = (BlockState)data.getData(FramedBlockData.CAMO)) != null && !camoState.m_60795_()) {
            Map<BlockState, BakedModel> map = this.modelCache;
            synchronized (map) {
                return this.modelCache.computeIfAbsent(camoState, state -> this.getCamoModel(camoState)).m_6160_();
            }
        }
        return this.baseModel.m_6160_();
    }

    protected BakedModel getCamoModel(BlockState camoState) {
        Block block = camoState.m_60734_();
        if (block instanceof LiquidBlock) {
            LiquidBlock fluid = (LiquidBlock)block;
            return this.fluidModels.computeIfAbsent(camoState, state -> FramedBlocksClientAPI.getInstance().createFluidModel((Fluid)fluid.getFluid()));
        }
        return Minecraft.m_91087_().m_91289_().m_110910_(camoState);
    }

    private static IModelData getCamoData(BakedModel model, BlockState state, IModelData data) {
        BlockAndTintGetter level = (BlockAndTintGetter)data.getData(FramedBlockData.LEVEL);
        BlockPos pos = (BlockPos)data.getData(FramedBlockData.POS);
        if (level == null || pos == null || pos.equals((Object)BlockPos.f_121853_)) {
            return data;
        }
        return model.getModelData(level, pos, state, data);
    }

    protected static List<BakedQuad> getAllQuads(BakedModel model, BlockState state, Random rand) {
        if (model instanceof WeightedBakedModel) {
            WeightedBakedModel weighted = (WeightedBakedModel)model;
            try {
                model = WBM_WRAPPED_MODEL.invokeExact(weighted);
            }
            catch (Throwable e) {
                throw new RuntimeException("Failed to access field 'WeightedBakedModel#wrapped'", e);
            }
            Objects.requireNonNull(model, "Wrapped model of WeightedBakedModel is null?!");
        }
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        for (Direction dir : Direction.values()) {
            quads.addAll(model.getQuads(state, dir, rand, (IModelData)EmptyModelData.INSTANCE));
        }
        return quads;
    }

    private static boolean canRenderInLayer(BlockState camoState, RenderType layer) {
        if (camoState == null) {
            return false;
        }
        if (camoState.m_60734_() instanceof LiquidBlock) {
            return ItemBlockRenderTypes.canRenderInLayer((FluidState)camoState.m_60819_(), (RenderType)layer);
        }
        return ItemBlockRenderTypes.canRenderInLayer((BlockState)camoState, (RenderType)layer);
    }
}

