/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.block;

import com.mojang.logging.LogUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.slf4j.Logger;
import xfacthd.framedblocks.api.FramedBlocksAPI;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.type.IBlockType;
import xfacthd.framedblocks.api.util.FramedBlockData;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.api.util.client.ClientUtils;

public class FramedBlockEntity
extends BlockEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final TranslatableComponent MSG_BLACKLISTED = Utils.translate("msg", "blacklisted");
    public static final TranslatableComponent MSG_BLOCK_ENTITY = Utils.translate("msg", "block_entity");
    private static final Direction[] DIRECTIONS = Direction.values();
    private final FramedBlockData modelData = new FramedBlockData(false);
    private ItemStack camoStack = ItemStack.f_41583_;
    private BlockState camoState = Blocks.f_50016_.m_49966_();
    private boolean glowing = false;
    private boolean intangible = false;
    private boolean recheckStates = false;

    public FramedBlockEntity(BlockPos pos, BlockState state) {
        this(FramedBlocksAPI.getInstance().defaultBlockEntity(), pos, state);
    }

    protected FramedBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public final InteractionResult handleInteraction(Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        BlockState camo = this.getCamoState(hit);
        if (!camo.m_60795_() && !(camo.m_60734_() instanceof LiquidBlock) && stack.m_150930_((Item)Utils.FRAMED_HAMMER.get())) {
            return this.clearBlockCamo(player, hit);
        }
        if (!camo.m_60795_() && camo.m_60734_() instanceof LiquidBlock && stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent()) {
            return InteractionResult.PASS;
        }
        if (camo.m_60795_() && stack.m_41720_() instanceof BlockItem) {
            return this.setBlockCamo(player, stack, hit);
        }
        if (camo.m_60795_() && stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent()) {
            return InteractionResult.PASS;
        }
        if (stack.m_204117_(Tags.Items.DUSTS_GLOWSTONE) && !this.glowing) {
            if (!this.f_58857_.m_5776_()) {
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                int light = this.getLightValue();
                this.glowing = true;
                if (!this.updateDynamicStates(false, true)) {
                    this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
                }
                boolean lightUpdate = this.getLightValue() != light;
                this.m_6596_();
                if (lightUpdate) {
                    this.doLightUpdate();
                }
            }
            return InteractionResult.m_19078_((boolean)this.f_58857_.m_5776_());
        }
        if (!camo.m_60795_() && !player.m_6144_() && stack.m_150930_((Item)Utils.FRAMED_SCREWDRIVER.get())) {
            return this.rotateCamo(camo, hit);
        }
        if (!this.intangible && this.canMakeIntangible(stack)) {
            if (!this.f_58857_.m_5776_()) {
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                this.setIntangible(true);
            }
            return InteractionResult.m_19078_((boolean)this.f_58857_.m_5776_());
        }
        if (this.intangible && player.m_6144_() && stack.m_150930_((Item)Utils.FRAMED_SCREWDRIVER.get())) {
            if (!this.f_58857_.m_5776_()) {
                this.setIntangible(false);
                ItemStack result = new ItemStack((ItemLike)FramedBlocksAPI.getInstance().getIntangibilityMarkerItem());
                if (!player.m_150109_().m_36054_(result)) {
                    player.m_36176_(result, false);
                }
            }
            return InteractionResult.m_19078_((boolean)this.f_58857_.m_5776_());
        }
        return InteractionResult.PASS;
    }

    private boolean canMakeIntangible(ItemStack stack) {
        if (!FramedBlocksAPI.getInstance().enableIntangibility()) {
            return false;
        }
        return stack.m_150930_(FramedBlocksAPI.getInstance().getIntangibilityMarkerItem()) && this.getBlockType().allowMakingIntangible();
    }

    private InteractionResult clearBlockCamo(Player player, BlockHitResult hit) {
        if (!this.f_58857_.m_5776_()) {
            int light = this.getLightValue();
            ItemStack camoStack = this.getCamoStack(hit);
            if (!(player.m_7500_() && player.m_150109_().m_36063_(camoStack) || player.m_150109_().m_36054_(camoStack))) {
                player.m_36176_(camoStack, false);
            }
            this.applyCamo(ItemStack.f_41583_, Blocks.f_50016_.m_49966_(), hit);
            if (!this.updateDynamicStates(true, true)) {
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            }
            boolean lightUpdate = this.getLightValue() != light;
            this.m_6596_();
            if (lightUpdate) {
                this.doLightUpdate();
            }
        }
        return InteractionResult.m_19078_((boolean)this.f_58857_.m_5776_());
    }

    private InteractionResult clearFluidCamo(Player player, BlockState camo, ItemStack stack, BlockHitResult hit) {
        LazyOptional cap = stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY);
        return cap.map(handler -> {
            FluidStack fluid = new FluidStack((Fluid)((LiquidBlock)camo.m_60734_()).getFluid(), 1000);
            if (handler.fill(fluid, IFluidHandler.FluidAction.SIMULATE) == 1000) {
                if (!this.f_58857_.m_5776_()) {
                    if (!player.m_7500_()) {
                        if (stack.m_41720_() == Items.f_42446_) {
                            stack.m_41774_(1);
                            ItemStack result = new ItemStack((ItemLike)fluid.getFluid().m_6859_());
                            if (!player.m_150109_().m_36054_(result)) {
                                player.m_36176_(result, false);
                            }
                        } else {
                            handler.fill(fluid, IFluidHandler.FluidAction.EXECUTE);
                        }
                    }
                    int light = this.getLightValue();
                    this.applyCamo(ItemStack.f_41583_, Blocks.f_50016_.m_49966_(), hit);
                    if (!this.updateDynamicStates(false, true)) {
                        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
                    }
                    boolean lightUpdate = this.getLightValue() != light;
                    this.m_6596_();
                    if (lightUpdate) {
                        this.doLightUpdate();
                    }
                }
                return InteractionResult.m_19078_((boolean)this.f_58857_.m_5776_());
            }
            return InteractionResult.FAIL;
        }).orElse(InteractionResult.FAIL);
    }

    private InteractionResult setBlockCamo(Player player, ItemStack stack, BlockHitResult hit) {
        BlockState state = ((BlockItem)stack.m_41720_()).m_40614_().m_49966_();
        if (this.isValidBlock(state, player)) {
            if (!this.f_58857_.m_5776_()) {
                int light = this.getLightValue();
                this.applyCamo(stack.m_41620_(1), state, hit);
                if (!this.updateDynamicStates(true, true)) {
                    this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
                }
                if (player.m_7500_()) {
                    stack.m_41769_(1);
                }
                this.m_6596_();
                if (this.getLightValue() != light) {
                    this.doLightUpdate();
                }
            }
            return InteractionResult.m_19078_((boolean)this.f_58857_.m_5776_());
        }
        return InteractionResult.FAIL;
    }

    private InteractionResult setFluidCamo(Player player, ItemStack stack, BlockHitResult hit) {
        LazyOptional cap = stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY);
        return cap.map(handler -> {
            FluidStack fluid = handler.getFluidInTank(0);
            BlockState state = (BlockState)fluid.getFluid().m_76145_().m_76188_().m_61124_((Property)BlockStateProperties.f_61422_, (Comparable)Integer.valueOf(8));
            if (!state.m_60795_()) {
                ItemStack bucket = new ItemStack((ItemLike)fluid.getFluid().m_6859_());
                if (fluid.getAmount() >= 1000 && !bucket.m_41619_() && handler.drain(1000, IFluidHandler.FluidAction.SIMULATE).getAmount() == 1000) {
                    if (!this.f_58857_.m_5776_()) {
                        if (!player.m_7500_()) {
                            if (stack.m_41720_() instanceof BucketItem) {
                                stack.m_41774_(1);
                                ItemStack emptyBucket = new ItemStack((ItemLike)Items.f_42446_);
                                if (!player.m_150109_().m_36054_(emptyBucket)) {
                                    player.m_36176_(emptyBucket, false);
                                }
                            } else {
                                handler.drain(1000, IFluidHandler.FluidAction.EXECUTE);
                            }
                        }
                        int light = this.getLightValue();
                        this.applyCamo(ItemStack.f_41583_, state, hit);
                        if (!this.updateDynamicStates(false, true)) {
                            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
                        }
                        this.m_6596_();
                        if (this.getLightValue() != light) {
                            this.doLightUpdate();
                        }
                    }
                    return InteractionResult.m_19078_((boolean)this.f_58857_.m_5776_());
                }
            }
            return InteractionResult.FAIL;
        }).orElse(InteractionResult.FAIL);
    }

    private InteractionResult rotateCamo(BlockState camo, BlockHitResult hit) {
        Property<?> prop = FramedBlockEntity.getRotatableProperty(camo);
        if (prop != null) {
            if (!this.f_58857_.m_5776_()) {
                this.applyCamo(this.getCamoStack(hit), (BlockState)camo.m_61122_(prop), hit);
                this.m_6596_();
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            }
            return InteractionResult.m_19078_((boolean)this.f_58857_.m_5776_());
        }
        return InteractionResult.FAIL;
    }

    private static Property<?> getRotatableProperty(BlockState state) {
        for (Property prop : state.m_61147_()) {
            if (prop.m_61709_() == Direction.Axis.class) {
                return prop;
            }
            if (!(prop instanceof DirectionProperty)) continue;
            return prop;
        }
        return null;
    }

    protected final boolean isValidBlock(BlockState state, Player player) {
        Block block = state.m_60734_();
        if (block instanceof IFramedBlock) {
            return false;
        }
        if (state.m_204336_(Utils.BLACKLIST)) {
            if (player != null) {
                player.m_5661_((Component)MSG_BLACKLISTED, true);
            }
            return false;
        }
        if (state.m_155947_() && !FramedBlocksAPI.getInstance().allowBlockEntities()) {
            if (player != null) {
                player.m_5661_((Component)MSG_BLOCK_ENTITY, true);
            }
            return false;
        }
        return state.m_60804_((BlockGetter)this.f_58857_, this.f_58858_) || state.m_204336_(Utils.FRAMEABLE);
    }

    protected void applyCamo(ItemStack camoStack, BlockState camoState, BlockHitResult hit) {
        this.camoStack = camoStack;
        this.camoState = camoState;
    }

    public void setCamo(ItemStack camoStack, BlockState camoState, boolean secondary) {
        int light = this.getLightValue();
        this.camoStack = camoStack;
        this.camoState = camoState;
        this.m_6596_();
        if (this.getLightValue() != light) {
            this.doLightUpdate();
        }
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
    }

    public boolean isSolidSide(Direction side) {
        return this.getBlock().getCtmPredicate().test(this.m_58900_(), side) && this.camoState.m_60804_((BlockGetter)this.f_58857_, this.f_58858_);
    }

    public BlockState getCamoState(Direction side) {
        return this.camoState;
    }

    protected BlockState getCamoState(BlockHitResult hit) {
        return this.camoState;
    }

    public final BlockState getCamoState() {
        return this.camoState;
    }

    protected ItemStack getCamoStack(BlockHitResult hit) {
        return this.camoStack;
    }

    public final ItemStack getCamoStack() {
        return this.camoStack;
    }

    protected boolean isCamoSolid() {
        return !this.camoState.m_60795_() && this.camoState.m_60804_((BlockGetter)this.f_58857_, this.f_58858_);
    }

    public final void checkCamoSolid() {
        if (this.getBlock().getBlockType().canOccludeWithSolidCamo() && !this.camoState.m_60795_()) {
            this.updateDynamicStates(true, false);
        }
    }

    protected final boolean updateDynamicStates(boolean updateSolid, boolean updateLight) {
        if (!this.getBlock().getBlockType().canOccludeWithSolidCamo()) {
            return false;
        }
        BlockState state = this.m_58900_();
        boolean changed = false;
        if (updateSolid) {
            boolean solid;
            boolean wasSolid = (Boolean)this.m_58900_().m_61143_((Property)FramedProperties.SOLID);
            boolean bl = solid = !this.intangible && this.isCamoSolid();
            if (solid != wasSolid) {
                state = (BlockState)state.m_61124_((Property)FramedProperties.SOLID, (Comparable)Boolean.valueOf(solid));
                changed = true;
            }
        }
        if (updateLight) {
            boolean isGlowing;
            boolean bl = isGlowing = this.getLightValue() > 0;
            if (isGlowing != (Boolean)state.m_61143_((Property)FramedProperties.GLOWING)) {
                state = (BlockState)state.m_61124_((Property)FramedProperties.GLOWING, (Comparable)Boolean.valueOf(isGlowing));
                changed = true;
            }
        }
        if (changed) {
            this.f_58857_.m_7731_(this.f_58858_, state, 3);
        }
        return changed;
    }

    public final void updateCulling(boolean neighbors, boolean rerender) {
        boolean changed = false;
        for (Direction dir : DIRECTIONS) {
            BlockEntity blockEntity;
            changed |= this.updateCulling(dir, false);
            if (!neighbors || !((blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_142300_(dir))) instanceof FramedBlockEntity)) continue;
            FramedBlockEntity be = (FramedBlockEntity)blockEntity;
            be.updateCulling(dir.m_122424_(), true);
        }
        if (rerender && changed) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public boolean updateCulling(Direction side, boolean rerender) {
        return this.updateCulling(this.modelData, this.m_58900_(), side, rerender);
    }

    protected final boolean updateCulling(FramedBlockData modelData, BlockState testState, Direction side, boolean rerender) {
        boolean hidden;
        boolean wasHidden = modelData.isSideHidden(side);
        if (wasHidden != (hidden = ((IFramedBlock)testState.m_60734_()).isSideHidden((BlockGetter)this.f_58857_, this.f_58858_, testState, side))) {
            modelData.setSideHidden(side, hidden);
            if (rerender) {
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            }
            return true;
        }
        return false;
    }

    public float getCamoExplosionResistance(Explosion explosion) {
        return this.camoState.getExplosionResistance((BlockGetter)this.f_58857_, this.f_58858_, explosion);
    }

    public boolean isCamoFlammable(Direction face) {
        return this.camoState.m_60795_() || this.camoState.isFlammable((BlockGetter)this.f_58857_, this.f_58858_, face);
    }

    public int getCamoFlammability(Direction face) {
        return this.getCamoState().m_60795_() ? -1 : this.getCamoState().getFlammability((BlockGetter)this.f_58857_, this.f_58858_, face);
    }

    public final void setGlowing(boolean glowing) {
        if (this.glowing != glowing) {
            int oldLight = this.getLightValue();
            this.glowing = glowing;
            if (oldLight != this.getLightValue()) {
                this.doLightUpdate();
            }
            this.m_6596_();
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public final boolean isGlowing() {
        return this.glowing;
    }

    public int getLightValue() {
        if (this.glowing) {
            return 15;
        }
        return this.camoState.m_60791_();
    }

    public void setIntangible(boolean intangible) {
        if (this.intangible != intangible) {
            this.intangible = intangible;
            this.m_6596_();
            if (!this.updateDynamicStates(true, false)) {
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            }
        }
    }

    public boolean isIntangible(CollisionContext ctx) {
        EntityCollisionContext ectx;
        Entity entity;
        if (!FramedBlocksAPI.getInstance().enableIntangibility() || !this.intangible) {
            return false;
        }
        if (ctx instanceof EntityCollisionContext && (entity = (ectx = (EntityCollisionContext)ctx).m_193113_()) instanceof Player) {
            Player player = (Player)entity;
            ItemStack mainItem = player.m_21205_();
            return !mainItem.m_204117_(Utils.DISABLE_INTANGIBLE);
        }
        return true;
    }

    protected final void doLightUpdate() {
        this.f_58857_.m_7726_().m_7827_().m_142202_(this.f_58858_);
    }

    public final IFramedBlock getBlock() {
        return (IFramedBlock)this.m_58900_().m_60734_();
    }

    public final IBlockType getBlockType() {
        return this.getBlock().getBlockType();
    }

    public void addCamoDrops(List<ItemStack> drops) {
        if (!this.camoStack.m_41619_()) {
            drops.add(this.camoStack);
        }
    }

    public MaterialColor getMapColor() {
        if (!this.camoState.m_60795_()) {
            return this.camoState.m_60780_((BlockGetter)this.f_58857_, this.f_58858_);
        }
        return null;
    }

    public float[] getCamoBeaconColorMultiplier(LevelReader level, BlockPos pos, BlockPos beaconPos) {
        if (!this.camoState.m_60795_()) {
            return this.camoState.getBeaconColorMultiplier(level, pos, beaconPos);
        }
        return null;
    }

    public void onLoad() {
        if (!this.f_58857_.m_5776_() && this.recheckStates) {
            this.checkCamoSolid();
        }
        super.onLoad();
    }

    public final ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public final void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag nbt = pkt.m_131708_();
        if (nbt != null && this.readFromDataPacket(nbt)) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    protected void writeToDataPacket(CompoundTag nbt) {
        nbt.m_128365_("camo_stack", (Tag)this.camoStack.m_41739_(new CompoundTag()));
        nbt.m_128365_("camo_state", (Tag)NbtUtils.m_129202_((BlockState)this.camoState));
        nbt.m_128379_("glowing", this.glowing);
        nbt.m_128379_("intangible", this.intangible);
    }

    protected boolean readFromDataPacket(CompoundTag nbt) {
        boolean newIntangible;
        boolean newGlow;
        this.camoStack = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("camo_stack"));
        boolean needUpdate = false;
        boolean needCullingUpdate = false;
        BlockState newState = NbtUtils.m_129241_((CompoundTag)nbt.m_128469_("camo_state"));
        if (newState != this.camoState) {
            int oldLight = this.getLightValue();
            this.camoState = newState;
            if (oldLight != this.getLightValue()) {
                this.doLightUpdate();
            }
            this.modelData.setCamoState(this.camoState);
            needUpdate = true;
            needCullingUpdate = true;
        }
        if ((newGlow = nbt.m_128471_("glowing")) != this.glowing) {
            this.glowing = newGlow;
            needUpdate = true;
            this.doLightUpdate();
        }
        if ((newIntangible = nbt.m_128471_("intangible")) != this.intangible) {
            this.intangible = newIntangible;
            needUpdate = true;
            needCullingUpdate = true;
        }
        if (needCullingUpdate) {
            this.updateCulling(true, false);
        }
        return needUpdate;
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        nbt.m_128365_("camo_stack", (Tag)this.camoStack.m_41739_(new CompoundTag()));
        nbt.m_128365_("camo_state", (Tag)NbtUtils.m_129202_((BlockState)this.camoState));
        nbt.m_128379_("glowing", this.glowing);
        nbt.m_128379_("intangible", this.intangible);
        return nbt;
    }

    public void handleUpdateTag(CompoundTag nbt) {
        this.camoStack = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("camo_stack"));
        BlockState newState = NbtUtils.m_129241_((CompoundTag)nbt.m_128469_("camo_state"));
        if (newState != this.camoState) {
            this.camoState = newState;
            this.modelData.setCamoState(this.camoState);
            ClientUtils.enqueueClientTask(() -> this.updateCulling(true, true));
        }
        this.glowing = nbt.m_128471_("glowing");
        this.intangible = nbt.m_128471_("intangible");
    }

    public IModelData getModelData() {
        return this.modelData;
    }

    protected final FramedBlockData getModelDataInternal() {
        return this.modelData;
    }

    protected void initModelData() {
        this.modelData.setCamoState(this.camoState);
    }

    public void m_142339_(Level level) {
        super.m_142339_(level);
        if (level.m_5776_()) {
            this.initModelData();
        }
    }

    public CompoundTag writeToBlueprint() {
        return this.m_187482_();
    }

    public void m_183515_(CompoundTag nbt) {
        nbt.m_128365_("camo_stack", (Tag)this.camoStack.m_41739_(new CompoundTag()));
        nbt.m_128365_("camo_state", (Tag)NbtUtils.m_129202_((BlockState)this.camoState));
        nbt.m_128379_("glowing", this.glowing);
        nbt.m_128379_("intangible", this.intangible);
        nbt.m_128344_("updated", (byte)2);
        super.m_183515_(nbt);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        BlockState state = NbtUtils.m_129241_((CompoundTag)nbt.m_128469_("camo_state"));
        if (state.m_60795_() || this.isValidBlock(state, null)) {
            this.recheckStates = nbt.m_128445_("updated") < 2;
            this.camoStack = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("camo_stack"));
            this.camoState = state;
        } else {
            this.recheckStates = true;
            LOGGER.warn("Framed Block of type \"{}\" at position {} contains an invalid camo of type \"{}\", removing camo! This might be caused by a config or tag change!", new Object[]{this.m_58900_().m_60734_().getRegistryName(), this.f_58858_, state.m_60734_().getRegistryName()});
        }
        this.glowing = nbt.m_128471_("glowing");
        this.intangible = nbt.m_128471_("intangible");
    }
}

