/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.block;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.IBlockRenderProperties;
import xfacthd.framedblocks.FramedBlocks;
import xfacthd.framedblocks.api.block.FramedBlockEntity;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.type.IBlockType;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.client.FramedBlockRenderProperties;

public abstract class AbstractFramedBlock
extends Block
implements IFramedBlock,
SimpleWaterloggedBlock {
    private static final VoxelShape BEACON_BEAM_SHAPE = AbstractFramedBlock.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private final IBlockType blockType;
    private final Map<BlockState, VoxelShape> shapes;
    private final Object2BooleanMap<BlockState> beaconBeamOcclusion;

    public AbstractFramedBlock(IBlockType blockType, BlockBehaviour.Properties props) {
        super(props);
        this.blockType = blockType;
        this.shapes = blockType.generateShapes((ImmutableList<BlockState>)this.m_49965_().m_61056_());
        this.beaconBeamOcclusion = AbstractFramedBlock.computeBeaconBeamOcclusion(this.shapes);
        if (blockType.canOccludeWithSolidCamo()) {
            this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FramedProperties.SOLID, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FramedProperties.GLOWING, (Comparable)Boolean.valueOf(false)));
        }
        if (blockType.supportsWaterLogging()) {
            this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return this.handleUse(level, pos, player, hand, hit);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        this.tryApplyCamoImmediately(level, pos, placer, stack);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        this.updateCulling(level, pos, facingState, facing, false);
        if (this.isWaterLoggable() && ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, facing, facingState, level, pos, facingPos);
    }

    public void onBlockStateChange(LevelReader level, BlockPos pos, BlockState oldState, BlockState newState) {
        this.onStateChange(level, pos, oldState, newState);
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        return this.getLight(level, pos);
    }

    public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, Entity entity) {
        return this.getCamoSound(state, level, pos);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        if (this.isIntangible(state, level, pos, ctx)) {
            return Shapes.m_83040_();
        }
        return this.shapes.get(state);
    }

    public boolean m_7923_(BlockState state) {
        return this.useCamoOcclusionShapeForLightOcclusion(state);
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter level, BlockPos pos) {
        return this.getCamoOcclusionShape(state, level, pos);
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return this.getCamoVisualShape(state, level, pos, ctx);
    }

    public float getFriction(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        return this.getCamoSlipperiness(state, level, pos, entity);
    }

    public float m_7749_(BlockState state, BlockGetter level, BlockPos pos) {
        return 1.0f;
    }

    public float getExplosionResistance(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        return this.getCamoExplosionResistance(state, level, pos, explosion);
    }

    public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction face) {
        return this.isCamoFlammable(level, pos, face);
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction face) {
        return this.getCamoFlammability(level, pos, face);
    }

    public FluidState m_5888_(BlockState state) {
        if (this.isWaterLoggable() && ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            return Fluids.f_76193_.m_76068_(false);
        }
        return Fluids.f_76191_.m_76145_();
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new FramedBlockEntity(pos, state);
    }

    public boolean m_6044_(BlockGetter level, BlockPos pos, BlockState state, Fluid fluid) {
        if (!this.isWaterLoggable()) {
            return false;
        }
        return super.m_6044_(level, pos, state, fluid);
    }

    public boolean m_7361_(LevelAccessor pLevel, BlockPos pPos, BlockState pState, FluidState pFluidState) {
        if (!this.isWaterLoggable()) {
            return false;
        }
        return super.m_7361_(pLevel, pPos, pState, pFluidState);
    }

    public ItemStack m_142598_(LevelAccessor level, BlockPos pos, BlockState state) {
        if (!this.isWaterLoggable()) {
            return ItemStack.f_41583_;
        }
        return super.m_142598_(level, pos, state);
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        return this.getCamoDrops(super.m_7381_(state, builder), builder);
    }

    public boolean hidesNeighborFace(BlockGetter level, BlockPos pos, BlockState state, BlockState neighborState, Direction dir) {
        return this.doesHideNeighborFace(level, pos, state, neighborState, dir);
    }

    public MaterialColor getMapColor(BlockState state, BlockGetter level, BlockPos pos, MaterialColor defaultColor) {
        return this.getCamoMapColor(level, pos, defaultColor);
    }

    public float[] getBeaconColorMultiplier(BlockState state, LevelReader level, BlockPos pos, BlockPos beaconPos) {
        if (this.doesBlockOccludeBeaconBeam(state, level, pos)) {
            return this.getCamoBeaconColorMultiplier(level, pos, beaconPos);
        }
        return null;
    }

    protected boolean doesBlockOccludeBeaconBeam(BlockState state, LevelReader level, BlockPos pos) {
        if (this.beaconBeamOcclusion == null) {
            FramedBlocks.LOGGER.warn("Block '{}' handles shapes itself but doesn't override AbstractFramedBlock#doesBlockMaskBeaconBeam()", (Object)this);
            return false;
        }
        return this.beaconBeamOcclusion.getBoolean((Object)state);
    }

    @Override
    public IBlockType getBlockType() {
        return this.blockType;
    }

    protected final boolean isWaterLoggable() {
        return this.blockType.supportsWaterLogging();
    }

    public void initializeClient(Consumer<IBlockRenderProperties> consumer) {
        consumer.accept(new FramedBlockRenderProperties());
    }

    protected static BlockState withTop(BlockState state, Direction side, Vec3 hitVec) {
        return AbstractFramedBlock.withTop(state, (Property<Boolean>)FramedProperties.TOP, side, hitVec);
    }

    protected static BlockState withTop(BlockState state, Property<Boolean> prop, Direction side, Vec3 hitVec) {
        if (side == Direction.DOWN) {
            state = (BlockState)state.m_61124_(prop, (Comparable)Boolean.valueOf(true));
        } else if (side == Direction.UP) {
            state = (BlockState)state.m_61124_(prop, (Comparable)Boolean.valueOf(false));
        } else {
            double y = hitVec.f_82480_;
            state = (BlockState)state.m_61124_(prop, (Comparable)Boolean.valueOf((y -= Math.floor(y)) >= 0.5));
        }
        return state;
    }

    protected static BlockState withWater(BlockState state, LevelReader level, BlockPos pos) {
        FluidState fluidState = level.m_6425_(pos);
        return (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
    }

    private static Object2BooleanMap<BlockState> computeBeaconBeamOcclusion(Map<BlockState, VoxelShape> shapes) {
        if (shapes.isEmpty()) {
            return null;
        }
        Object2BooleanOpenHashMap beamColorMasking = new Object2BooleanOpenHashMap();
        shapes.forEach((arg_0, arg_1) -> AbstractFramedBlock.lambda$computeBeaconBeamOcclusion$0((Object2BooleanMap)beamColorMasking, arg_0, arg_1));
        return beamColorMasking;
    }

    private static /* synthetic */ void lambda$computeBeaconBeamOcclusion$0(Object2BooleanMap beamColorMasking, BlockState state, VoxelShape shape) {
        VoxelShape intersection = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)BEACON_BEAM_SHAPE, (BooleanOp)BooleanOp.f_82689_);
        beamColorMasking.put((Object)state, intersection.m_83288_(Direction.Axis.X) <= BEACON_BEAM_SHAPE.m_83288_(Direction.Axis.X) && intersection.m_83288_(Direction.Axis.Z) <= BEACON_BEAM_SHAPE.m_83288_(Direction.Axis.Z) && intersection.m_83297_(Direction.Axis.X) >= BEACON_BEAM_SHAPE.m_83297_(Direction.Axis.X) && intersection.m_83297_(Direction.Axis.Z) >= BEACON_BEAM_SHAPE.m_83297_(Direction.Axis.Z));
    }
}

