/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.BucketItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ITag;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.registries.ForgeRegistries;

public class FluidIngredient
extends Ingredient {
    private final Boolean advanced;
    private final List<Fluid> matchingFluids = new ArrayList<Fluid>();
    private final ITag<Fluid> fluidTag;
    private ItemStack[] bucketCache = null;
    private IntList matchingStacksPacked;
    public static Serializer SERIALIZER = new Serializer();

    private List<Fluid> getMatchingFluids() {
        if (!this.matchingFluids.isEmpty()) {
            return this.matchingFluids;
        }
        if (this.fluidTag != null) {
            this.matchingFluids.addAll(this.fluidTag.func_230236_b_());
        }
        return this.matchingFluids;
    }

    public FluidIngredient(ITag<Fluid> tagIn, boolean advancedIn) {
        super(Stream.empty());
        this.advanced = advancedIn;
        this.fluidTag = tagIn;
    }

    public FluidIngredient(Fluid fluidIn, boolean advancedIn) {
        super(Stream.empty());
        this.advanced = advancedIn;
        this.matchingFluids.add(fluidIn);
        this.fluidTag = null;
    }

    public FluidIngredient(List<Fluid> fluidList, boolean advancedIn) {
        super(Stream.empty());
        this.advanced = advancedIn;
        this.fluidTag = null;
        this.matchingFluids.addAll(fluidList);
    }

    public boolean func_203189_d() {
        return false;
    }

    public IntList func_194139_b() {
        if (this.matchingStacksPacked == null) {
            this.matchingStacksPacked = new IntArrayList(this.func_193365_a().length);
            for (ItemStack itemstack : this.bucketCache) {
                this.matchingStacksPacked.add(RecipeItemHelper.func_194113_b((ItemStack)itemstack));
            }
            this.matchingStacksPacked.sort((Comparator)IntComparators.NATURAL_COMPARATOR);
        }
        return this.matchingStacksPacked;
    }

    public JsonElement func_200304_c() {
        JsonObject json = new JsonObject();
        json.addProperty("type", Serializer.NAME.toString());
        json.addProperty("advanced", this.advanced);
        if (this.fluidTag != null) {
            json.addProperty("tag", TagCollectionManager.func_242178_a().func_241837_c().func_232975_b_(this.fluidTag).toString());
        } else {
            json.addProperty("fluid", this.getMatchingFluids().get(0).getRegistryName().toString());
        }
        return json;
    }

    @Nonnull
    public ItemStack[] func_193365_a() {
        if (this.bucketCache == null) {
            ArrayList tmp = new ArrayList();
            this.getMatchingFluids().forEach(fluid -> {
                ItemStack newBucket = FluidUtil.getFilledBucket((FluidStack)new FluidStack(fluid, 1000));
                if (!newBucket.func_190926_b()) {
                    tmp.add(newBucket);
                }
            });
            this.bucketCache = tmp.toArray(tmp.toArray(new ItemStack[0]));
        }
        return this.bucketCache;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return SERIALIZER;
    }

    public boolean test(@Nullable ItemStack stack) {
        LazyOptional cap = stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY);
        if (cap.isPresent()) {
            if (!this.advanced.booleanValue() && !(stack.func_77973_b() instanceof BucketItem)) {
                return false;
            }
            FluidStack fluid = ((IFluidHandlerItem)cap.resolve().get()).getFluidInTank(0);
            return this.getMatchingFluids().contains(fluid.getFluid()) && fluid.getAmount() >= 1000;
        }
        return false;
    }

    public static class Serializer
    implements IIngredientSerializer<FluidIngredient> {
        public static ResourceLocation NAME = new ResourceLocation("mob_grinding_utils", "fluid");

        public FluidIngredient parse(PacketBuffer buffer) {
            boolean buckets = buffer.readBoolean();
            int fluidCount = buffer.func_150792_a();
            ArrayList<Fluid> fluids = new ArrayList<Fluid>();
            for (int i = 0; i < fluidCount; ++i) {
                fluids.add((Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(buffer.func_218666_n())));
            }
            return new FluidIngredient(fluids, buckets);
        }

        public FluidIngredient parse(JsonObject json) {
            boolean advanced;
            boolean bl = advanced = json.has("advanced") && JSONUtils.func_151212_i((JsonObject)json, (String)"advanced");
            if (json.has("tag")) {
                ResourceLocation tagRes = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"tag"));
                ITag fluidTag = TagCollectionManager.func_242178_a().func_241837_c().func_199910_a(tagRes);
                if (fluidTag != null) {
                    return new FluidIngredient((ITag<Fluid>)fluidTag, advanced);
                }
                throw new JsonSyntaxException("invalid fluid tag: " + tagRes);
            }
            if (json.has("fluid")) {
                ResourceLocation fluidRes = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"fluid"));
                Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(fluidRes);
                if (fluid != null) {
                    return new FluidIngredient(fluid, advanced);
                }
            } else {
                throw new JsonSyntaxException("invalid FluidIngredient, must specify either a fluid, or a fluid tag.");
            }
            throw new JsonParseException("FluidIngredient needs either a fluid or a fluid tag.");
        }

        public void write(PacketBuffer buffer, FluidIngredient ingredient) {
            buffer.writeBoolean(ingredient.advanced.booleanValue());
            buffer.func_150787_b(ingredient.getMatchingFluids().size());
            ingredient.getMatchingFluids().forEach(fluid -> buffer.func_180714_a(fluid.getRegistryName().toString()));
        }
    }
}

