/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.blocks;

import java.util.List;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.AbstractFireBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.monster.IMob;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.WorldEntitySpawner;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockDreadfulDirt
extends Block {
    public BlockDreadfulDirt(AbstractBlock.Properties properties) {
        super(properties);
    }

    public boolean shouldCatchFire(World world, BlockPos pos) {
        return world.func_175710_j(pos) && (world.func_72820_D() < 13000L || world.func_72820_D() > 23000L);
    }

    public boolean shouldSpawnMob(World world, BlockPos pos) {
        return world.func_201696_r(pos.func_177984_a()) < 10;
    }

    public void func_220082_b(BlockState state, World world, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (this.shouldCatchFire(world, pos) || this.shouldSpawnMob(world, pos)) {
            world.func_205220_G_().func_205360_a(pos, (Object)this, MathHelper.func_76136_a((Random)this.RANDOM, (int)20, (int)60));
        }
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld world, BlockPos pos, BlockPos facingPos) {
        if (this.shouldCatchFire((World)world, pos) || this.shouldSpawnMob((World)world, pos)) {
            world.func_205220_G_().func_205360_a(pos, (Object)this, MathHelper.func_76136_a((Random)this.RANDOM, (int)20, (int)60));
        }
        return super.func_196271_a(stateIn, facing, facingState, world, pos, facingPos);
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (this.shouldCatchFire(world, pos) || this.shouldSpawnMob(world, pos)) {
            world.func_205220_G_().func_205360_a(pos, (Object)this, MathHelper.func_76136_a((Random)this.RANDOM, (int)20, (int)60));
        }
    }

    @Deprecated
    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
        AxisAlignedBB areaToCheck;
        int entityCount;
        if (this.shouldCatchFire((World)world, pos)) {
            BlockPos posUp = pos.func_177984_a();
            BlockState blockstate = AbstractFireBlock.func_235326_a_((IBlockReader)world, (BlockPos)posUp);
            if (world.func_180495_p(posUp).func_185904_a() == Material.field_151579_a && blockstate.func_196955_c((IWorldReader)world, posUp)) {
                world.func_180501_a(posUp, blockstate, 11);
            }
        }
        if (!this.shouldCatchFire((World)world, pos) && this.shouldSpawnMob((World)world, pos) && (entityCount = world.func_175647_a(MobEntity.class, areaToCheck = new AxisAlignedBB(pos).func_72314_b(5.0, 2.0, 5.0), entity -> entity != null && entity instanceof IMob).size()) < 8) {
            this.spawnMob(world, pos);
        }
    }

    public void spawnMob(ServerWorld world, BlockPos pos) {
        List spawns = world.func_226691_t_(pos).func_242433_b().func_242559_a(EntityClassification.MONSTER);
        if (!spawns.isEmpty()) {
            int indexSize = spawns.size();
            EntityType type = ((MobSpawnInfo.Spawners)spawns.get((int)this.RANDOM.nextInt((int)indexSize))).field_242588_c;
            if (type == null || !WorldEntitySpawner.func_209382_a((EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.func_209344_a((EntityType)type), (IWorldReader)world, (BlockPos)pos.func_177984_a(), (EntityType)type)) {
                return;
            }
            MobEntity entity = (MobEntity)type.func_200721_a((World)world);
            if (entity != null) {
                entity.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + 0.5);
                if (world.func_217394_a(entity.func_200600_R(), entity.func_174813_aQ(), EntityPredicates.field_94557_a).isEmpty() && world.func_226669_j_((Entity)entity)) {
                    entity.func_213386_a((IServerWorld)world, world.func_175649_E(pos), SpawnReason.NATURAL, null, null);
                    world.func_217376_c((Entity)entity);
                }
            }
        }
    }

    public boolean isFlammable(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return true;
    }

    public int getFlammability(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return 200;
    }

    public boolean isFireSource(BlockState state, IWorldReader world, BlockPos pos, Direction side) {
        return side == Direction.UP;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World world, BlockPos pos, Random rand) {
        for (int i = 0; i < 4; ++i) {
            double d0 = (float)pos.func_177958_n() + rand.nextFloat();
            double d1 = (float)pos.func_177956_o() + rand.nextFloat();
            double d2 = (float)pos.func_177952_p() + rand.nextFloat();
            double d3 = ((double)rand.nextFloat() - 0.5) * 0.5;
            double d4 = ((double)rand.nextFloat() - 0.5) * 0.5;
            double d5 = ((double)rand.nextFloat() - 0.5) * 0.5;
            world.func_195594_a((IParticleData)ParticleTypes.field_197599_J, d0, d1, d2, d3, d4, d5);
        }
    }
}

