/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.blocks;

import java.util.List;
import java.util.Random;
import mob_grinding_utils.MobGrindingUtils;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.FlowersFeature;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.WorldEntitySpawner;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IPlantable;

public class BlockDelightfulDirt
extends Block {
    public BlockDelightfulDirt(AbstractBlock.Properties properties) {
        super(properties);
    }

    public boolean shouldSnowCap(World world, BlockPos pos) {
        return world.func_175710_j(pos) && world.func_72820_D() >= 13000L && world.func_72820_D() <= 23000L;
    }

    public boolean shouldSpawnMob(World world, BlockPos pos) {
        return world.func_201696_r(pos.func_177984_a()) >= 10 && world.func_180495_p(pos.func_177984_a()).func_185904_a() == Material.field_151579_a;
    }

    public void func_220082_b(BlockState state, World world, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (this.shouldSnowCap(world, pos) || this.shouldSpawnMob(world, pos)) {
            world.func_205220_G_().func_205360_a(pos, (Object)this, MathHelper.func_76136_a((Random)this.RANDOM, (int)20, (int)60));
        }
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld world, BlockPos pos, BlockPos facingPos) {
        if (this.shouldSnowCap((World)world, pos) || this.shouldSpawnMob((World)world, pos)) {
            world.func_205220_G_().func_205360_a(pos, (Object)this, MathHelper.func_76136_a((Random)this.RANDOM, (int)20, (int)60));
        }
        return super.func_196271_a(stateIn, facing, facingState, world, pos, facingPos);
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (this.shouldSnowCap(world, pos) || this.shouldSpawnMob(world, pos)) {
            world.func_205220_G_().func_205360_a(pos, (Object)this, MathHelper.func_76136_a((Random)this.RANDOM, (int)20, (int)60));
        }
    }

    @Deprecated
    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
        if (this.shouldSnowCap((World)world, pos)) {
            BlockPos posUp = pos.func_177984_a();
            BlockState blockstate = Blocks.field_150433_aE.func_176223_P();
            if (world.func_180495_p(posUp).func_185904_a() == Material.field_151579_a && blockstate.func_196955_c((IWorldReader)world, posUp)) {
                world.func_180501_a(posUp, blockstate, 11);
            }
        }
        if (!this.shouldSnowCap((World)world, pos) && this.shouldSpawnMob((World)world, pos)) {
            AxisAlignedBB areaToCheck = new AxisAlignedBB(pos).func_72314_b(5.0, 2.0, 5.0);
            int entityCount = world.func_175647_a(MobEntity.class, areaToCheck, entity -> entity != null && entity.func_200600_R().func_220339_d() == EntityClassification.CREATURE).size();
            if (entityCount < 8) {
                this.spawnMob(world, pos);
            }
            if (world.func_82737_E() % 20L == 0L) {
                BlockPos posUp = pos.func_177984_a();
                BlockState blockstate = Blocks.field_150349_c.func_176223_P();
                if (world.func_180495_p(posUp).func_185904_a() == Material.field_151579_a) {
                    if (rand.nextInt(8) == 0) {
                        List list = world.func_226691_t_(posUp).func_242440_e().func_242496_b();
                        if (list.isEmpty()) {
                            return;
                        }
                        ConfiguredFeature configuredfeature = (ConfiguredFeature)list.get(0);
                        FlowersFeature flowersfeature = (FlowersFeature)configuredfeature.field_222737_a;
                        blockstate = flowersfeature.func_225562_b_(rand, posUp, configuredfeature.field_222738_b);
                    }
                    if (blockstate.func_196955_c((IWorldReader)world, posUp)) {
                        world.func_180501_a(posUp, blockstate, 3);
                    }
                }
            }
        }
    }

    public void spawnMob(ServerWorld world, BlockPos pos) {
        List spawns = world.func_226691_t_(pos).func_242433_b().func_242559_a(EntityClassification.CREATURE);
        if (!spawns.isEmpty()) {
            int indexSize = spawns.size();
            EntityType type = ((MobSpawnInfo.Spawners)spawns.get((int)this.RANDOM.nextInt((int)indexSize))).field_242588_c;
            if (type == null || !WorldEntitySpawner.func_209382_a((EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.func_209344_a((EntityType)type), (IWorldReader)world, (BlockPos)pos.func_177984_a(), (EntityType)type)) {
                return;
            }
            MobEntity entity = (MobEntity)type.func_200721_a((World)world);
            if (entity != null) {
                entity.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + 0.5);
                if (world.func_217394_a(entity.func_200600_R(), entity.func_174813_aQ(), EntityPredicates.field_94557_a).isEmpty() && world.func_226669_j_((Entity)entity)) {
                    entity.func_213386_a((IServerWorld)world, world.func_175649_E(pos), SpawnReason.NATURAL, null, null);
                    world.func_217376_c((Entity)entity);
                }
            }
        }
    }

    public boolean canSustainPlant(BlockState state, IBlockReader world, BlockPos pos, Direction facing, IPlantable plantable) {
        return true;
    }

    public boolean isFlammable(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return true;
    }

    public int getFlammability(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return 200;
    }

    public boolean isFireSource(BlockState state, IWorldReader world, BlockPos pos, Direction side) {
        return side == Direction.UP;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World world, BlockPos pos, Random rand) {
        if (world.func_82737_E() % 3L == 0L && world.func_180495_p(pos.func_177984_a()).func_185904_a() == Material.field_151579_a) {
            for (int i = 0; i < 4; ++i) {
                double d0 = pos.func_177958_n();
                double d1 = (double)pos.func_177956_o() + 1.0;
                double d2 = pos.func_177952_p();
                double d3 = ((double)rand.nextFloat() - 0.5) * 0.5;
                double d4 = ((double)rand.nextFloat() - 0.5) * 0.5;
                double d5 = ((double)rand.nextFloat() - 0.5) * 0.5;
                MobGrindingUtils.NETPROXY.spawnGlitterParticles(d0 + d3, d1 + d4, d2 + d5, 0.0, 0.0, 0.0);
            }
        }
    }
}

