/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mob_grinding_utils.ModBlocks;
import mob_grinding_utils.ModColourManager;
import mob_grinding_utils.ModContainers;
import mob_grinding_utils.ModItems;
import mob_grinding_utils.ServerResourceReloader;
import mob_grinding_utils.blocks.BlockSpikes;
import mob_grinding_utils.client.render.TileEntityAbsorptionRenderer;
import mob_grinding_utils.client.render.TileEntityFanRenderer;
import mob_grinding_utils.client.render.TileEntityMGUSpawnerRenderer;
import mob_grinding_utils.client.render.TileEntitySawRenderer;
import mob_grinding_utils.client.render.TileEntityTankRenderer;
import mob_grinding_utils.client.render.TileEntityXPSolidifierRenderer;
import mob_grinding_utils.datagen.Generator;
import mob_grinding_utils.events.BossBarHidingEvent;
import mob_grinding_utils.events.ChickenFuseEvent;
import mob_grinding_utils.events.EntityHeadDropEvent;
import mob_grinding_utils.events.EntityInteractionEvent;
import mob_grinding_utils.events.FillXPBottleEvent;
import mob_grinding_utils.events.FluidTextureStitchEvent;
import mob_grinding_utils.events.GlobalDragonSoundEvent;
import mob_grinding_utils.events.GlobalWitherSoundEvent;
import mob_grinding_utils.events.LocalDragonSoundEvent;
import mob_grinding_utils.events.LocalWitherSoundEvent;
import mob_grinding_utils.events.MGUEndermanInhibitEvent;
import mob_grinding_utils.events.MGUZombieReinforcementEvent;
import mob_grinding_utils.events.RenderChickenSwell;
import mob_grinding_utils.fakeplayer.MGUFakePlayer;
import mob_grinding_utils.inventory.client.GuiAbsorptionHopper;
import mob_grinding_utils.inventory.client.GuiFan;
import mob_grinding_utils.inventory.client.GuiMGUSpawner;
import mob_grinding_utils.inventory.client.GuiSaw;
import mob_grinding_utils.inventory.client.GuiXPSolidifier;
import mob_grinding_utils.network.MGUNetProxyClient;
import mob_grinding_utils.network.MGUNetProxyCommon;
import mob_grinding_utils.network.MGUNetwork;
import mob_grinding_utils.network.MessageFlagSync;
import mob_grinding_utils.recipe.ChickenFeedRecipe;
import mob_grinding_utils.recipe.FluidIngredient;
import mob_grinding_utils.recipe.SolidifyRecipe;
import net.minecraft.block.Block;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.ParticleType;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@Mod(value="mob_grinding_utils")
public class MobGrindingUtils {
    public static SimpleChannel NETWORK_WRAPPER;
    public static DamageSource SPIKE_DAMAGE;
    public static final ITag.INamedTag<Fluid> EXPERIENCE;
    public static final ITag.INamedTag<Fluid> XPJUICE;
    public static final ITag.INamedTag<EntityType<?>> NOSWAB;
    public static final DeferredRegister<ParticleType<?>> PARTICLES;
    public static final DeferredRegister<IRecipeSerializer<?>> RECIPES;
    public static final RegistryObject<BasicParticleType> PARTICLE_FLUID_XP;
    public static final RegistryObject<IRecipeSerializer<?>> CHICKEN_FEED;
    public static final List<SolidifyRecipe> SOLIDIFIER_RECIPES;
    public static final RegistryObject<IRecipeSerializer<?>> SOLIDIFIER_RECIPE;
    public static final IRecipeType<SolidifyRecipe> SOLIDIFIER_TYPE;
    public static final ItemGroup TAB;
    public static MGUNetProxyCommon NETPROXY;

    public MobGrindingUtils() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModBlocks.init(modBus);
        ModItems.init(modBus);
        ModContainers.init(modBus);
        PARTICLES.register(modBus);
        RECIPES.register(modBus);
        modBus.addListener(this::setup);
        modBus.addListener(this::doClientStuff);
        modBus.addListener(Generator::gatherData);
        NETPROXY = (MGUNetProxyCommon)DistExecutor.safeRunForDist(() -> MGUNetProxyClient::new, () -> MGUNetProxyCommon::new);
    }

    public void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> CraftingHelper.register((ResourceLocation)FluidIngredient.Serializer.NAME, (IIngredientSerializer)FluidIngredient.SERIALIZER));
        SPIKE_DAMAGE = new DamageSource("spikes").func_76348_h();
        NETWORK_WRAPPER = MGUNetwork.getNetworkChannel();
        MinecraftForge.EVENT_BUS.addListener(BlockSpikes::dropXP);
        MinecraftForge.EVENT_BUS.register((Object)new EntityInteractionEvent());
        MinecraftForge.EVENT_BUS.register((Object)new ChickenFuseEvent());
        MinecraftForge.EVENT_BUS.register((Object)new LocalWitherSoundEvent());
        MinecraftForge.EVENT_BUS.register((Object)new LocalDragonSoundEvent());
        MinecraftForge.EVENT_BUS.register((Object)new EntityHeadDropEvent());
        MinecraftForge.EVENT_BUS.register((Object)new MGUZombieReinforcementEvent());
        MinecraftForge.EVENT_BUS.register((Object)new FillXPBottleEvent());
        MinecraftForge.EVENT_BUS.register((Object)new MGUEndermanInhibitEvent());
        MinecraftForge.EVENT_BUS.addListener(this::playerConnected);
        MinecraftForge.EVENT_BUS.addListener(this::changedDimension);
        MinecraftForge.EVENT_BUS.addListener(this::playerRespawn);
        MinecraftForge.EVENT_BUS.addListener(this::cloneEvent);
        MinecraftForge.EVENT_BUS.addListener(this::serverReloadListener);
        MinecraftForge.EVENT_BUS.addListener(this::clientRecipeReload);
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new FluidTextureStitchEvent());
        MinecraftForge.EVENT_BUS.register((Object)new RenderChickenSwell());
        MinecraftForge.EVENT_BUS.register((Object)new GlobalWitherSoundEvent());
        MinecraftForge.EVENT_BUS.register((Object)new GlobalDragonSoundEvent());
        MinecraftForge.EVENT_BUS.register((Object)new BossBarHidingEvent());
        MinecraftForge.EVENT_BUS.addListener(this::worldUnload);
        ClientRegistry.bindTileEntityRenderer(ModBlocks.FAN.getTileEntityType(), TileEntityFanRenderer::new);
        ClientRegistry.bindTileEntityRenderer(ModBlocks.SAW.getTileEntityType(), TileEntitySawRenderer::new);
        ClientRegistry.bindTileEntityRenderer(ModBlocks.ABSORPTION_HOPPER.getTileEntityType(), TileEntityAbsorptionRenderer::new);
        ClientRegistry.bindTileEntityRenderer(ModBlocks.TANK.getTileEntityType(), TileEntityTankRenderer::new);
        ClientRegistry.bindTileEntityRenderer(ModBlocks.TANK_SINK.getTileEntityType(), TileEntityTankRenderer::new);
        ClientRegistry.bindTileEntityRenderer(ModBlocks.JUMBO_TANK.getTileEntityType(), TileEntityTankRenderer::new);
        ClientRegistry.bindTileEntityRenderer(ModBlocks.XPSOLIDIFIER.getTileEntityType(), TileEntityXPSolidifierRenderer::new);
        ClientRegistry.bindTileEntityRenderer(ModBlocks.ENTITY_SPAWNER.getTileEntityType(), TileEntityMGUSpawnerRenderer::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)ModContainers.ABSORPTION_HOPPER.get()), GuiAbsorptionHopper::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)ModContainers.SOLIDIFIER.get()), GuiXPSolidifier::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)ModContainers.FAN.get()), GuiFan::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)ModContainers.SAW.get()), GuiSaw::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)ModContainers.ENTITY_SPAWNER.get()), GuiMGUSpawner::new);
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.TANK.getBlock(), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.TANK_SINK.getBlock(), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.XP_TAP.getBlock(), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.ENDER_INHIBITOR_ON.getBlock(), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.ENDER_INHIBITOR_OFF.getBlock(), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.SAW.getBlock(), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.SPIKES.getBlock(), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.ABSORPTION_HOPPER.getBlock(), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.TINTED_GLASS.getBlock(), (RenderType)RenderType.func_228645_f_());
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.JUMBO_TANK.getBlock(), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.DREADFUL_DIRT.getBlock(), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.DELIGHTFUL_DIRT.getBlock(), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.XPSOLIDIFIER.getBlock(), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.SOLID_XP_BLOCK.getBlock(), (RenderType)RenderType.func_228645_f_());
        RenderTypeLookup.setRenderLayer((Fluid)((Fluid)ModBlocks.FLUID_XP_FLOWING.get()), (RenderType)RenderType.func_228645_f_());
        RenderTypeLookup.setRenderLayer((Fluid)((Fluid)ModBlocks.FLUID_XP.get()), (RenderType)RenderType.func_228645_f_());
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.ENTITY_SPAWNER.getBlock(), (RenderType)RenderType.func_228643_e_());
        ModColourManager.registerColourHandlers();
    }

    private void serverReloadListener(AddReloadListenerEvent event) {
        event.addListener((IFutureReloadListener)new ServerResourceReloader(event.getDataPackRegistries()));
    }

    private void clientRecipeReload(RecipesUpdatedEvent event) {
        SOLIDIFIER_RECIPES.clear();
        SOLIDIFIER_RECIPES.addAll(event.getRecipeManager().func_241447_a_(SOLIDIFIER_TYPE));
    }

    private void playerConnected(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getPlayer() instanceof ServerPlayerEntity) {
            this.sendPersistentData((ServerPlayerEntity)event.getPlayer());
        }
    }

    private void changedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (event.getPlayer() instanceof ServerPlayerEntity) {
            this.sendPersistentData((ServerPlayerEntity)event.getPlayer());
        }
    }

    private void playerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (event.getPlayer() instanceof ServerPlayerEntity) {
            this.sendPersistentData((ServerPlayerEntity)event.getPlayer());
        }
    }

    private void sendPersistentData(ServerPlayerEntity playerEntity) {
        CompoundNBT nbt = playerEntity.getPersistentData();
        if (nbt.func_74764_b("MGU_WitherMuffle") || nbt.func_74764_b("MGU_DragonMuffle")) {
            NETWORK_WRAPPER.send(PacketDistributor.PLAYER.with(() -> playerEntity), (Object)new MessageFlagSync(nbt.func_74767_n("MGU_WitherMuffle"), nbt.func_74767_n("MGU_DragonMuffle")));
        }
    }

    private void cloneEvent(PlayerEvent.Clone event) {
        CompoundNBT nbt = event.getOriginal().getPersistentData();
        if (nbt.func_74764_b("MGU_WitherMuffle") || nbt.func_74764_b("MGU_DragonMuffle")) {
            CompoundNBT newNBT = event.getPlayer().getPersistentData();
            newNBT.func_74757_a("MGU_WitherMuffle", nbt.func_74767_n("MGU_WitherMuffle"));
            newNBT.func_74757_a("MGU_DragonMuffle", nbt.func_74767_n("MGU_DragonMuffle"));
        }
    }

    private void worldUnload(WorldEvent.Unload event) {
        if (event.getWorld() instanceof ServerWorld) {
            MGUFakePlayer.unload(event.getWorld());
        }
    }

    static {
        EXPERIENCE = FluidTags.func_206956_a((String)new ResourceLocation("forge", "experience").toString());
        XPJUICE = FluidTags.func_206956_a((String)new ResourceLocation("forge", "xpjuice").toString());
        NOSWAB = EntityTypeTags.createOptional((ResourceLocation)new ResourceLocation("mob_grinding_utils", "noswab"));
        PARTICLES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PARTICLE_TYPES, (String)"mob_grinding_utils");
        RECIPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"mob_grinding_utils");
        PARTICLE_FLUID_XP = PARTICLES.register("fluid_xp_particles", () -> new BasicParticleType(true));
        CHICKEN_FEED = RECIPES.register("chicken_feed", ChickenFeedRecipe.Serializer::new);
        SOLIDIFIER_RECIPES = new ArrayList<SolidifyRecipe>();
        SOLIDIFIER_RECIPE = RECIPES.register("solidify", SolidifyRecipe.Serializer::new);
        SOLIDIFIER_TYPE = IRecipeType.func_222147_a((String)"mob_grinding_utils:solidify");
        TAB = new ItemGroup("mob_grinding_utils"){

            @Nonnull
            public ItemStack func_78016_d() {
                return new ItemStack((IItemProvider)ModBlocks.SPIKES.getItem());
            }
        };
    }
}

