/*
 * Decompiled with CFR 0.152.
 */
package twistedgate.immersiveposts.enums;

import blusunrize.immersiveengineering.common.blocks.IEBlocks;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.material.PushReaction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ToolType;
import twistedgate.immersiveposts.api.posts.IPostMaterial;
import twistedgate.immersiveposts.common.ExternalModContent;
import twistedgate.immersiveposts.common.IPOContent;

public enum EnumPostMaterial implements IPostMaterial
{
    WOOD("wood", PostBlockProperties.WOOD, () -> ExternalModContent.IE_TREATED_FENCE.get()),
    ALUMINIUM("aluminium", PostBlockProperties.METAL, () -> ExternalModContent.IE_ALUMINIUM_FENCE.get()),
    STEEL("steel", PostBlockProperties.METAL, () -> ExternalModContent.IE_STEEL_FENCE.get()),
    NETHERBRICK("nether", PostBlockProperties.STONE, Blocks.field_150386_bk),
    IRON("iron", PostBlockProperties.METAL, () -> IPOContent.Blocks.Fences.IRON.get()),
    GOLD("gold", PostBlockProperties.METAL, () -> IPOContent.Blocks.Fences.GOLD.get()),
    COPPER("copper", PostBlockProperties.METAL, () -> IPOContent.Blocks.Fences.COPPER.get()),
    LEAD("lead", PostBlockProperties.METAL, () -> IPOContent.Blocks.Fences.LEAD.get()),
    SILVER("silver", PostBlockProperties.METAL, () -> IPOContent.Blocks.Fences.SILVER.get()),
    NICKEL("nickel", PostBlockProperties.METAL, () -> IPOContent.Blocks.Fences.NICKEL.get()),
    CONSTANTAN("constantan", PostBlockProperties.METAL, () -> IPOContent.Blocks.Fences.CONSTANTAN.get()),
    ELECTRUM("electrum", PostBlockProperties.METAL, () -> IPOContent.Blocks.Fences.ELECTRUM.get()),
    URANIUM("uranium", PostBlockProperties.access$000().func_235838_a_(s -> 8), () -> IPOContent.Blocks.Fences.URANIUM.get()),
    CONCRETE("concrete", PostBlockProperties.STONE, () -> (SlabBlock)IEBlocks.toSlab.get(IEBlocks.StoneDecoration.concrete)),
    CONCRETE_LEADED("leadedconcrete", PostBlockProperties.STONE, () -> (SlabBlock)IEBlocks.toSlab.get(IEBlocks.StoneDecoration.concreteLeaded));

    private boolean isFence;
    private String name;
    private Block sourceBlock;
    private Supplier<Block> sourceBlockSupplier;
    private AbstractBlock.Properties properties;
    private ResourceLocation texture;

    private EnumPostMaterial(String name, AbstractBlock.Properties properties, Block sourceBlock) {
        this(name, properties, null, sourceBlock);
    }

    private EnumPostMaterial(String name, AbstractBlock.Properties properties, Supplier<Block> sourceBlockSupplier) {
        this(name, properties, null, sourceBlockSupplier);
    }

    private EnumPostMaterial(String name, AbstractBlock.Properties properties, ResourceLocation texture, Block sourceBlock) {
        this.name = name;
        this.properties = properties;
        this.sourceBlock = sourceBlock;
        this.isFence = sourceBlock instanceof FenceBlock;
    }

    private EnumPostMaterial(String name, AbstractBlock.Properties properties, ResourceLocation texture, Supplier<Block> sourceBlockSupplier) {
        this.name = name;
        this.properties = properties;
        this.texture = texture;
        this.sourceBlockSupplier = sourceBlockSupplier;
    }

    @Override
    public ItemStack getItemStack() {
        Block block = this.getSourceBlock();
        return block == null ? ItemStack.field_190927_a : new ItemStack((IItemProvider)block);
    }

    @Override
    public ResourceLocation getTexture() {
        if (this.texture == null) {
            return new ResourceLocation("immersiveposts", "block/posts/post_" + this.getName());
        }
        return this.texture;
    }

    @Override
    public Block getSourceBlock() {
        if (this.sourceBlock == null) {
            this.sourceBlock = this.sourceBlockSupplier.get();
            this.isFence = this.sourceBlock != null && this.sourceBlock instanceof FenceBlock;
        }
        return this.sourceBlock;
    }

    @Override
    public boolean isFence() {
        return this.isFence;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getBlockName() {
        return this.name + "post";
    }

    @Override
    public AbstractBlock.Properties getBlockProperties() {
        return this.properties;
    }

    public static class PostBlockProperties {
        private static final Material WOOD_LIKE = PostBlockProperties.material(MaterialColor.field_151663_o, false, true, true, true, false, false, PushReaction.BLOCK);
        private static final Material STONE_LIKE = PostBlockProperties.material(MaterialColor.field_151665_m, false, true, true, true, false, false, PushReaction.BLOCK);
        private static final Material METAL_LIKE = PostBlockProperties.material(MaterialColor.field_151668_h, false, true, true, true, false, false, PushReaction.BLOCK);
        public static final AbstractBlock.Properties WOOD = AbstractBlock.Properties.func_200945_a((Material)WOOD_LIKE).func_200947_a(SoundType.field_185848_a).harvestTool(ToolType.AXE).func_200948_a(2.0f, 5.0f).func_226896_b_().func_235847_c_((s, r, p) -> false);
        public static final AbstractBlock.Properties STONE = AbstractBlock.Properties.func_200945_a((Material)STONE_LIKE).func_200947_a(SoundType.field_185851_d).func_235861_h_().harvestTool(ToolType.PICKAXE).func_200948_a(1.5f, 6.0f).func_226896_b_().func_235847_c_((s, r, p) -> false);
        public static final AbstractBlock.Properties METAL = PostBlockProperties.metal();

        private static Material material(MaterialColor color, boolean isLiquid, boolean isSolid, boolean blocksMovement, boolean isOpaque, boolean flammable, boolean replaceable, PushReaction pushReaction) {
            return new Material(color, isLiquid, isSolid, blocksMovement, isOpaque, flammable, replaceable, pushReaction);
        }

        private static AbstractBlock.Properties metal() {
            return AbstractBlock.Properties.func_200945_a((Material)METAL_LIKE).func_200947_a(SoundType.field_185852_e).func_235861_h_().harvestTool(ToolType.PICKAXE).func_200948_a(3.0f, 15.0f).func_226896_b_().func_235847_c_((s, r, p) -> false);
        }

        static /* synthetic */ AbstractBlock.Properties access$000() {
            return PostBlockProperties.metal();
        }
    }
}

