/*
 * Decompiled with CFR 0.152.
 */
package twistedgate.immersiveposts.common;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.FenceBlock;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import twistedgate.immersiveposts.ImmersivePosts;
import twistedgate.immersiveposts.api.posts.IPostMaterial;
import twistedgate.immersiveposts.common.blocks.HorizontalTrussBlock;
import twistedgate.immersiveposts.common.blocks.MetalFenceBlock;
import twistedgate.immersiveposts.common.blocks.PostBaseBlock;
import twistedgate.immersiveposts.common.blocks.PostBlock;
import twistedgate.immersiveposts.common.items.IPOItemBase;
import twistedgate.immersiveposts.common.tileentity.PostBaseTileEntity;
import twistedgate.immersiveposts.enums.EnumPostMaterial;

@Mod.EventBusSubscriber(modid="immersiveposts", bus=Mod.EventBusSubscriber.Bus.MOD)
public class IPOContent {
    public static final Logger log = LogManager.getLogger((String)"immersiveposts/Stuff");
    private static final DeferredRegister<Block> BLOCK_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"immersiveposts");
    private static final DeferredRegister<Item> ITEM_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"immersiveposts");
    public static TileEntityType<PostBaseTileEntity> TE_POSTBASE;

    public static final void addRegistersToEventBus(IEventBus eventBus) {
        BLOCK_REGISTER.register(eventBus);
        ITEM_REGISTER.register(eventBus);
    }

    protected static final <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> constructor) {
        return BLOCK_REGISTER.register(name, constructor);
    }

    protected static final RegistryObject<PostBlock> registerPostBlock(EnumPostMaterial material) {
        return BLOCK_REGISTER.register(material.getBlockName(), () -> new PostBlock(material));
    }

    protected static final RegistryObject<HorizontalTrussBlock> registerTrussBlock(EnumPostMaterial material) {
        return BLOCK_REGISTER.register(material.getBlockName() + "_truss", () -> new HorizontalTrussBlock(material));
    }

    protected static final RegistryObject<FenceBlock> registerMetalFence(String name) {
        name = "fence_" + name;
        RegistryObject block = BLOCK_REGISTER.register(name, MetalFenceBlock::new);
        ITEM_REGISTER.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties().func_200916_a(ImmersivePosts.creativeTab)));
        Blocks.Fences.ALL_FENCES.add((RegistryObject<FenceBlock>)block);
        return block;
    }

    protected static final <T extends Item> RegistryObject<T> registerItem(String name, Supplier<T> constructor) {
        return ITEM_REGISTER.register(name, constructor);
    }

    public static final void populate() {
        Blocks.forceClassLoad();
        Blocks.Fences.forceClassLoad();
        Blocks.Posts.forceClassLoad();
        Blocks.HorizontalTruss.forceClassLoad();
        Items.forceClassLoad();
    }

    @SubscribeEvent
    public static void registerTileEntities(RegistryEvent.Register<TileEntityType<?>> event) {
        try {
            TE_POSTBASE = IPOContent.create("postbase", PostBaseTileEntity::new, (Block)Blocks.POST_BASE.get());
            event.getRegistry().register(TE_POSTBASE);
        }
        catch (Throwable e) {
            log.error("Failed to register postbase tileentity. {}", (Object)e.getMessage());
            throw e;
        }
    }

    private static <T extends TileEntity> TileEntityType<T> create(String name, Supplier<T> factory, Block ... validBlocks) {
        TileEntityType te = TileEntityType.Builder.func_223042_a(factory, (Block[])validBlocks).func_206865_a(null);
        te.setRegistryName(new ResourceLocation("immersiveposts", name));
        return te;
    }

    public static class Items {
        public static final RegistryObject<Item> ROD_GOLD = IPOContent.registerItem("stick_gold", IPOItemBase::new);
        public static final RegistryObject<Item> ROD_COPPER = IPOContent.registerItem("stick_copper", IPOItemBase::new);
        public static final RegistryObject<Item> ROD_LEAD = IPOContent.registerItem("stick_lead", IPOItemBase::new);
        public static final RegistryObject<Item> ROD_SILVER = IPOContent.registerItem("stick_silver", IPOItemBase::new);
        public static final RegistryObject<Item> ROD_NICKEL = IPOContent.registerItem("stick_nickel", IPOItemBase::new);
        public static final RegistryObject<Item> ROD_CONSTANTAN = IPOContent.registerItem("stick_constantan", IPOItemBase::new);
        public static final RegistryObject<Item> ROD_ELECTRUM = IPOContent.registerItem("stick_electrum", IPOItemBase::new);
        public static final RegistryObject<Item> ROD_URANIUM = IPOContent.registerItem("stick_uranium", IPOItemBase::new);

        private static void forceClassLoad() {
        }
    }

    public static class Blocks {
        public static final RegistryObject<PostBaseBlock> POST_BASE = IPOContent.registerBlock("postbase", PostBaseBlock::new);

        private static void forceClassLoad() {
        }

        static {
            IPOContent.registerItem("postbase", () -> new PostBaseBlock.ItemPostBase((Block)POST_BASE.get()));
        }

        public static class HorizontalTruss {
            static EnumMap<EnumPostMaterial, RegistryObject<HorizontalTrussBlock>> ALL = (EnumMap)Util.func_200696_a(new EnumMap(EnumPostMaterial.class), map -> {
                for (EnumPostMaterial material : EnumPostMaterial.values()) {
                    map.put(material, IPOContent.registerTrussBlock(material));
                }
            });

            public static HorizontalTrussBlock get(@Nonnull IPostMaterial material) {
                if (!ALL.containsKey(material)) {
                    return null;
                }
                return (HorizontalTrussBlock)ALL.get(material).get();
            }

            private static void forceClassLoad() {
            }
        }

        public static class Posts {
            static final EnumMap<EnumPostMaterial, RegistryObject<PostBlock>> ALL = (EnumMap)Util.func_200696_a(new EnumMap(EnumPostMaterial.class), map -> {
                for (EnumPostMaterial material : EnumPostMaterial.values()) {
                    map.put(material, IPOContent.registerPostBlock(material));
                }
            });

            public static PostBlock get(@Nonnull IPostMaterial material) {
                if (!ALL.containsKey(material)) {
                    return null;
                }
                return (PostBlock)ALL.get(material).get();
            }

            private static void forceClassLoad() {
            }
        }

        public static class Fences {
            public static final List<RegistryObject<FenceBlock>> ALL_FENCES = new ArrayList<RegistryObject<FenceBlock>>();
            public static final RegistryObject<FenceBlock> IRON = IPOContent.registerMetalFence("iron");
            public static final RegistryObject<FenceBlock> GOLD = IPOContent.registerMetalFence("gold");
            public static final RegistryObject<FenceBlock> COPPER = IPOContent.registerMetalFence("copper");
            public static final RegistryObject<FenceBlock> LEAD = IPOContent.registerMetalFence("lead");
            public static final RegistryObject<FenceBlock> SILVER = IPOContent.registerMetalFence("silver");
            public static final RegistryObject<FenceBlock> NICKEL = IPOContent.registerMetalFence("nickel");
            public static final RegistryObject<FenceBlock> CONSTANTAN = IPOContent.registerMetalFence("constantan");
            public static final RegistryObject<FenceBlock> ELECTRUM = IPOContent.registerMetalFence("electrum");
            public static final RegistryObject<FenceBlock> URANIUM = IPOContent.registerMetalFence("uranium");

            private static void forceClassLoad() {
            }
        }
    }
}

