/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.ironjetpacks.util;

import com.blakebr0.cucumber.helper.NBTHelper;
import com.blakebr0.ironjetpacks.handler.InputHandler;
import com.blakebr0.ironjetpacks.item.JetpackItem;
import com.blakebr0.ironjetpacks.registry.Jetpack;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;

public final class JetpackUtils {
    private static final IEnergyStorage EMPTY_ENERGY_STORAGE = new EnergyStorage(0);

    public static boolean isFlying(PlayerEntity player) {
        Item item;
        ItemStack stack = player.func_184582_a(EquipmentSlotType.CHEST);
        if (!stack.func_190926_b() && (item = stack.func_77973_b()) instanceof JetpackItem) {
            JetpackItem jetpack = (JetpackItem)item;
            if (JetpackUtils.isEngineOn(stack) && (JetpackUtils.getEnergyStorage(stack).getEnergyStored() > 0 || player.func_184812_l_() || jetpack.getJetpack().creative)) {
                if (JetpackUtils.isHovering(stack)) {
                    return !player.func_233570_aj_();
                }
                return InputHandler.isHoldingUp(player);
            }
        }
        return false;
    }

    public static IEnergyStorage getEnergyStorage(ItemStack stack) {
        if (CapabilityEnergy.ENERGY == null) {
            return EMPTY_ENERGY_STORAGE;
        }
        return (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY).orElse((Object)EMPTY_ENERGY_STORAGE);
    }

    public static boolean isEngineOn(ItemStack stack) {
        return NBTHelper.getBoolean((ItemStack)stack, (String)"Engine");
    }

    public static boolean toggleEngine(ItemStack stack) {
        boolean current = NBTHelper.getBoolean((ItemStack)stack, (String)"Engine");
        NBTHelper.flipBoolean((ItemStack)stack, (String)"Engine");
        return !current;
    }

    public static boolean isHovering(ItemStack stack) {
        return NBTHelper.getBoolean((ItemStack)stack, (String)"Hover");
    }

    public static boolean toggleHover(ItemStack stack) {
        boolean current = NBTHelper.getBoolean((ItemStack)stack, (String)"Hover");
        NBTHelper.flipBoolean((ItemStack)stack, (String)"Hover");
        return !current;
    }

    public static double getThrottle(ItemStack stack) {
        if (!NBTHelper.hasKey((ItemStack)stack, (String)"Throttle")) {
            NBTHelper.setDouble((ItemStack)stack, (String)"Throttle", (double)1.0);
        }
        return NBTHelper.getDouble((ItemStack)stack, (String)"Throttle");
    }

    public static double incrementThrottle(ItemStack stack) {
        double throttle = JetpackUtils.getThrottle(stack);
        if (throttle < 1.0) {
            throttle = Math.min(throttle + 0.2, 1.0);
            NBTHelper.setDouble((ItemStack)stack, (String)"Throttle", (double)throttle);
        }
        return throttle;
    }

    public static double decrementThrottle(ItemStack stack) {
        double throttle = JetpackUtils.getThrottle(stack);
        if (throttle > 0.2) {
            throttle = Math.max(throttle - 0.2, 0.2);
            NBTHelper.setDouble((ItemStack)stack, (String)"Throttle", (double)throttle);
        }
        return throttle;
    }

    public static IArmorMaterial makeArmorMaterial(final Jetpack jetpack) {
        return new IArmorMaterial(){

            public int func_200896_a(EquipmentSlotType slot) {
                return 0;
            }

            public int func_200902_b(EquipmentSlotType slot) {
                return jetpack.armorPoints;
            }

            public int func_200900_a() {
                return jetpack.enchantablilty;
            }

            public SoundEvent func_200899_b() {
                return SoundEvents.field_187719_p;
            }

            public Ingredient func_200898_c() {
                return Ingredient.field_193370_a;
            }

            public String func_200897_d() {
                return "ironjetpacks:jetpack";
            }

            public float func_200901_e() {
                return jetpack.toughness;
            }

            public float func_230304_f_() {
                return jetpack.knockbackResistance;
            }
        };
    }
}

