/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.ironjetpacks.registry;

import com.blakebr0.ironjetpacks.IronJetpacks;
import com.blakebr0.ironjetpacks.item.ComponentItem;
import com.blakebr0.ironjetpacks.item.JetpackItem;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.minecraft.item.Item;
import net.minecraft.item.Rarity;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;

public class Jetpack {
    public String name;
    public String displayName;
    public int tier;
    public int color;
    public int armorPoints;
    public int enchantablilty;
    public String craftingMaterialString;
    private Ingredient craftingMaterial;
    public JetpackItem item;
    public boolean creative = false;
    public boolean disabled = false;
    public Rarity rarity = Rarity.COMMON;
    public float toughness;
    public float knockbackResistance;
    public ComponentItem cell;
    public ComponentItem thruster;
    public ComponentItem capacitor;
    public int capacity;
    public int usage;
    public double speedVert;
    public double accelVert;
    public double speedSide;
    public double speedHover;
    public double speedHoverSlow;
    public double sprintSpeed;
    public double sprintSpeedVert;
    public double sprintFuel;

    public Jetpack(String name, int tier, int color, int armorPoints, int enchantability, String craftingMaterialString, float toughness, float knockbackResistance) {
        this.name = name;
        this.displayName = this.makeDisplayName();
        this.tier = tier;
        this.color = color;
        this.armorPoints = armorPoints;
        this.enchantablilty = enchantability;
        this.craftingMaterialString = craftingMaterialString;
        this.item = new JetpackItem(this, p -> p.func_200916_a(IronJetpacks.ITEM_GROUP));
        this.toughness = toughness;
        this.knockbackResistance = knockbackResistance;
    }

    public Jetpack setStats(int capacity, int usage, double speedVert, double accelVert, double speedSide, double speedHover, double speedHoverSlow, double sprintSpeed, double sprintSpeedVert, double sprintFuel) {
        this.capacity = capacity;
        this.usage = usage;
        this.speedVert = speedVert;
        this.accelVert = accelVert;
        this.speedSide = speedSide;
        this.speedHover = speedHover;
        this.speedHoverSlow = speedHoverSlow;
        this.sprintSpeed = sprintSpeed;
        this.sprintSpeedVert = sprintSpeedVert;
        this.sprintFuel = sprintFuel;
        return this;
    }

    public Jetpack setCreative() {
        this.creative = true;
        this.tier = -1;
        this.rarity = Rarity.EPIC;
        return this;
    }

    public Jetpack setCreative(boolean set) {
        if (set) {
            this.setCreative();
        }
        return this;
    }

    public Jetpack setDisabled() {
        this.disabled = true;
        return this;
    }

    public Jetpack setDisabled(boolean set) {
        if (set) {
            this.setDisabled();
        }
        return this;
    }

    public Jetpack setRarity(Rarity rarity) {
        this.rarity = rarity;
        return this;
    }

    public Jetpack setCellItem(ComponentItem item) {
        this.cell = item;
        return this;
    }

    public Jetpack setThrusterItem(ComponentItem item) {
        this.thruster = item;
        return this;
    }

    public Jetpack setCapacitorItem(ComponentItem item) {
        this.capacitor = item;
        return this;
    }

    public int getTier() {
        return this.tier;
    }

    public Ingredient getCraftingMaterial() {
        if (this.craftingMaterial == null) {
            this.craftingMaterial = Ingredient.field_193370_a;
            if (!this.craftingMaterialString.equalsIgnoreCase("null")) {
                Item item;
                String[] parts = this.craftingMaterialString.split(":");
                if (parts.length >= 3 && this.craftingMaterialString.startsWith("tag:")) {
                    ITag tag = TagCollectionManager.func_242178_a().func_241836_b().func_199910_a(new ResourceLocation(parts[1], parts[2]));
                    if (tag != null && !tag.func_230236_b_().isEmpty()) {
                        this.craftingMaterial = Ingredient.func_199805_a((ITag)tag);
                    }
                } else if (parts.length >= 2 && (item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(parts[0], parts[1]))) != null) {
                    this.craftingMaterial = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item});
                }
            }
        }
        return this.craftingMaterial;
    }

    private String makeDisplayName() {
        String[] parts = this.name.replaceAll(" ", "_").split("_");
        return Arrays.stream(parts).map(StringUtils::capitalize).collect(Collectors.joining(" "));
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("name", this.name);
        json.addProperty("disable", Boolean.valueOf(this.disabled));
        json.addProperty("tier", (Number)this.tier);
        json.addProperty("color", Integer.toHexString(this.color));
        json.addProperty("armorPoints", (Number)this.armorPoints);
        json.addProperty("enchantability", (Number)this.enchantablilty);
        json.addProperty("craftingMaterial", this.craftingMaterialString);
        json.addProperty("creative", Boolean.valueOf(this.creative));
        json.addProperty("rarity", (Number)this.rarity.ordinal());
        json.addProperty("toughness", (Number)Float.valueOf(this.toughness));
        json.addProperty("knockbackResistance", (Number)Float.valueOf(this.knockbackResistance));
        json.addProperty("capacity", (Number)this.capacity);
        json.addProperty("usage", (Number)this.usage);
        json.addProperty("speedVertical", (Number)this.speedVert);
        json.addProperty("accelVertical", (Number)this.accelVert);
        json.addProperty("speedSideways", (Number)this.speedSide);
        json.addProperty("speedHoverDescend", (Number)this.speedHover);
        json.addProperty("speedHover", (Number)this.speedHoverSlow);
        json.addProperty("sprintSpeedMulti", (Number)this.sprintSpeed);
        json.addProperty("sprintSpeedMultiVertical", (Number)this.sprintSpeedVert);
        json.addProperty("sprintFuelMulti", (Number)this.sprintFuel);
        return json;
    }

    public static Jetpack fromJson(JsonObject json) {
        String name = json.get("name").getAsString();
        boolean disable = json.get("disable").getAsBoolean();
        int tier = json.get("tier").getAsInt();
        int color = Integer.parseInt(json.get("color").getAsString(), 16);
        int armorPoints = json.get("armorPoints").getAsInt();
        int enchantability = json.get("enchantability").getAsInt();
        String craftingMaterialString = json.get("craftingMaterial").getAsString();
        boolean creative = json.get("creative").getAsBoolean();
        Rarity rarity = Rarity.values()[json.get("rarity").getAsInt()];
        float toughness = json.get("toughness").getAsFloat();
        float knockbackResistance = json.get("knockbackResistance").getAsFloat();
        Jetpack jetpack = new Jetpack(name, tier, color, armorPoints, enchantability, craftingMaterialString, toughness, knockbackResistance).setRarity(rarity).setCreative(creative).setDisabled(disable);
        int capacity = json.get("capacity").getAsInt();
        int usage = json.get("usage").getAsInt();
        double speedVert = json.get("speedVertical").getAsDouble();
        double accelVert = json.get("accelVertical").getAsDouble();
        double speedSide = json.get("speedSideways").getAsDouble();
        double speedHover = json.get("speedHoverDescend").getAsDouble();
        double speedHoverSlow = json.get("speedHover").getAsDouble();
        double sprintSpeed = json.get("sprintSpeedMulti").getAsDouble();
        double sprintSpeedVert = json.get("sprintSpeedMultiVertical").getAsDouble();
        double sprintFuel = json.get("sprintFuelMulti").getAsDouble();
        jetpack.setStats(capacity, usage, speedVert, accelVert, speedSide, speedHover, speedHoverSlow, sprintSpeed, sprintSpeedVert, sprintFuel);
        return jetpack;
    }
}

