/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.ironjetpacks.crafting.recipe;

import com.blakebr0.ironjetpacks.init.ModRecipeSerializers;
import com.blakebr0.ironjetpacks.item.JetpackItem;
import com.google.gson.JsonObject;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class JetpackUpgradeRecipe
extends ShapedRecipe {
    public JetpackUpgradeRecipe(ResourceLocation id, String group, int recipeWidth, int recipeHeight, NonNullList<Ingredient> inputs, ItemStack output) {
        super(id, group, recipeWidth, recipeHeight, inputs, output);
    }

    public ItemStack func_77572_b(CraftingInventory inv) {
        CompoundNBT tag;
        ItemStack jetpack = inv.func_70301_a(4);
        ItemStack result = this.func_77571_b().func_77946_l();
        if (!jetpack.func_190926_b() && jetpack.func_77973_b() instanceof JetpackItem && (tag = jetpack.func_77978_p()) != null) {
            result.func_77982_d(tag);
            return result;
        }
        return result;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return ModRecipeSerializers.CRAFTING_JETPACK_UPGRADE;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<JetpackUpgradeRecipe> {
        public JetpackUpgradeRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            ShapedRecipe recipe = (ShapedRecipe)IRecipeSerializer.field_222157_a.func_199425_a_(recipeId, json);
            return new JetpackUpgradeRecipe(recipeId, recipe.func_193358_e(), recipe.getRecipeWidth(), recipe.getRecipeHeight(), (NonNullList<Ingredient>)recipe.func_192400_c(), recipe.func_77571_b());
        }

        public JetpackUpgradeRecipe fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
            int i = buffer.func_150792_a();
            int j = buffer.func_150792_a();
            String s = buffer.func_150789_c(Short.MAX_VALUE);
            NonNullList inputs = NonNullList.func_191197_a((int)(i * j), (Object)Ingredient.field_193370_a);
            for (int k = 0; k < inputs.size(); ++k) {
                inputs.set(k, (Object)Ingredient.func_199566_b((PacketBuffer)buffer));
            }
            ItemStack output = buffer.func_150791_c();
            return new JetpackUpgradeRecipe(recipeId, s, i, j, (NonNullList<Ingredient>)inputs, output);
        }

        public void toNetwork(PacketBuffer buffer, JetpackUpgradeRecipe recipe) {
            buffer.func_150787_b(recipe.getRecipeWidth());
            buffer.func_150787_b(recipe.getRecipeHeight());
            buffer.func_180714_a(recipe.func_193358_e());
            for (Ingredient ingredient : recipe.func_192400_c()) {
                ingredient.func_199564_a(buffer);
            }
            buffer.func_150788_a(recipe.func_77571_b());
        }
    }
}

