/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.ironjetpacks.crafting;

import com.blakebr0.cucumber.helper.RecipeHelper;
import com.blakebr0.ironjetpacks.config.ModConfigs;
import com.blakebr0.ironjetpacks.crafting.ingredient.JetpackIngredient;
import com.blakebr0.ironjetpacks.crafting.recipe.JetpackUpgradeRecipe;
import com.blakebr0.ironjetpacks.init.ModItems;
import com.blakebr0.ironjetpacks.registry.Jetpack;
import com.blakebr0.ironjetpacks.registry.JetpackRegistry;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.tags.ITag;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class DynamicRecipeManager
implements IResourceManagerReloadListener {
    public void func_195410_a(IResourceManager resourceManager) {
        JetpackRegistry.getInstance().getAllJetpacks().forEach(jetpack -> {
            ShapedRecipe cell = this.makeCellRecipe((Jetpack)jetpack);
            ShapedRecipe thruster = this.makeThrusterRecipe((Jetpack)jetpack);
            ShapedRecipe capacitor = this.makeCapacitorRecipe((Jetpack)jetpack);
            ShapedRecipe jetpackSelf = this.makeJetpackRecipe((Jetpack)jetpack);
            JetpackUpgradeRecipe jetpackUpgrade = this.makeJetpackUpgradeRecipe((Jetpack)jetpack);
            if (cell != null) {
                RecipeHelper.addRecipe((IRecipe)cell);
            }
            if (thruster != null) {
                RecipeHelper.addRecipe((IRecipe)thruster);
            }
            if (capacitor != null) {
                RecipeHelper.addRecipe((IRecipe)capacitor);
            }
            if (jetpackSelf != null) {
                RecipeHelper.addRecipe((IRecipe)jetpackSelf);
            }
            if (jetpackUpgrade != null) {
                RecipeHelper.addRecipe((IRecipe)jetpackUpgrade);
            }
        });
    }

    @SubscribeEvent
    public void onAddReloadListeners(AddReloadListenerEvent event) {
        event.addListener((IFutureReloadListener)this);
    }

    private ShapedRecipe makeCellRecipe(Jetpack jetpack) {
        if (!((Boolean)ModConfigs.ENABLE_CELL_RECIPES.get()).booleanValue()) {
            return null;
        }
        JetpackRegistry jetpacks = JetpackRegistry.getInstance();
        Ingredient material = jetpack.getCraftingMaterial();
        if (material == Ingredient.field_193370_a) {
            return null;
        }
        ITag redstoneTag = TagCollectionManager.func_242178_a().func_241836_b().func_199910_a(Tags.Items.DUSTS_REDSTONE.func_230234_a_());
        if (redstoneTag == null) {
            return null;
        }
        Ingredient coil = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{jetpacks.getCoilForTier(jetpack.tier)});
        Ingredient redstone = Ingredient.func_199805_a((ITag)redstoneTag);
        NonNullList inputs = NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{Ingredient.field_193370_a, redstone, Ingredient.field_193370_a, material, coil, material, Ingredient.field_193370_a, redstone, Ingredient.field_193370_a});
        ResourceLocation name = new ResourceLocation("ironjetpacks", jetpack.name + "_cell");
        ItemStack output = new ItemStack((IItemProvider)jetpack.cell);
        return new ShapedRecipe(name, "ironjetpacks:cells", 3, 3, inputs, output);
    }

    private ShapedRecipe makeThrusterRecipe(Jetpack jetpack) {
        if (!((Boolean)ModConfigs.ENABLE_THRUSTER_RECIPES.get()).booleanValue()) {
            return null;
        }
        JetpackRegistry jetpacks = JetpackRegistry.getInstance();
        Ingredient material = jetpack.getCraftingMaterial();
        if (material == Ingredient.field_193370_a) {
            return null;
        }
        Ingredient coil = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{jetpacks.getCoilForTier(jetpack.tier)});
        Ingredient cell = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{jetpack.cell});
        Ingredient furnace = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150460_al});
        NonNullList inputs = NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{material, coil, material, coil, cell, coil, material, furnace, material});
        ResourceLocation name = new ResourceLocation("ironjetpacks", jetpack.name + "_thruster");
        ItemStack output = new ItemStack((IItemProvider)jetpack.thruster);
        return new ShapedRecipe(name, "ironjetpacks:thrusters", 3, 3, inputs, output);
    }

    private ShapedRecipe makeCapacitorRecipe(Jetpack jetpack) {
        if (!((Boolean)ModConfigs.ENABLE_CAPACITOR_RECIPES.get()).booleanValue()) {
            return null;
        }
        Ingredient material = jetpack.getCraftingMaterial();
        if (material == Ingredient.field_193370_a) {
            return null;
        }
        Ingredient cell = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{jetpack.cell});
        NonNullList inputs = NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{material, cell, material, material, cell, material, material, cell, material});
        ResourceLocation name = new ResourceLocation("ironjetpacks", jetpack.name + "_capacitor");
        ItemStack output = new ItemStack((IItemProvider)jetpack.capacitor);
        return new ShapedRecipe(name, "ironjetpacks:capacitors", 3, 3, inputs, output);
    }

    private ShapedRecipe makeJetpackRecipe(Jetpack jetpack) {
        if (!((Boolean)ModConfigs.ENABLE_JETPACK_RECIPES.get()).booleanValue()) {
            return null;
        }
        JetpackRegistry jetpacks = JetpackRegistry.getInstance();
        if (jetpack.tier != jetpacks.getLowestTier()) {
            return null;
        }
        Ingredient material = jetpack.getCraftingMaterial();
        if (material == Ingredient.field_193370_a) {
            return null;
        }
        Ingredient capacitor = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{jetpack.capacitor});
        Ingredient thruster = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{jetpack.thruster});
        Ingredient strap = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ModItems.STRAP.get()});
        NonNullList inputs = NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{material, capacitor, material, material, strap, material, thruster, Ingredient.field_193370_a, thruster});
        ResourceLocation name = new ResourceLocation("ironjetpacks", jetpack.name + "_jetpack");
        ItemStack output = new ItemStack((IItemProvider)jetpack.item);
        return new ShapedRecipe(name, "ironjetpacks:jetpacks", 3, 3, inputs, output);
    }

    private JetpackUpgradeRecipe makeJetpackUpgradeRecipe(Jetpack jetpack) {
        if (!((Boolean)ModConfigs.ENABLE_JETPACK_RECIPES.get()).booleanValue()) {
            return null;
        }
        JetpackRegistry jetpacks = JetpackRegistry.getInstance();
        if (jetpack.tier == jetpacks.getLowestTier()) {
            return null;
        }
        Ingredient material = jetpack.getCraftingMaterial();
        if (material == Ingredient.field_193370_a) {
            return null;
        }
        Ingredient capacitor = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{jetpack.capacitor});
        Ingredient thruster = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{jetpack.thruster});
        JetpackIngredient jetpackTier = new JetpackIngredient(jetpack.tier - 1);
        NonNullList inputs = NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{material, capacitor, material, material, jetpackTier, material, thruster, Ingredient.field_193370_a, thruster});
        ResourceLocation name = new ResourceLocation("ironjetpacks", jetpack.name + "_jetpack");
        ItemStack output = new ItemStack((IItemProvider)jetpack.item);
        return new JetpackUpgradeRecipe(name, "ironjetpacks:jetpacks", 3, 3, (NonNullList<Ingredient>)inputs, output);
    }
}

