/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.ironjetpacks.config;

import com.blakebr0.ironjetpacks.registry.Jetpack;
import com.blakebr0.ironjetpacks.registry.JetpackRegistry;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ModJetpacks {
    private static final Logger LOGGER = LogManager.getLogger((String)"Iron Jetpacks");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Jetpack WOOD = new Jetpack("wood", 0, 7033119, 1, 15, "tag:minecraft:planks", 0.0f, 0.0f);
    private static final Jetpack STONE = new Jetpack("stone", 1, 0x7F7F7F, 2, 12, "tag:forge:stone", 0.0f, 0.0f);
    private static final Jetpack IRON = new Jetpack("iron", 2, 0xC1C1C1, 3, 9, "tag:forge:ingots/iron", 0.0f, 0.0f);
    private static final Jetpack GOLD = new Jetpack("gold", 3, 0xDEDE00, 2, 25, "tag:forge:ingots/gold", 0.0f, 0.0f);
    private static final Jetpack DIAMOND = new Jetpack("diamond", 4, 4910545, 4, 10, "tag:forge:gems/diamond", 0.0f, 0.0f);
    private static final Jetpack EMERALD = new Jetpack("emerald", 5, 4322180, 4, 15, "tag:forge:gems/emerald", 0.0f, 0.0f);
    private static final Jetpack CREATIVE = new Jetpack("creative", 0, 13572841, 8, 0, "null", 0.0f, 0.0f).setCreative();
    private static final Jetpack COPPER = new Jetpack("copper", 1, 13529601, 2, 12, "tag:forge:ingots/copper", 0.0f, 0.0f);
    private static final Jetpack BRONZE = new Jetpack("bronze", 2, 15507007, 3, 9, "tag:forge:ingots/bronze", 0.0f, 0.0f);
    private static final Jetpack SILVER = new Jetpack("silver", 2, 10470621, 3, 12, "tag:forge:ingots/silver", 0.0f, 0.0f);
    private static final Jetpack STEEL = new Jetpack("steel", 3, 0x565656, 3, 15, "tag:forge:ingots/steel", 0.0f, 0.0f);
    private static final Jetpack ELECTRUM = new Jetpack("electrum", 3, 10981685, 2, 18, "tag:forge:ingots/electrum", 0.0f, 0.0f);
    private static final Jetpack INVAR = new Jetpack("invar", 3, 9608599, 3, 15, "tag:forge:ingots/invar", 0.0f, 0.0f);
    private static final Jetpack PLATINUM = new Jetpack("platinum", 4, 7334639, 4, 12, "tag:forge:ingots/platinum", 0.0f, 0.0f);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadJsons() {
        File[] files;
        JetpackRegistry registry = JetpackRegistry.getInstance();
        File dir = FMLPaths.CONFIGDIR.get().resolve("ironjetpacks/jetpacks").toFile();
        if (!dir.exists() && dir.mkdirs()) {
            for (Jetpack jetpack : ModJetpacks.defaults()) {
                File file = new File(dir, jetpack.name + ".json");
                try {
                    FileWriter writer = new FileWriter(file);
                    Throwable throwable = null;
                    try {
                        GSON.toJson((JsonElement)jetpack.toJson(), (Appendable)writer);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (writer == null) continue;
                        if (throwable != null) {
                            try {
                                ((Writer)writer).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        ((Writer)writer).close();
                    }
                }
                catch (Exception e) {
                    LOGGER.error("An error occurred while generating jetpack jsons", (Throwable)e);
                }
            }
        }
        if ((files = dir.listFiles((FileFilter)FileFilterUtils.suffixFileFilter((String)".json"))) == null) {
            return;
        }
        ArrayList<Jetpack> jetpacks = new ArrayList<Jetpack>();
        for (File file : files) {
            Jetpack jetpack = null;
            InputStreamReader reader = null;
            try {
                JsonParser parser = new JsonParser();
                reader = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);
                JsonObject json = parser.parse((Reader)reader).getAsJsonObject();
                reader.close();
                if (ModJetpacks.handleMigrations(json)) {
                    try (FileWriter writer = new FileWriter(file);){
                        GSON.toJson((JsonElement)json, (Appendable)writer);
                    }
                    catch (Exception e) {
                        LOGGER.error("An error occurred while migrating jetpack json {}", (Object)file.getName(), (Object)e);
                        IOUtils.closeQuietly((Reader)reader);
                        continue;
                    }
                }
                jetpack = Jetpack.fromJson(json);
                IOUtils.closeQuietly((Reader)reader);
            }
            catch (Exception e) {
                LOGGER.error("An error occurred while reading jetpack json {}", (Object)file.getName(), (Object)e);
            }
            finally {
                IOUtils.closeQuietly(reader);
            }
            if (jetpack == null || jetpack.disabled) continue;
            jetpacks.add(jetpack);
        }
        jetpacks.sort(Comparator.comparingInt(Jetpack::getTier));
        for (Jetpack j : jetpacks) {
            registry.register(j);
        }
    }

    private static boolean handleMigrations(JsonObject json) {
        boolean changed = false;
        if (!json.has("creative")) {
            json.addProperty("creative", Boolean.valueOf(false));
            changed = true;
        }
        if (!json.has("rarity")) {
            json.addProperty("rarity", (Number)0);
            changed = true;
        }
        if (!json.has("sprintSpeedMultiVertical")) {
            json.addProperty("sprintSpeedMultiVertical", (Number)1.0);
            changed = true;
        }
        if (!json.has("toughness")) {
            json.addProperty("toughness", (Number)Float.valueOf(0.0f));
            changed = true;
        }
        if (!json.has("knockbackResistance")) {
            json.addProperty("knockbackResistance", (Number)Float.valueOf(0.0f));
            changed = true;
        }
        return changed;
    }

    private static List<Jetpack> defaults() {
        ArrayList<Jetpack> defaults = new ArrayList<Jetpack>();
        defaults.add(WOOD);
        defaults.add(STONE);
        defaults.add(IRON);
        defaults.add(GOLD);
        defaults.add(DIAMOND);
        defaults.add(EMERALD);
        defaults.add(CREATIVE);
        defaults.add(COPPER);
        defaults.add(BRONZE);
        defaults.add(SILVER);
        defaults.add(STEEL);
        defaults.add(ELECTRUM);
        defaults.add(INVAR);
        defaults.add(PLATINUM);
        defaults.sort(Comparator.comparingInt(Jetpack::getTier));
        return defaults;
    }

    static {
        WOOD.setStats(20000, 32, 0.18, 0.1, 0.06, 0.16, 0.14, 1.0, 1.0, 1.0);
        STONE.setStats(100000, 70, 0.25, 0.11, 0.08, 0.18, 0.1, 1.0, 1.0, 1.0);
        IRON.setStats(800000, 120, 0.41, 0.12, 0.14, 0.27, 0.075, 1.1, 1.05, 2.1);
        GOLD.setStats(10000000, 300, 0.61, 0.13, 0.15, 0.34, 0.03, 1.5, 1.25, 3.2);
        DIAMOND.setStats(30000000, 650, 0.9, 0.15, 0.19, 0.41, 0.005, 1.8, 1.4, 3.8);
        EMERALD.setStats(48000000, 880, 1.03, 0.17, 0.21, 0.45, 0.0, 2.0, 1.5, 4.0);
        CREATIVE.setStats(0, 0, 1.03, 0.17, 0.21, 0.45, 0.0, 2.0, 1.5, 0.0);
        COPPER.setStats(250000, 85, 0.29, 0.11, 0.1, 0.23, 0.092, 1.05, 1.025, 1.4);
        BRONZE.setStats(800000, 120, 0.41, 0.12, 0.14, 0.27, 0.075, 1.1, 1.05, 2.1);
        SILVER.setStats(1200000, 150, 0.48, 0.13, 0.15, 0.3, 0.07, 1.3, 1.15, 2.7);
        STEEL.setStats(12000000, 350, 0.67, 0.135, 0.155, 0.35, 0.025, 1.5, 1.25, 3.2);
        ELECTRUM.setStats(10000000, 310, 0.79, 0.14, 0.17, 0.37, 0.03, 1.6, 1.3, 3.5);
        INVAR.setStats(12000000, 350, 0.61, 0.13, 0.15, 0.34, 0.03, 1.5, 1.25, 3.2);
        PLATINUM.setStats(36000000, 720, 0.92, 0.155, 0.193, 0.42, 0.005, 1.8, 1.4, 3.8);
    }
}

