/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.storage;

import codechicken.enderstorage.api.AbstractEnderStorage;
import codechicken.enderstorage.api.Frequency;
import codechicken.enderstorage.config.EnderStorageConfig;
import codechicken.enderstorage.container.ContainerEnderItemStorage;
import codechicken.enderstorage.manager.EnderStorageManager;
import codechicken.enderstorage.network.EnderStorageSPH;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.inventory.InventoryUtils;
import codechicken.lib.util.ArrayUtils;
import codechicken.lib.util.ServerUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.text.ITextComponent;

public class EnderItemStorage
extends AbstractEnderStorage
implements IInventory {
    public static final EnderStorageManager.StorageType<EnderItemStorage> TYPE = new EnderStorageManager.StorageType("item");
    public static final int[] sizes = new int[]{9, 27, 54};
    private ItemStack[] items;
    private int open;
    private int size = EnderStorageConfig.storageSize;

    public EnderItemStorage(EnderStorageManager manager, Frequency freq) {
        super(manager, freq);
        this.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearStorage() {
        EnderItemStorage enderItemStorage = this;
        synchronized (enderItemStorage) {
            this.empty();
            this.setDirty();
        }
    }

    @Override
    public void loadFromTag(CompoundNBT tag) {
        this.size = tag.func_74771_c("size");
        this.empty();
        InventoryUtils.readItemStacksFromTag((ItemStack[])this.items, (ListNBT)tag.func_150295_c("Items", 10));
        if (this.size != EnderStorageConfig.storageSize) {
            this.alignSize();
        }
    }

    private void alignSize() {
        if (EnderStorageConfig.storageSize > this.size) {
            ItemStack[] newItems = (ItemStack[])ArrayUtils.fill((Object[])new ItemStack[sizes[EnderStorageConfig.storageSize]], (Object)ItemStack.field_190927_a);
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
            this.size = EnderStorageConfig.storageSize;
            this.func_70296_d();
        } else {
            int numStacks = 0;
            for (ItemStack item : this.items) {
                if (item.func_190926_b()) continue;
                ++numStacks;
            }
            if (numStacks <= sizes[EnderStorageConfig.storageSize]) {
                ItemStack[] newItems = (ItemStack[])ArrayUtils.fill((Object[])new ItemStack[sizes[EnderStorageConfig.storageSize]], (Object)ItemStack.field_190927_a);
                int copyTo = 0;
                for (ItemStack item : this.items) {
                    if (item.func_190926_b()) continue;
                    newItems[copyTo] = item;
                    ++copyTo;
                }
                this.items = newItems;
                this.size = EnderStorageConfig.storageSize;
                this.func_70296_d();
            }
        }
    }

    @Override
    public String type() {
        return "item";
    }

    @Override
    public CompoundNBT saveToTag() {
        if (this.size != EnderStorageConfig.storageSize && this.open == 0) {
            this.alignSize();
        }
        CompoundNBT compound = new CompoundNBT();
        compound.func_218657_a("Items", (INBT)InventoryUtils.writeItemStacksToTag((ItemStack[])this.items));
        compound.func_74774_a("size", (byte)this.size);
        return compound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemStack func_70301_a(int slot) {
        EnderItemStorage enderItemStorage = this;
        synchronized (enderItemStorage) {
            return this.items[slot];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemStack func_70304_b(int slot) {
        EnderItemStorage enderItemStorage = this;
        synchronized (enderItemStorage) {
            return InventoryUtils.removeStackFromSlot((IInventory)this, (int)slot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_70299_a(int slot, ItemStack stack) {
        EnderItemStorage enderItemStorage = this;
        synchronized (enderItemStorage) {
            this.items[slot] = stack;
            this.func_70296_d();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openInventory() {
        if (this.manager.client) {
            return;
        }
        EnderItemStorage enderItemStorage = this;
        synchronized (enderItemStorage) {
            ++this.open;
            if (this.open == 1) {
                EnderStorageSPH.sendOpenUpdateTo(null, this.freq, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeInventory() {
        if (this.manager.client) {
            return;
        }
        EnderItemStorage enderItemStorage = this;
        synchronized (enderItemStorage) {
            --this.open;
            if (this.open == 0) {
                EnderStorageSPH.sendOpenUpdateTo(null, this.freq, false);
            }
        }
    }

    public int getNumOpen() {
        return this.open;
    }

    public int func_70302_i_() {
        return sizes[this.size];
    }

    public boolean func_191420_l() {
        return ArrayUtils.count((Object[])this.items, stack -> !stack.func_190926_b()) <= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemStack func_70298_a(int slot, int size) {
        EnderItemStorage enderItemStorage = this;
        synchronized (enderItemStorage) {
            return InventoryUtils.decrStackSize((IInventory)this, (int)slot, (int)size);
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        this.setDirty();
    }

    public boolean func_70300_a(PlayerEntity var1) {
        return true;
    }

    public void empty() {
        this.items = new ItemStack[this.func_70302_i_()];
        ArrayUtils.fill((Object[])this.items, (Object)ItemStack.field_190927_a);
    }

    public void openContainer(ServerPlayerEntity player, ITextComponent title) {
        ServerUtils.openContainer((ServerPlayerEntity)player, (INamedContainerProvider)new SimpleNamedContainerProvider((id, inv, p) -> new ContainerEnderItemStorage(id, inv, this), title), packet -> {
            this.freq.writeToPacket((MCDataOutput)packet);
            packet.writeByte(this.size);
        });
    }

    public void handleContainerPacket(MCDataInput packet) {
        this.size = packet.readByte();
        this.empty();
    }

    public int getSize() {
        return this.size;
    }

    public int openCount() {
        return this.open;
    }

    public void setClientOpen(int i) {
        if (this.manager.client) {
            this.open = i;
        }
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return true;
    }

    public void func_174889_b(PlayerEntity player) {
    }

    public void func_174886_c(PlayerEntity player) {
    }

    public void func_174888_l() {
    }
}

