/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.network;

import codechicken.enderstorage.api.Frequency;
import codechicken.enderstorage.manager.EnderStorageManager;
import codechicken.enderstorage.network.EnderStorageNetwork;
import codechicken.enderstorage.storage.EnderLiquidStorage;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.math.MathHelper;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.util.ClientUtils;
import codechicken.lib.util.ServerUtils;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;

public class TankSynchroniser {
    private static Map<UUID, PlayerItemTankCache> playerItemTankStates;
    private static PlayerItemTankCache clientState;

    public static void syncClient(Frequency freq, FluidStack liquid) {
        clientState.sync(freq, liquid);
    }

    public static FluidStack getClientLiquid(Frequency freq) {
        if (clientState != null) {
            return clientState.getLiquid(freq);
        }
        return FluidStack.EMPTY;
    }

    public static void handleVisiblityPacket(ServerPlayerEntity player, PacketCustom packet) {
        playerItemTankStates.get(player.func_110124_au()).handleVisiblityPacket(packet);
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        playerItemTankStates.put(event.getPlayer().func_110124_au(), new PlayerItemTankCache((ServerPlayerEntity)event.getPlayer()));
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        if (playerItemTankStates != null) {
            playerItemTankStates.remove(event.getPlayer().func_110124_au());
        }
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        playerItemTankStates.put(event.getPlayer().func_110124_au(), new PlayerItemTankCache((ServerPlayerEntity)event.getPlayer()));
    }

    @SubscribeEvent
    public void tickEnd(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && playerItemTankStates != null) {
            for (Map.Entry<UUID, PlayerItemTankCache> entry : playerItemTankStates.entrySet()) {
                entry.getValue().update();
            }
        }
    }

    @SubscribeEvent
    public void tickEnd(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && ClientUtils.inWorld() && clientState != null) {
            clientState.update();
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (!event.getWorld().func_201670_d() && !ServerUtils.getServer().func_71278_l()) {
            playerItemTankStates = null;
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (event.getWorld().func_201670_d()) {
            clientState = new PlayerItemTankCache();
        } else if (playerItemTankStates == null) {
            playerItemTankStates = new HashMap<UUID, PlayerItemTankCache>();
        }
    }

    public static class PlayerItemTankCache {
        private boolean client;
        private HashMap<String, PlayerItemTankState> tankStates = new HashMap();
        private HashSet<Frequency> b_visible;
        private HashSet<Frequency> a_visible;
        private ServerPlayerEntity player;

        public PlayerItemTankCache(ServerPlayerEntity player) {
            this.player = player;
            this.client = false;
        }

        public PlayerItemTankCache() {
            this.client = true;
            this.a_visible = new HashSet();
            this.b_visible = new HashSet();
        }

        public void track(Frequency freq, boolean t) {
            String key = freq.toString();
            PlayerItemTankState state = this.tankStates.get(key);
            if (state == null) {
                if (!t) {
                    return;
                }
                state = new PlayerItemTankState(this.player, EnderStorageManager.instance(false).getStorage(freq, EnderLiquidStorage.TYPE));
                this.tankStates.put(key, state);
            }
            state.setTracking(t);
        }

        public void sync(Frequency freq, FluidStack liquid) {
            String key = freq.toString();
            PlayerItemTankState state = this.tankStates.computeIfAbsent(key, k -> new PlayerItemTankState());
            state.sync(liquid);
        }

        public void update() {
            for (Map.Entry<String, PlayerItemTankState> entry : this.tankStates.entrySet()) {
                entry.getValue().update(this.client);
            }
            if (this.client) {
                Sets.SetView new_visible = Sets.difference(this.a_visible, this.b_visible);
                Sets.SetView old_visible = Sets.difference(this.b_visible, this.a_visible);
                if (!new_visible.isEmpty() || !old_visible.isEmpty()) {
                    PacketCustom packet = new PacketCustom(EnderStorageNetwork.NET_CHANNEL, 1);
                    packet.writeShort(new_visible.size());
                    new_visible.forEach(freq -> freq.writeToPacket((MCDataOutput)packet));
                    packet.writeShort(old_visible.size());
                    old_visible.forEach(freq -> freq.writeToPacket((MCDataOutput)packet));
                    packet.sendToServer();
                }
                HashSet<Frequency> temp = this.b_visible;
                temp.clear();
                this.b_visible = this.a_visible;
                this.a_visible = temp;
            }
        }

        public FluidStack getLiquid(Frequency freq) {
            String key = freq.toString();
            this.a_visible.add(freq);
            PlayerItemTankState state = this.tankStates.get(key);
            return state == null ? FluidStack.EMPTY : state.c_liquid;
        }

        public void handleVisiblityPacket(PacketCustom packet) {
            int i;
            int k = packet.readUShort();
            for (i = 0; i < k; ++i) {
                this.track(Frequency.readFromPacket((MCDataInput)packet), true);
            }
            k = packet.readUShort();
            for (i = 0; i < k; ++i) {
                this.track(Frequency.readFromPacket((MCDataInput)packet), false);
            }
        }
    }

    public static class PlayerItemTankState
    extends TankState {
        private ServerPlayerEntity player;
        private boolean tracking;

        public PlayerItemTankState(ServerPlayerEntity player, EnderLiquidStorage storage) {
            this.player = player;
            this.setFrequency(storage.freq);
            this.tracking = true;
        }

        public PlayerItemTankState() {
        }

        @Override
        public void sendSyncPacket() {
            if (!this.tracking) {
                return;
            }
            PacketCustom packet = new PacketCustom(EnderStorageNetwork.NET_CHANNEL, 4);
            this.getStorage((boolean)false).freq.writeToPacket((MCDataOutput)packet);
            packet.writeFluidStack(this.s_liquid);
            packet.sendToPlayer(this.player);
        }

        public void setTracking(boolean t) {
            this.tracking = t;
        }

        @Override
        public void update(boolean client) {
            if (this.tracking || client) {
                super.update(client);
            }
        }
    }

    public static abstract class TankState {
        public Frequency frequency;
        public FluidStack c_liquid = new FluidStack((Fluid)Fluids.field_204546_a, 0);
        public FluidStack s_liquid = new FluidStack((Fluid)Fluids.field_204546_a, 0);
        public FluidStack f_liquid = new FluidStack((Fluid)Fluids.field_204546_a, 0);

        public void setFrequency(Frequency frequency) {
            this.frequency = frequency;
        }

        public void update(boolean client) {
            FluidStack a_liquid;
            FluidStack b_liquid;
            if (client) {
                b_liquid = this.c_liquid.copy();
                if (this.s_liquid.isFluidEqual(this.c_liquid) || this.c_liquid.isEmpty()) {
                    int change = MathHelper.approachExpI((int)this.c_liquid.getAmount(), (int)this.s_liquid.getAmount(), (double)0.1);
                    if (this.c_liquid.isEmpty()) {
                        this.c_liquid = new FluidStack(this.s_liquid, change);
                    } else {
                        this.c_liquid.setAmount(change);
                    }
                } else if (this.c_liquid.getAmount() > 100) {
                    this.c_liquid.setAmount(MathHelper.retreatExpI((int)this.c_liquid.getAmount(), (int)0, (int)this.f_liquid.getAmount(), (double)0.1, (int)1000));
                }
                a_liquid = this.c_liquid;
            } else {
                this.s_liquid = this.getStorage(false).getFluid();
                b_liquid = this.s_liquid.copy();
                if (!this.s_liquid.isFluidEqual(this.c_liquid)) {
                    this.sendSyncPacket();
                    this.c_liquid = this.s_liquid.copy();
                } else if (Math.abs(this.c_liquid.getAmount() - this.s_liquid.getAmount()) > 250 || this.s_liquid.getAmount() == 0 && this.c_liquid.getAmount() > 0) {
                    this.sendSyncPacket();
                    this.c_liquid = this.s_liquid.copy();
                }
                a_liquid = this.s_liquid;
            }
            if (b_liquid.getAmount() == 0 != (a_liquid.getAmount() == 0) || !b_liquid.isFluidEqual(a_liquid)) {
                this.onLiquidChanged();
            }
        }

        public void onLiquidChanged() {
        }

        public abstract void sendSyncPacket();

        public void sync(FluidStack liquid) {
            this.s_liquid = liquid;
            if (!this.s_liquid.isFluidEqual(this.c_liquid)) {
                this.f_liquid = this.c_liquid.copy();
            }
        }

        public EnderLiquidStorage getStorage(boolean client) {
            return EnderStorageManager.instance(client).getStorage(this.frequency, EnderLiquidStorage.TYPE);
        }
    }
}

