/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.expansion.compat.jei.dynamo;

import cofh.lib.util.helpers.StringHelper;
import cofh.thermal.core.compat.jei.TCoreJeiPlugin;
import cofh.thermal.core.util.recipes.dynamo.CompressionFuel;
import cofh.thermal.expansion.client.gui.dynamo.DynamoCompressionScreen;
import cofh.thermal.expansion.init.TExpReferences;
import cofh.thermal.lib.compat.jei.Drawables;
import cofh.thermal.lib.compat.jei.ThermalFuelCategory;
import cofh.thermal.lib.util.recipes.ThermalFuel;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class CompressionFuelCategory
extends ThermalFuelCategory<CompressionFuel> {
    protected IDrawableStatic tankBackground;
    protected IDrawableStatic tankOverlay;

    public CompressionFuelCategory(IGuiHelper guiHelper, ItemStack icon, ResourceLocation uid) {
        super(guiHelper, icon, uid);
        this.background = guiHelper.drawableBuilder(DynamoCompressionScreen.TEXTURE, 26, 11, 70, 62).addPadding(0, 0, 16, 78).build();
        this.name = StringHelper.getTextComponent((String)TExpReferences.DYNAMO_COMPRESSION_BLOCK.func_149739_a());
        this.durationBackground = Drawables.getDrawables((IGuiHelper)guiHelper).getScale(4);
        this.tankBackground = Drawables.getDrawables((IGuiHelper)guiHelper).getTank(1);
        this.tankOverlay = Drawables.getDrawables((IGuiHelper)guiHelper).getTankOverlay(1);
        this.duration = guiHelper.createAnimatedDrawable(Drawables.getDrawables((IGuiHelper)guiHelper).getScaleFill(4), 400, IDrawableAnimated.StartDirection.TOP, true);
    }

    public Class<? extends CompressionFuel> getRecipeClass() {
        return CompressionFuel.class;
    }

    public void setIngredients(CompressionFuel fuel, IIngredients ingredients) {
        TCoreJeiPlugin.setInputIngredients((IIngredients)ingredients, (List)fuel.getInputFluids());
    }

    public void setRecipe(IRecipeLayout layout, CompressionFuel fuel, IIngredients ingredients) {
        List inputFluids = ingredients.getInputs(VanillaTypes.FLUID);
        IGuiFluidStackGroup guiFluidStacks = layout.getFluidStacks();
        guiFluidStacks.init(0, false, 34, 11, 16, 40, TCoreJeiPlugin.tankSize((int)8000), false, TCoreJeiPlugin.tankOverlay((IDrawable)this.tankOverlay));
        guiFluidStacks.set(0, (List)inputFluids.get(0));
        TCoreJeiPlugin.addDefaultFluidTooltipCallback((IGuiFluidStackGroup)guiFluidStacks);
    }

    public void draw(CompressionFuel fuel, MatrixStack matrixStack, double mouseX, double mouseY) {
        super.draw((ThermalFuel)fuel, matrixStack, mouseX, mouseY);
        this.tankBackground.draw(matrixStack, 33, 10);
    }
}

