/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.pedestal.wrappers;

import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import xreliquary.api.IPedestal;
import xreliquary.api.IPedestalRedstoneItemWrapper;
import xreliquary.reference.Settings;

public class PedestalRedstoneWrapper
implements IPedestalRedstoneItemWrapper {
    private final boolean powered;

    private PedestalRedstoneWrapper(boolean powered) {
        this.powered = powered;
    }

    @Override
    public void updateRedstone(ItemStack stack, IPedestal pedestal) {
        List<BlockPos> pedestalsInRange = pedestal.getPedestalsInRange((Integer)Settings.COMMON.blocks.pedestal.redstoneWrapperRange.get());
        World world = pedestal.getTheWorld();
        BlockPos thisPos = pedestal.getBlockPos();
        boolean buttonEnabled = pedestal.switchedOn();
        for (BlockPos pos : pedestalsInRange) {
            IPedestal ped;
            if (pos.equals((Object)thisPos) || (ped = (IPedestal)world.func_175625_s(pos)) == null) continue;
            if (this.powered || buttonEnabled || pedestal.getTheWorld().func_175640_z(pedestal.getBlockPos())) {
                ped.switchOn(thisPos);
                continue;
            }
            ped.switchOff(thisPos);
        }
    }

    @Override
    public void onRemoved(ItemStack stack, IPedestal pedestal) {
        List<BlockPos> pedestalsInRange = pedestal.getPedestalsInRange((Integer)Settings.COMMON.blocks.pedestal.redstoneWrapperRange.get());
        World world = pedestal.getTheWorld();
        BlockPos thisPos = pedestal.getBlockPos();
        for (BlockPos pos : pedestalsInRange) {
            IPedestal ped = (IPedestal)world.func_175625_s(pos);
            if (ped == null) continue;
            ped.switchOff(thisPos);
        }
    }

    public static class Toggleable
    extends PedestalRedstoneWrapper {
        public Toggleable() {
            super(false);
        }
    }

    public static class AlwaysOn
    extends PedestalRedstoneWrapper {
        public AlwaysOn() {
            super(true);
        }
    }
}

