/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.pedestal.wrappers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.CowEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.Property;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.IFluidHandler;
import xreliquary.api.IPedestal;
import xreliquary.api.IPedestalActionItemWrapper;
import xreliquary.reference.Settings;

public class PedestalBucketWrapper
implements IPedestalActionItemWrapper {
    private static final int UNSUCCESSFUL_TRIES_TO_CLEAN_QUEUE = 5;
    private final List<BlockPos> queueToDrain = new ArrayList<BlockPos>();
    private int unsuccessfulTries = 0;

    @Override
    public void update(ItemStack stack, IPedestal pedestal) {
        int bucketRange;
        BlockPos pos = pedestal.getBlockPos();
        if (!this.milkCows(pedestal, pos, bucketRange = ((Integer)Settings.COMMON.blocks.pedestal.bucketWrapperRange.get()).intValue(), stack) && !this.drainLiquid(pedestal, pos, bucketRange)) {
            pedestal.setActionCoolDown(2 * (Integer)Settings.COMMON.blocks.pedestal.bucketWrapperCooldown.get());
            return;
        }
        pedestal.setActionCoolDown((Integer)Settings.COMMON.blocks.pedestal.bucketWrapperCooldown.get());
    }

    @Override
    public void onRemoved(ItemStack stack, IPedestal pedestal) {
    }

    @Override
    public void stop(ItemStack stack, IPedestal pedestal) {
    }

    private boolean drainLiquid(IPedestal pedestal, BlockPos pos, int bucketRange) {
        World world = pedestal.getTheWorld();
        if (this.queueToDrain.isEmpty()) {
            this.updateQueueToDrain(world, pos, bucketRange);
        }
        if (this.queueToDrain.isEmpty()) {
            return false;
        }
        Iterator<BlockPos> iterator = this.queueToDrain.iterator();
        while (iterator.hasNext()) {
            BlockPos blockToDrain = iterator.next();
            BlockState blockState = world.func_180495_p(blockToDrain);
            Fluid fluid = blockState.func_204520_s().func_206886_c();
            if (fluid != Fluids.field_204541_a) {
                Optional<FluidStack> fs = this.drainBlock(world, blockToDrain, blockState.func_177230_c(), blockState, fluid, IFluidHandler.FluidAction.SIMULATE);
                if (fs.isPresent()) {
                    FluidStack fluidStack = fs.get();
                    if (pedestal.fillConnectedTank(fluidStack, IFluidHandler.FluidAction.SIMULATE) != fluidStack.getAmount()) continue;
                    this.drainBlock(world, blockToDrain, blockState.func_177230_c(), blockState, fluid, IFluidHandler.FluidAction.EXECUTE);
                    pedestal.fillConnectedTank(fluidStack);
                    iterator.remove();
                    return true;
                }
                iterator.remove();
                continue;
            }
            iterator.remove();
        }
        ++this.unsuccessfulTries;
        if (this.unsuccessfulTries >= 5) {
            this.queueToDrain.clear();
            this.unsuccessfulTries = 0;
        }
        return false;
    }

    private void updateQueueToDrain(World world, BlockPos pos, int bucketRange) {
        for (int y = pos.func_177956_o() + bucketRange; y >= pos.func_177956_o() - bucketRange; --y) {
            for (int x = pos.func_177958_n() - bucketRange; x <= pos.func_177958_n() + bucketRange; ++x) {
                for (int z = pos.func_177952_p() - bucketRange; z <= pos.func_177952_p() + bucketRange; ++z) {
                    BlockPos currentBlockPos = new BlockPos(x, y, z);
                    BlockState blockState = world.func_180495_p(currentBlockPos);
                    Fluid fluid = blockState.func_204520_s().func_206886_c();
                    if (fluid == Fluids.field_204541_a || !this.canDrainBlock(world, currentBlockPos, blockState.func_177230_c(), blockState, fluid)) continue;
                    this.queueToDrain.add(currentBlockPos);
                }
            }
        }
    }

    private boolean canDrainBlock(World world, BlockPos pos, Block block, BlockState blockState, Fluid fluid) {
        return this.drainBlock(world, pos, block, blockState, fluid, IFluidHandler.FluidAction.SIMULATE).isPresent();
    }

    private Optional<FluidStack> drainBlock(World world, BlockPos pos, Block block, BlockState blockState, Fluid fluid, IFluidHandler.FluidAction action) {
        if (block instanceof IFluidBlock) {
            IFluidBlock fluidBlock = (IFluidBlock)block;
            if (!fluidBlock.canDrain(world, pos)) {
                return Optional.empty();
            }
            return Optional.of(fluidBlock.drain(world, pos, action));
        }
        if (block instanceof FlowingFluidBlock) {
            int level = (Integer)blockState.func_177229_b((Property)FlowingFluidBlock.field_176367_b);
            if (level != 0) {
                return Optional.empty();
            }
            if (action == IFluidHandler.FluidAction.EXECUTE) {
                world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            }
            return Optional.of(new FluidStack(fluid, 1000));
        }
        return Optional.empty();
    }

    private boolean milkCows(IPedestal pedestal, BlockPos pos, int bucketRange, ItemStack stack) {
        int fluidAdded;
        World world = pedestal.getTheWorld();
        List entities = world.func_217357_a(CowEntity.class, new AxisAlignedBB((double)pos.func_177958_n() - (double)bucketRange, (double)pos.func_177956_o() - (double)bucketRange, (double)pos.func_177952_p() - (double)bucketRange, (double)pos.func_177958_n() + (double)bucketRange, (double)pos.func_177956_o() + (double)bucketRange, (double)pos.func_177952_p() + (double)bucketRange));
        if (entities.isEmpty()) {
            return false;
        }
        CowEntity cow = (CowEntity)entities.get(world.field_73012_v.nextInt(entities.size()));
        FakePlayer fakePlayer = pedestal.getFakePlayer();
        fakePlayer.func_70107_b((double)pos.func_177958_n(), 0.0, (double)pos.func_177952_p());
        ItemStack bucketStack = new ItemStack((IItemProvider)Items.field_151133_ar);
        fakePlayer.func_184611_a(Hand.MAIN_HAND, bucketStack);
        cow.func_230254_b_((PlayerEntity)fakePlayer, Hand.MAIN_HAND);
        if (fakePlayer.func_184586_b(Hand.MAIN_HAND).func_77973_b() == Items.field_151117_aB && (fluidAdded = pedestal.fillConnectedTank(new FluidStack((Fluid)ForgeMod.MILK.get(), 1000))) == 0) {
            if (stack.func_190916_E() == 1) {
                pedestal.setItem(new ItemStack((IItemProvider)Items.field_151117_aB));
                return true;
            }
            if (stack.func_190916_E() > 1) {
                stack.func_190918_g(1);
                ItemEntity entity = new ItemEntity(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + 0.5, new ItemStack((IItemProvider)Items.field_151117_aB));
                world.func_217376_c((Entity)entity);
            }
        }
        return true;
    }
}

