/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import xreliquary.items.ToggleableItem;
import xreliquary.items.util.IBaubleItem;
import xreliquary.reference.Settings;
import xreliquary.util.InventoryHelper;
import xreliquary.util.MobHelper;

public class TwilightCloakItem
extends ToggleableItem
implements IBaubleItem {
    public TwilightCloakItem() {
        super(new Item.Properties().func_200917_a(1));
        MinecraftForge.EVENT_BUS.addListener(this::onEntityTargetedEvent);
        MinecraftForge.EVENT_BUS.addListener(this::onLivingUpdate);
    }

    public Rarity func_77613_e(ItemStack stack) {
        return Rarity.EPIC;
    }

    public void func_77663_a(ItemStack twilightCloak, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (!(entity instanceof PlayerEntity)) {
            return;
        }
        this.updateInvisibility(twilightCloak, (PlayerEntity)entity);
    }

    private void updateInvisibility(ItemStack twilightCloak, PlayerEntity player) {
        if (!this.isEnabled(twilightCloak)) {
            return;
        }
        if (player.field_70170_p.func_201696_r(player.func_233580_cy_()) > (Integer)Settings.COMMON.items.twilightCloak.maxLightLevel.get()) {
            return;
        }
        EffectInstance quickInvisibility = new EffectInstance(Effects.field_76441_p, 2, 0, false, false);
        player.func_195064_c(quickInvisibility);
    }

    @Override
    public IBaubleItem.Type getBaubleType() {
        return IBaubleItem.Type.BODY;
    }

    @Override
    public void onWornTick(ItemStack twilightCloak, LivingEntity player) {
        this.updateInvisibility(twilightCloak, (PlayerEntity)player);
    }

    private void onEntityTargetedEvent(LivingSetAttackTargetEvent event) {
        this.doTwilightCloakCheck((LivingEvent)event);
    }

    private void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        this.doTwilightCloakCheck((LivingEvent)event);
    }

    private void doTwilightCloakCheck(LivingEvent event) {
        if (event.getEntity() instanceof MobEntity) {
            MobEntity entityLiving = (MobEntity)event.getEntity();
            if (!(entityLiving.func_70638_az() instanceof PlayerEntity)) {
                return;
            }
            PlayerEntity player = (PlayerEntity)entityLiving.func_70638_az();
            if (!InventoryHelper.playerHasItem(player, this, true, IBaubleItem.Type.BODY) || player.field_70170_p.func_201696_r(player.func_233580_cy_()) > (Integer)Settings.COMMON.items.twilightCloak.maxLightLevel.get()) {
                return;
            }
            MobHelper.resetTarget(entityLiving);
        }
    }
}

