/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.compat.jei.magazines;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import xreliquary.init.ModItems;
import xreliquary.items.BulletItem;
import xreliquary.items.MagazineItem;
import xreliquary.reference.Settings;
import xreliquary.util.RegistryHelper;
import xreliquary.util.potions.PotionEssence;
import xreliquary.util.potions.PotionMap;
import xreliquary.util.potions.XRPotionHelper;

public class MagazineRecipeMaker {
    private MagazineRecipeMaker() {
    }

    public static List<ShapedRecipe> getRecipes() {
        ArrayList<ShapedRecipe> recipes = new ArrayList<ShapedRecipe>();
        MagazineRecipeMaker.addRegularMagazines(recipes);
        if (Boolean.FALSE.equals(Settings.COMMON.disable.disablePotions.get())) {
            MagazineRecipeMaker.addPotionMagazines(recipes);
        }
        return recipes;
    }

    private static void addRegularMagazines(ArrayList<ShapedRecipe> recipes) {
        ImmutableMap bulletMagazines = new ImmutableMap.Builder().put((Object)((BulletItem)ModItems.NEUTRAL_BULLET.get()), (Object)((MagazineItem)ModItems.NEUTRAL_MAGAZINE.get())).put((Object)((BulletItem)ModItems.EXORCISM_BULLET.get()), (Object)((MagazineItem)ModItems.EXORCISM_MAGAZINE.get())).put((Object)((BulletItem)ModItems.BLAZE_BULLET.get()), (Object)((MagazineItem)ModItems.BLAZE_MAGAZINE.get())).put((Object)((BulletItem)ModItems.ENDER_BULLET.get()), (Object)((MagazineItem)ModItems.ENDER_MAGAZINE.get())).put((Object)((BulletItem)ModItems.CONCUSSIVE_BULLET.get()), (Object)((MagazineItem)ModItems.CONCUSSIVE_MAGAZINE.get())).put((Object)((BulletItem)ModItems.BUSTER_BULLET.get()), (Object)((MagazineItem)ModItems.BUSTER_MAGAZINE.get())).put((Object)((BulletItem)ModItems.SEEKER_BULLET.get()), (Object)((MagazineItem)ModItems.SEEKER_MAGAZINE.get())).put((Object)((BulletItem)ModItems.SAND_BULLET.get()), (Object)((MagazineItem)ModItems.SAND_MAGAZINE.get())).put((Object)((BulletItem)ModItems.STORM_BULLET.get()), (Object)((MagazineItem)ModItems.STORM_MAGAZINE.get())).build();
        for (Map.Entry bulletMagazine : bulletMagazines.entrySet()) {
            NonNullList inputs = NonNullList.func_191196_a();
            MagazineRecipeMaker.addShots((List<Ingredient>)inputs, (BulletItem)bulletMagazine.getKey());
            inputs.add((Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)ModItems.EMPTY_MAGAZINE.get())}));
            MagazineRecipeMaker.addShots((List<Ingredient>)inputs, (BulletItem)bulletMagazine.getKey());
            ItemStack output = new ItemStack((IItemProvider)bulletMagazine.getValue());
            recipes.add(new ShapedRecipe(RegistryHelper.getRegistryName(output.func_77973_b()), "xreliquary.magazine", 3, 3, inputs, output));
        }
    }

    private static void addPotionMagazines(ArrayList<ShapedRecipe> recipes) {
        for (PotionEssence essence : PotionMap.uniquePotions) {
            List<EffectInstance> effects = XRPotionHelper.changePotionEffectsDuration(essence.getEffects(), 0.2f);
            NonNullList inputs = NonNullList.func_191196_a();
            MagazineRecipeMaker.addShots((List<Ingredient>)inputs, effects);
            inputs.add((Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)ModItems.EMPTY_MAGAZINE.get())}));
            MagazineRecipeMaker.addShots((List<Ingredient>)inputs, effects);
            ItemStack output = new ItemStack((IItemProvider)ModItems.NEUTRAL_MAGAZINE.get());
            XRPotionHelper.addPotionEffectsToStack(output, effects);
            recipes.add(new ShapedRecipe(RegistryHelper.getRegistryName(output.func_77973_b()), "xreliquary.potion.magazine", 3, 3, inputs, output));
        }
    }

    private static void addShots(List<Ingredient> inputs, List<EffectInstance> effects) {
        MagazineRecipeMaker.addShots(inputs, effects, (BulletItem)ModItems.NEUTRAL_BULLET.get());
    }

    private static void addShots(List<Ingredient> inputs, BulletItem shotType) {
        MagazineRecipeMaker.addShots(inputs, Collections.emptyList(), shotType);
    }

    private static void addShots(List<Ingredient> inputs, List<EffectInstance> effects, BulletItem shotType) {
        ItemStack shot = new ItemStack((IItemProvider)shotType);
        if (!effects.isEmpty()) {
            XRPotionHelper.addPotionEffectsToStack(shot, effects);
        }
        for (int i = 0; i < 4; ++i) {
            inputs.add(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{shot}));
        }
    }
}

