/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.util;

import com.ldtteam.structurize.Structurize;
import com.ldtteam.structurize.management.Manager;
import com.ldtteam.structurize.util.BlockChangeData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.extensions.IForgeEntity;
import org.jetbrains.annotations.Nullable;

public class ChangeStorage {
    private static int storageIDs = 0;
    private final int id;
    private final Map<BlockPos, BlockChangeData> blocks = new HashMap<BlockPos, BlockChangeData>();
    private final List<CompoundNBT> removedEntities = new ArrayList<CompoundNBT>();
    private final List<Entity> addedEntities = new ArrayList<Entity>();
    private final String operation;
    private Iterator<Map.Entry<BlockPos, BlockChangeData>> iterator = null;
    private final UUID player;

    public ChangeStorage(String operation, UUID player) {
        this.player = player;
        this.id = storageIDs++;
        this.operation = operation;
    }

    public ChangeStorage(World world, BlockPos from, BlockPos to, String operation) {
        this.player = UUID.randomUUID();
        this.id = storageIDs++;
        this.operation = operation;
        for (int x = Math.min(from.func_177958_n(), to.func_177958_n()); x <= Math.max(from.func_177958_n(), to.func_177958_n()); ++x) {
            for (int y = Math.min(from.func_177956_o(), to.func_177956_o()); y <= Math.max(from.func_177956_o(), to.func_177956_o()); ++y) {
                for (int z = Math.min(from.func_177952_p(), to.func_177952_p()); z <= Math.max(from.func_177952_p(), to.func_177952_p()); ++z) {
                    BlockPos place = new BlockPos(x, y, z);
                    this.blocks.put(place, new BlockChangeData().withPreState(world.func_180495_p(place)).withPreTE(world.func_175625_s(place)));
                }
            }
        }
        List tempEntities = world.func_217357_a(Entity.class, new AxisAlignedBB(from, to));
        this.removedEntities.addAll(tempEntities.stream().map(IForgeEntity::serializeNBT).collect(Collectors.toList()));
    }

    public void addPreviousDataFor(BlockPos place, World world) {
        this.blocks.computeIfAbsent(place, p -> new BlockChangeData()).withPreState(world.func_180495_p(place)).withPreTE(world.func_175625_s(place));
    }

    public void addPostDataFor(BlockPos place, World world) {
        this.blocks.computeIfAbsent(place, p -> new BlockChangeData()).withPostState(world.func_180495_p(place)).withPostTE(world.func_175625_s(place));
    }

    public void addEntities(List<Entity> list) {
        this.removedEntities.addAll(list.stream().map(IForgeEntity::serializeNBT).collect(Collectors.toList()));
    }

    public void addToBeKilledEntity(Entity entity) {
        this.addedEntities.add(entity);
    }

    public boolean undo(World world, @Nullable ChangeStorage undoStorage) {
        if (this.iterator == null) {
            this.iterator = this.blocks.entrySet().iterator();
        }
        int count = 0;
        while (this.iterator.hasNext()) {
            Map.Entry<BlockPos, BlockChangeData> entry = this.iterator.next();
            if (world.func_180495_p(entry.getKey()) != entry.getValue().getPostState()) continue;
            if (undoStorage != null) {
                undoStorage.addPreviousDataFor(entry.getKey(), world);
            }
            world.func_175656_a(entry.getKey(), entry.getValue().getPreState());
            if (entry.getValue().getPreTE() != null) {
                world.func_175690_a(entry.getKey(), entry.getValue().getPreTE());
            }
            if (undoStorage != null) {
                undoStorage.addPostDataFor(entry.getKey(), world);
            }
            if (++count < (Integer)Structurize.getConfig().getServer().maxOperationsPerTick.get()) continue;
            return false;
        }
        for (CompoundNBT data : this.removedEntities) {
            Entity entity;
            Optional type = EntityType.func_220347_a((CompoundNBT)data);
            if (!type.isPresent() || (entity = ((EntityType)type.get()).func_200721_a(world)) == null) continue;
            entity.deserializeNBT(data);
            world.func_217376_c(entity);
            if (undoStorage == null) continue;
            undoStorage.addedEntities.add(entity);
        }
        this.addedEntities.forEach(Entity::func_70106_y);
        if (undoStorage != null) {
            Manager.addToUndoRedoCache(undoStorage);
        }
        return true;
    }

    public boolean redo(World world) {
        int count = 0;
        if (this.iterator == null) {
            this.iterator = this.blocks.entrySet().iterator();
        }
        while (this.iterator.hasNext()) {
            Map.Entry<BlockPos, BlockChangeData> entry = this.iterator.next();
            if (world.func_180495_p(entry.getKey()) != entry.getValue().getPreState()) continue;
            world.func_175656_a(entry.getKey(), entry.getValue().getPostState());
            if (entry.getValue().getPostTE() != null) {
                world.func_175690_a(entry.getKey(), entry.getValue().getPostTE());
            }
            if (++count < (Integer)Structurize.getConfig().getServer().maxOperationsPerTick.get()) continue;
            return false;
        }
        return true;
    }

    public String getOperation() {
        return this.operation;
    }

    public void resetUnRedo() {
        this.iterator = null;
    }

    public boolean isDone() {
        return this.iterator == null || !this.iterator.hasNext();
    }

    public int getID() {
        return this.id;
    }

    public UUID getPlayerID() {
        return this.player;
    }
}

