/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.network.messages;

import com.ldtteam.structurize.management.Manager;
import com.ldtteam.structurize.network.messages.IMessage;
import com.ldtteam.structurize.util.TickedWorldOperation;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoveBlockMessage
implements IMessage {
    private final BlockPos from;
    private final BlockPos to;
    private final ItemStack block;

    public RemoveBlockMessage(PacketBuffer buf) {
        this.from = buf.func_179259_c();
        this.to = buf.func_179259_c();
        this.block = buf.func_150791_c();
    }

    public RemoveBlockMessage(@NotNull BlockPos pos1, @NotNull BlockPos pos2, @NotNull ItemStack stack) {
        this.from = pos1;
        this.to = pos2;
        this.block = stack;
    }

    @Override
    public void toBytes(@NotNull PacketBuffer buf) {
        buf.func_179255_a(this.from);
        buf.func_179255_a(this.to);
        buf.func_150788_a(this.block);
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.SERVER;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        if (!ctxIn.getSender().func_184812_l_()) {
            return;
        }
        Manager.addToQueue(new TickedWorldOperation(TickedWorldOperation.OperationType.REMOVE_BLOCK, this.from, this.to, (PlayerEntity)ctxIn.getSender(), this.block, ItemStack.field_190927_a, 100));
    }
}

