/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.management;

import com.ldtteam.structurize.Structurize;
import com.ldtteam.structurize.api.util.Log;
import com.ldtteam.structurize.api.util.MathUtils;
import com.ldtteam.structurize.management.Manager;
import com.ldtteam.structurize.management.StructureName;
import com.ldtteam.structurize.proxy.ClientProxy;
import com.ldtteam.structurize.util.StructureLoadingUtils;
import com.ldtteam.structurize.util.StructureUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.util.ResourceLocationException;
import net.minecraft.util.Tuple;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.forgespi.locating.IModFile;
import org.jetbrains.annotations.NotNull;

public final class Structures {
    public static final String SCHEMATIC_EXTENSION_NEW = ".blueprint";
    public static final String SCHEMATICS_PREFIX = "schematics";
    public static final String SCHEMATICS_CACHE = "cache";
    public static final String SCHEMATICS_SCAN = "scans";
    public static final String SCHEMATICS_ASSET_PATH = "assets";
    public static final String SCHEMATICS_SEPARATOR = "/";
    private static final Map<UUID, Tuple<Long, Map<Integer, byte[]>>> schematicPieces = new HashMap<UUID, Tuple<Long, Map<Integer, byte[]>>>();
    @NotNull
    private static final Map<String, Map<String, Map<String, String>>> schematicsMap = new HashMap<String, Map<String, Map<String, String>>>();
    @NotNull
    private static final Map<String, String> md5Map = new HashMap<String, String>();
    @NotNull
    private static final Map<String, String> fileMap = new HashMap<String, String>();
    private static boolean dirty = false;

    private Structures() {
    }

    public static void init() {
        Structures.loadStyleMaps();
    }

    private static void loadStyleMaps() {
        File schematicsFolder;
        if (!((Boolean)Structurize.getConfig().getServer().ignoreSchematicsFromJar.get()).booleanValue()) {
            for (Map.Entry<String, ModFileInfo> origin : StructureLoadingUtils.getOriginMods().entrySet()) {
                Path path = origin.getValue().getFile().getLocator().findPath((IModFile)origin.getValue().getFile(), new String[]{SCHEMATICS_ASSET_PATH, origin.getKey()});
                Log.getLogger().info("Trying jar discover: {}", (Object)path.toString());
                Structures.loadSchematicsForPrefix(path, SCHEMATICS_PREFIX);
            }
        }
        if ((schematicsFolder = Structurize.proxy.getSchematicsFolder()) != null) {
            Log.getLogger().info("Load additional huts or decorations from " + schematicsFolder + SCHEMATICS_SEPARATOR + SCHEMATICS_PREFIX);
            Structures.checkDirectory(schematicsFolder.toPath().resolve(SCHEMATICS_PREFIX).toFile());
            Structures.loadSchematicsForPrefix(schematicsFolder.toPath(), SCHEMATICS_PREFIX);
        }
        for (File cachedSchems : StructureLoadingUtils.getCachedSchematicsFolders()) {
            if (cachedSchems == null) continue;
            Structures.checkDirectory(cachedSchems);
            Log.getLogger().info("Load cached schematic from " + cachedSchems + SCHEMATICS_SEPARATOR + SCHEMATICS_CACHE);
            Structures.checkDirectory(cachedSchems.toPath().resolve(SCHEMATICS_CACHE).toFile());
            Structures.loadSchematicsForPrefix(cachedSchems.toPath(), SCHEMATICS_CACHE);
        }
        if (md5Map.size() == 0) {
            Log.getLogger().warn("No file found during schematic discover. Things may break!");
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void loadScannedStyleMaps() {
        if (!((Boolean)Structurize.getConfig().getServer().allowPlayerSchematics.get()).booleanValue() && ServerLifecycleHooks.getCurrentServer() == null) {
            return;
        }
        schematicsMap.remove(SCHEMATICS_SCAN);
        for (File clientSchems : StructureLoadingUtils.getClientSchematicsFolders()) {
            Structures.checkDirectory(clientSchems.toPath().resolve(SCHEMATICS_SCAN).toFile());
            Structures.loadSchematicsForPrefix(clientSchems.toPath(), SCHEMATICS_SCAN);
        }
    }

    private static void checkDirectory(@NotNull File directory) {
        if (!directory.exists() && !directory.mkdirs()) {
            Log.getLogger().error("Directory doesn't exist and failed to be created: " + directory.toString());
        }
    }

    private static void loadSchematicsForPrefix(@NotNull Path base, @NotNull String prefix) {
        Path basePath = base.toAbsolutePath();
        if (!Files.exists(basePath.resolve(prefix), new LinkOption[0])) {
            return;
        }
        try (Stream<Path> walk = Files.walk(basePath.resolve(prefix), new FileVisitOption[0]);){
            Iterator it = walk.iterator();
            while (it.hasNext()) {
                Path path = (Path)it.next();
                if (!path.toString().endsWith(SCHEMATIC_EXTENSION_NEW)) continue;
                String relativePath = basePath.relativize(path).toString();
                relativePath = relativePath.substring(0, relativePath.length() - SCHEMATIC_EXTENSION_NEW.length());
                if (!SCHEMATICS_SEPARATOR.equals(path.getFileSystem().getSeparator())) {
                    relativePath = relativePath.replace(path.getFileSystem().getSeparator(), SCHEMATICS_SEPARATOR);
                }
                if (relativePath.startsWith(SCHEMATICS_SEPARATOR)) {
                    relativePath = relativePath.substring(1);
                }
                try {
                    StructureName structureName = new StructureName(relativePath);
                    fileMap.put(structureName.toString(), SCHEMATIC_EXTENSION_NEW);
                    byte[] structureBytes = StructureLoadingUtils.getByteArray(relativePath);
                    String md5 = StructureUtils.calculateMD5(structureBytes);
                    if (md5 == null) {
                        fileMap.remove(structureName.toString());
                        Log.getLogger().error("Structures: " + structureName + " with md5 null.");
                        continue;
                    }
                    if (!Structures.isSchematicSizeValid(structureBytes)) continue;
                    md5Map.put(structureName.toString(), md5);
                    if (!(Structurize.proxy instanceof ClientProxy)) continue;
                    Structures.addSchematic(structureName);
                }
                catch (ResourceLocationException e) {
                    Log.getLogger().warn("Structure failed Loading because of invalid resource name (probably capitalization issue)", (Throwable)e);
                    Log.getLogger().warn(relativePath);
                }
            }
        }
        catch (IOException e) {
            Log.getLogger().warn("loadSchematicsForPrefix: Could not load schematics from " + basePath.resolve(prefix), (Throwable)e);
        }
    }

    private static boolean isSchematicSizeValid(@NotNull byte[] structureData) {
        byte[] compressed = StructureUtils.compress(structureData);
        if (compressed == null) {
            Log.getLogger().warn("Compressed structure returned null, please retry, this shouldn't happen, ever.");
            return false;
        }
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void addSchematic(@NotNull StructureName structureName) {
        Map<String, Map<String, String>> sectionMap;
        if (structureName.getPrefix().equals(SCHEMATICS_CACHE)) {
            return;
        }
        if (!schematicsMap.containsKey(structureName.getSection())) {
            schematicsMap.put(structureName.getSection(), new HashMap());
        }
        if (!(sectionMap = schematicsMap.get(structureName.getSection())).containsKey(structureName.getStyle())) {
            sectionMap.put(structureName.getStyle(), new TreeMap());
        }
        Map<String, String> styleMap = sectionMap.get(structureName.getStyle());
        styleMap.put(structureName.getSchematic(), structureName.toString());
    }

    public static boolean isDirty() {
        return dirty;
    }

    public static void clearDirty() {
        dirty = false;
    }

    @Deprecated
    public static boolean isPlayerSchematicsAllowed() {
        return (Boolean)Structurize.getConfig().getServer().allowPlayerSchematics.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static StructureName renameScannedStructure(@NotNull StructureName structureName, @NotNull String name) {
        if (!SCHEMATICS_SCAN.equals(structureName.getPrefix())) {
            Log.getLogger().warn("Renamed failed: Invalid name " + structureName);
            return null;
        }
        if (!Structures.hasMD5(structureName)) {
            Log.getLogger().warn("Renamed failed: No MD5 hash found for " + structureName);
            return null;
        }
        StructureName newStructureName = new StructureName("scans/" + name);
        if (!Structures.hasMD5(structureName)) {
            Log.getLogger().warn("Renamed failed: File already exist " + newStructureName);
            return null;
        }
        for (File clientSchems : StructureLoadingUtils.getClientSchematicsFolders()) {
            File structureFile = clientSchems.toPath().resolve(structureName.toString() + Structures.getFileExtension(structureName.toString())).toFile();
            File newStructureFile = clientSchems.toPath().resolve(newStructureName.toString() + Structures.getFileExtension(structureName.toString())).toFile();
            Structures.checkDirectory(newStructureFile.getParentFile());
            if (structureFile.renameTo(newStructureFile)) {
                String md5 = Structures.getMD5(structureName.toString());
                md5Map.put(newStructureName.toString(), md5);
                md5Map.remove(structureName.toString());
                fileMap.put(newStructureName.toString(), fileMap.get(structureName.toString()));
                fileMap.remove(structureName.toString());
                Log.getLogger().info("Structure " + structureName + " have been renamed " + newStructureName);
                return newStructureName;
            }
            Log.getLogger().warn("Failed to rename structure from " + structureName + " to " + newStructureName);
            Log.getLogger().warn("Failed to rename structure from " + structureFile + " to " + newStructureFile);
        }
        return null;
    }

    public static boolean hasMD5(@NotNull StructureName structureName) {
        return Structures.hasMD5(structureName.toString());
    }

    public static String getMD5(@NotNull String structureName) {
        if (!md5Map.containsKey(structureName)) {
            return null;
        }
        return md5Map.get(structureName);
    }

    public static boolean hasMD5(@NotNull String structureName) {
        return md5Map.containsKey(structureName);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean deleteScannedStructure(@NotNull StructureName structureName) {
        if (!SCHEMATICS_SCAN.equals(structureName.getPrefix())) {
            Log.getLogger().warn("Delete failed: Invalid name " + structureName);
            return false;
        }
        if (!Structures.hasMD5(structureName)) {
            Log.getLogger().warn("Delete failed: No MD5 hash found for " + structureName);
            return false;
        }
        for (File clientSchems : StructureLoadingUtils.getClientSchematicsFolders()) {
            File structureFile = clientSchems.toPath().resolve(structureName.toString() + SCHEMATIC_EXTENSION_NEW).toFile();
            if (structureFile.delete()) {
                md5Map.remove(structureName.toString());
                Log.getLogger().info("Structures: " + structureName + " deleted successfully");
                return true;
            }
            Log.getLogger().warn("Failed to delete structure " + structureName);
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    @NotNull
    public static List<String> getSections() {
        ArrayList<String> list = new ArrayList<String>(schematicsMap.keySet());
        Collections.sort(list);
        return list;
    }

    @OnlyIn(value=Dist.CLIENT)
    @NotNull
    public static List<String> getStylesFor(String section) {
        if (schematicsMap.containsKey(section)) {
            Map<String, Map<String, String>> sectionMap = schematicsMap.get(section);
            return sectionMap.keySet().stream().filter(str -> !str.endsWith("/miner")).sorted().collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @OnlyIn(value=Dist.CLIENT)
    @NotNull
    public static List<String> getSchematicsFor(String section, String style) {
        Map<String, Map<String, String>> sectionMap;
        if (schematicsMap.containsKey(section) && (sectionMap = schematicsMap.get(section)).containsKey(style)) {
            ArrayList<String> list = new ArrayList<String>(sectionMap.get(style).values());
            Collections.sort(list);
            return list;
        }
        return Collections.emptyList();
    }

    public static StructureName getStructureNameByMD5(String md5) {
        if (md5 != null) {
            for (Map.Entry<String, String> md5Entry : md5Map.entrySet()) {
                if (!md5Entry.getValue().equals(md5)) continue;
                return new StructureName(md5Entry.getKey());
            }
        }
        return null;
    }

    public static String getFileExtension(String structureName) {
        if (!fileMap.containsKey(structureName)) {
            return null;
        }
        return fileMap.get(structureName);
    }

    public static Map<String, String> getMD5s() {
        return md5Map;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void setMD5s(Map<String, String> md5s) {
        schematicsMap.entrySet().removeIf(entry -> !((String)entry.getKey()).equals(SCHEMATICS_SCAN));
        for (Map.Entry<String, String> md5 : md5s.entrySet()) {
            StructureName sn = new StructureName(md5.getKey());
            if (sn.getSection().equals(SCHEMATICS_SCAN)) continue;
            md5Map.put(md5.getKey(), md5.getValue());
            Structures.addSchematic(sn);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean handleSaveSchematicMessage(byte[] bytes, UUID id, int pieces, int piece) {
        Map<Integer, byte[]> schemPieces;
        for (Map.Entry<UUID, Tuple<Long, Map<Integer, byte[]>>> entry2 : new HashSet<Map.Entry<UUID, Tuple<Long, Map<Integer, byte[]>>>>(schematicPieces.entrySet())) {
            if (MathUtils.nanoSecondsToSeconds(System.nanoTime() - (Long)entry2.getValue().func_76341_a()) <= 60L) continue;
            schematicPieces.remove(entry2.getKey());
            Log.getLogger().warn("Waiting too long for piece of structure, discarding it");
        }
        if (pieces == 1) {
            return Structures.handleSaveSchematicMessage(bytes, false);
        }
        if (!Structures.canStoreNewSchematic(false)) {
            Log.getLogger().warn("Could not store schematic in cache");
            return false;
        }
        Log.getLogger().info("Recieved piece: " + piece + " of: " + pieces + " with the size: " + bytes.length + " and ID: " + id.toString());
        if (schematicPieces.containsKey(id)) {
            Tuple<Long, Map<Integer, byte[]>> schemTuple = schematicPieces.remove(id);
            schemPieces = (Map)schemTuple.func_76340_b();
            if (MathUtils.nanoSecondsToSeconds(System.nanoTime() - (Long)schemTuple.func_76341_a()) > 60L) {
                Log.getLogger().warn("Waiting too long for piece: " + piece);
                return false;
            }
            if (schemPieces.containsKey(piece)) {
                Log.getLogger().warn("Already had piece: " + piece);
                return false;
            }
            schemPieces.put(piece, bytes);
            if (schemPieces.size() == pieces) {
                try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                    schemPieces.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> {
                        try {
                            outputStream.write((byte[])entry.getValue());
                        }
                        catch (IOException e) {
                            Log.getLogger().error("Error combining byte arrays of schematic pieces.", (Throwable)e);
                        }
                    });
                    boolean bl = Structures.handleSaveSchematicMessage(outputStream.toByteArray(), false);
                    return bl;
                }
                catch (IOException e) {
                    Log.getLogger().error("Error combining byte arrays of schematic pieces.", (Throwable)e);
                    return false;
                }
            }
        } else {
            schemPieces = new HashMap<Integer, byte[]>();
            schemPieces.put(piece, bytes);
        }
        schematicPieces.put(id, (Tuple<Long, Map<Integer, byte[]>>)new Tuple((Object)System.nanoTime(), schemPieces));
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean handleSaveSchematicMessage(byte[] bytes, boolean safe) {
        if (!Structures.canStoreNewSchematic(safe)) {
            Log.getLogger().warn("Could not store schematic in cache");
            return false;
        }
        String md5 = StructureUtils.calculateMD5(bytes);
        if (md5 == null) {
            Log.getLogger().info("Structures.handleSaveSchematicMessage: Could not calculate the MD5 hash");
            return false;
        }
        Log.getLogger().info("Structures.handleSaveSchematicMessage: received new schematic md5:" + md5);
        Iterator<File> iterator = StructureLoadingUtils.getCachedSchematicsFolders().iterator();
        while (iterator.hasNext()) {
            File cachedSchems = iterator.next();
            File schematicFile = cachedSchems.toPath().resolve("cache/" + md5 + SCHEMATIC_EXTENSION_NEW).toFile();
            Structures.checkDirectory(schematicFile.getParentFile());
            try (FileOutputStream outputstream = new FileOutputStream(schematicFile);){
                ((OutputStream)outputstream).write(bytes);
                Structures.addMD5ToCache(md5);
                Manager.setSchematicDownloaded(true);
                fileMap.put("cache/" + md5, SCHEMATIC_EXTENSION_NEW);
                boolean bl = true;
                return bl;
            }
            catch (IOException e) {
                Log.getLogger().warn("Exception while trying to save a schematic.", (Throwable)e);
            }
        }
        return false;
    }

    private static boolean canStoreNewSchematic(boolean safe) {
        if (Structurize.proxy instanceof ClientProxy) {
            return true;
        }
        if (!safe && !((Boolean)Structurize.getConfig().getServer().allowPlayerSchematics.get()).booleanValue()) {
            return false;
        }
        int maxCachedSchematics = (Integer)Structurize.getConfig().getServer().maxCachedSchematics.get();
        Set<String> md5Set = Structures.getCachedMD5s();
        if (md5Set.size() < maxCachedSchematics) {
            return true;
        }
        Iterator<String> iterator = md5Set.iterator();
        while (iterator.hasNext() && md5Set.size() >= maxCachedSchematics) {
            StructureName sn = new StructureName(iterator.next());
            if (!Structures.deleteCachedStructure(sn)) continue;
            iterator.remove();
        }
        return md5Set.size() < maxCachedSchematics;
    }

    public static void addMD5ToCache(@NotNull String md5) {
        Structures.markDirty();
        md5Map.put("cache/" + md5, md5);
    }

    private static Set<String> getCachedMD5s() {
        HashSet<String> md5Set = new HashSet<String>();
        for (Map.Entry<String, String> md5 : md5Map.entrySet()) {
            StructureName sn = new StructureName(md5.getKey());
            if (!sn.getSection().equals(SCHEMATICS_CACHE)) continue;
            md5Set.add(md5.getKey());
        }
        return md5Set;
    }

    private static boolean deleteCachedStructure(@NotNull StructureName structureName) {
        if (!SCHEMATICS_CACHE.equals(structureName.getPrefix())) {
            Log.getLogger().warn("Delete failed: Invalid name " + structureName);
            return false;
        }
        if (!Structures.hasMD5(structureName)) {
            Log.getLogger().warn("Delete failed: No MD5 hash found for " + structureName);
            return false;
        }
        File structureFileBlueprint = Structurize.proxy.getSchematicsFolder().toPath().resolve(structureName.toString() + SCHEMATIC_EXTENSION_NEW).toFile();
        if (structureFileBlueprint.delete()) {
            md5Map.remove(structureName.toString());
            fileMap.remove(structureName.toString());
            return true;
        }
        Log.getLogger().warn("Failed to delete structure " + structureName);
        return false;
    }

    private static void markDirty() {
        dirty = true;
    }
}

