/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.items;

import com.ldtteam.structures.blueprints.v1.Blueprint;
import com.ldtteam.structures.blueprints.v1.BlueprintUtil;
import com.ldtteam.structures.helpers.Settings;
import com.ldtteam.structurize.Network;
import com.ldtteam.structurize.Structurize;
import com.ldtteam.structurize.api.util.BlockPosUtil;
import com.ldtteam.structurize.api.util.Log;
import com.ldtteam.structurize.api.util.Utils;
import com.ldtteam.structurize.blocks.interfaces.IBlueprintDataProvider;
import com.ldtteam.structurize.client.gui.WindowScan;
import com.ldtteam.structurize.items.AbstractItemWithPosSelector;
import com.ldtteam.structurize.items.ModItems;
import com.ldtteam.structurize.management.StructureName;
import com.ldtteam.structurize.network.messages.SaveScanMessage;
import com.ldtteam.structurize.util.LanguageHandler;
import com.ldtteam.structurize.util.StructureLoadingUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class ItemScanTool
extends AbstractItemWithPosSelector {
    private static final String ANCHOR_POS_TKEY = "item.possetter.anchorpos";
    private static final String NBT_ANCHOR_POS = "structurize:anchor_pos";

    public ItemScanTool(ItemGroup itemGroup) {
        this(new Item.Properties().func_200918_c(0).setNoRepair().func_208103_a(Rarity.UNCOMMON).func_200916_a(itemGroup));
    }

    public ItemScanTool(Item.Properties properties) {
        super(properties);
    }

    @Override
    public ActionResultType onAirRightClick(BlockPos start, BlockPos end, World worldIn, PlayerEntity playerIn, ItemStack itemStack) {
        Optional<BlockPos> anchorPos = Optional.empty();
        if (itemStack.func_196082_o().func_74764_b(NBT_ANCHOR_POS)) {
            BlockPos anchorBlockPos = NBTUtil.func_186861_c((CompoundNBT)itemStack.func_196082_o().func_74775_l(NBT_ANCHOR_POS));
            if (BlockPosUtil.isInbetween(anchorBlockPos, start, end)) {
                anchorPos = Optional.of(anchorBlockPos);
                if (worldIn.field_72995_K) {
                    Settings.instance.setAnchorPos(anchorPos);
                }
            } else if (worldIn.field_72995_K) {
                playerIn.func_145747_a((ITextComponent)new TranslationTextComponent("com.ldtteam.structurize.gui.scantool.outsideanchor"), playerIn.func_110124_au());
            }
        }
        if (!worldIn.field_72995_K) {
            if (playerIn.func_225608_bj_()) {
                ItemScanTool.saveStructure(worldIn, start, end, playerIn, null, true, anchorPos);
            }
        } else if (!playerIn.func_225608_bj_()) {
            WindowScan window = new WindowScan(start, end, anchorPos);
            window.open();
        }
        return ActionResultType.SUCCESS;
    }

    @Override
    public AbstractItemWithPosSelector getRegisteredItemInstance() {
        return (AbstractItemWithPosSelector)ModItems.scanTool.get();
    }

    public static void saveStructure(@NotNull World world, @NotNull BlockPos from, @NotNull BlockPos to, @NotNull PlayerEntity player, String name) {
        ItemScanTool.saveStructure(world, from, to, player, name, true, Optional.empty());
    }

    public static void saveStructure(@NotNull World world, @NotNull BlockPos from, @NotNull BlockPos to, @NotNull PlayerEntity player, String name, boolean saveEntities, Optional<BlockPos> anchorPos) {
        List list;
        if (anchorPos.isPresent() && !BlockPosUtil.isInbetween(anchorPos.get(), from, to)) {
            LanguageHandler.sendPlayerMessage(player, "item.sceptersteel.badanchorpos", new Object[0]);
            return;
        }
        BlockPos blockpos = new BlockPos(Math.min(from.func_177958_n(), to.func_177958_n()), Math.min(from.func_177956_o(), to.func_177956_o()), Math.min(from.func_177952_p(), to.func_177952_p()));
        BlockPos blockpos1 = new BlockPos(Math.max(from.func_177958_n(), to.func_177958_n()), Math.max(from.func_177956_o(), to.func_177956_o()), Math.max(from.func_177952_p(), to.func_177952_p()));
        BlockPos size = blockpos1.func_177973_b((Vector3i)blockpos).func_177982_a(1, 1, 1);
        if (size.func_177958_n() * size.func_177956_o() * size.func_177952_p() > (Integer)Structurize.getConfig().getServer().schematicBlockLimit.get()) {
            LanguageHandler.sendPlayerMessage(player, "item.sceptersteel.toobig", Structurize.getConfig().getServer().schematicBlockLimit.get());
            return;
        }
        long currentMillis = System.currentTimeMillis();
        String currentMillisString = Long.toString(currentMillis);
        String fileName = name == null || name.isEmpty() ? LanguageHandler.format("item.sceptersteel.scanformat", "", currentMillisString) : name;
        Blueprint bp = BlueprintUtil.createBlueprint(world, blockpos, saveEntities, (short)size.func_177958_n(), (short)size.func_177956_o(), (short)size.func_177952_p(), fileName, anchorPos);
        if (!anchorPos.isPresent() && bp.getPrimaryBlockOffset().equals((Object)new BlockPos(bp.getSizeX() / 2, 0, bp.getSizeZ() / 2)) && (list = bp.getBlockInfoAsList().stream().filter(blockInfo -> blockInfo.hasTileEntityData() && blockInfo.getTileEntityData().func_74764_b("blueprintDataProvider")).collect(Collectors.toList())).size() > 1) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("com.ldtteam.structurize.gui.scantool.scanbadanchor", new Object[]{fileName}), player.func_110124_au());
        }
        Network.getNetwork().sendToPlayer(new SaveScanMessage(BlueprintUtil.writeBlueprintToNBT(bp), fileName), (ServerPlayerEntity)player);
    }

    public static boolean saveStructureOnServer(@NotNull World world, @NotNull BlockPos from, @NotNull BlockPos to, String name) {
        return ItemScanTool.saveStructureOnServer(world, from, to, name, true);
    }

    public static boolean saveStructureOnServer(@NotNull World world, @NotNull BlockPos from, @NotNull BlockPos to, String name, boolean saveEntities) {
        BlockPos blockpos = new BlockPos(Math.min(from.func_177958_n(), to.func_177958_n()), Math.min(from.func_177956_o(), to.func_177956_o()), Math.min(from.func_177952_p(), to.func_177952_p()));
        BlockPos blockpos1 = new BlockPos(Math.max(from.func_177958_n(), to.func_177958_n()), Math.max(from.func_177956_o(), to.func_177956_o()), Math.max(from.func_177952_p(), to.func_177952_p()));
        BlockPos size = blockpos1.func_177973_b((Vector3i)blockpos).func_177982_a(1, 1, 1);
        if (size.func_177958_n() * size.func_177956_o() * size.func_177952_p() > (Integer)Structurize.getConfig().getServer().schematicBlockLimit.get()) {
            Log.getLogger().warn("Saving too large schematic for:" + name);
        }
        String prefix = "cache";
        String fileName = name == null || name.isEmpty() ? LanguageHandler.format("item.sceptersteel.scanformat", new Object[0]) : name;
        StructureName structureName = new StructureName("cache", "backup", fileName);
        List<File> folder = StructureLoadingUtils.getCachedSchematicsFolders();
        if (folder == null || folder.isEmpty()) {
            Log.getLogger().warn("Unable to save schematic in cache since no folder was found.");
            return false;
        }
        Blueprint bp = BlueprintUtil.createBlueprint(world, blockpos, saveEntities, (short)size.func_177958_n(), (short)size.func_177956_o(), (short)size.func_177952_p(), name, Optional.empty());
        File file = new File(folder.get(0), structureName.toString() + ".blueprint");
        Utils.checkDirectory(file.getParentFile());
        try (FileOutputStream outputstream = new FileOutputStream(file);){
            CompressedStreamTools.func_74799_a((CompoundNBT)BlueprintUtil.writeBlueprintToNBT(bp), (OutputStream)outputstream);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean func_195938_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player) {
        TileEntity te;
        ItemStack itemstack;
        if (!player.func_225608_bj_()) {
            return super.func_195938_a(state, worldIn, pos, player);
        }
        if (worldIn.func_201670_d()) {
            LanguageHandler.sendMessageToPlayer(player, ANCHOR_POS_TKEY, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        if (!(itemstack = player.func_184614_ca()).func_77973_b().equals((Object)this.getRegisteredItemInstance())) {
            itemstack = player.func_184592_cb();
        }
        if ((te = worldIn.func_175625_s(pos)) instanceof IBlueprintDataProvider && !((IBlueprintDataProvider)te).getSchematicName().isEmpty()) {
            if (worldIn.field_72995_K) {
                Settings.instance.setAnchorPos(Optional.of(pos));
            }
            BlockPos start = (BlockPos)((IBlueprintDataProvider)te).getInWorldCorners().func_76341_a();
            BlockPos end = (BlockPos)((IBlueprintDataProvider)te).getInWorldCorners().func_76340_b();
            if (!start.equals((Object)pos) && !end.equals((Object)pos)) {
                if (worldIn.field_72995_K) {
                    Settings.instance.setBox(((IBlueprintDataProvider)te).getInWorldCorners());
                }
                itemstack.func_196082_o().func_218657_a("structurize:start_pos", (INBT)NBTUtil.func_186859_a((BlockPos)start));
                itemstack.func_196082_o().func_218657_a("structurize:end_pos", (INBT)NBTUtil.func_186859_a((BlockPos)end));
                if (player instanceof ServerPlayerEntity) {
                    ((ServerPlayerEntity)player).func_71110_a((Container)player.field_71069_bz, player.field_71071_by.field_70462_a);
                }
            }
        }
        itemstack.func_196082_o().func_218657_a(NBT_ANCHOR_POS, (INBT)NBTUtil.func_186859_a((BlockPos)pos));
        return false;
    }
}

