/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.client.gui;

import com.ldtteam.blockout.Color;
import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.controls.Button;
import com.ldtteam.blockout.controls.ItemIcon;
import com.ldtteam.blockout.controls.Text;
import com.ldtteam.blockout.controls.TextField;
import com.ldtteam.blockout.views.ScrollingList;
import com.ldtteam.blockout.views.Window;
import com.ldtteam.structures.helpers.Settings;
import com.ldtteam.structurize.Network;
import com.ldtteam.structurize.api.util.ItemStackUtils;
import com.ldtteam.structurize.api.util.ItemStorage;
import com.ldtteam.structurize.blocks.interfaces.IBlueprintDataProvider;
import com.ldtteam.structurize.client.gui.AbstractWindowSkeleton;
import com.ldtteam.structurize.client.gui.WindowReplaceBlock;
import com.ldtteam.structurize.client.gui.WindowUndoRedo;
import com.ldtteam.structurize.network.messages.RemoveBlockMessage;
import com.ldtteam.structurize.network.messages.RemoveEntityMessage;
import com.ldtteam.structurize.network.messages.ScanOnServerMessage;
import com.ldtteam.structurize.network.messages.UpdateScanToolMessage;
import com.ldtteam.structurize.util.BlockUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.block.BedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoorBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BedPart;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WindowScan
extends AbstractWindowSkeleton {
    private static final String BUILDING_NAME_RESOURCE_SUFFIX = ":gui/windowscantool.xml";
    private final Map<String, ItemStorage> resources = new HashMap<String, ItemStorage>();
    private final Map<String, Entity> entities = new HashMap<String, Entity>();
    public static final int WHITE = Color.getByName("white", 0);
    private BlockPos pos1;
    private BlockPos pos2;
    private Optional<BlockPos> anchorPos;
    private String filter = "";
    private final TextField pos1x;
    private final TextField pos1y;
    private final TextField pos1z;
    private final TextField pos2x;
    private final TextField pos2y;
    private final TextField pos2z;
    private final ScrollingList resourceList;
    private final ScrollingList entityList;

    public WindowScan(BlockPos pos1, BlockPos pos2, Optional<BlockPos> anchorPos) {
        super("structurize:gui/windowscantool.xml");
        this.pos1 = pos1;
        this.pos2 = pos2;
        this.anchorPos = anchorPos;
        this.registerButton("confirm", this::confirmClicked);
        this.registerButton("cancel", this::discardClicked);
        this.registerButton("showRes", this::showResClicked);
        this.registerButton("removeEntity", this::removeEntity);
        this.registerButton("removeBlock", this::removeBlock);
        this.registerButton("replaceBlock", this::replaceBlock);
        this.registerButton("undoredo", (Button b) -> {
            this.close();
            new WindowUndoRedo().open();
        });
        this.pos1x = this.findPaneOfTypeByID("pos1x", TextField.class);
        this.pos1y = this.findPaneOfTypeByID("pos1y", TextField.class);
        this.pos1z = this.findPaneOfTypeByID("pos1z", TextField.class);
        this.pos2x = this.findPaneOfTypeByID("pos2x", TextField.class);
        this.pos2y = this.findPaneOfTypeByID("pos2y", TextField.class);
        this.pos2z = this.findPaneOfTypeByID("pos2z", TextField.class);
        this.resourceList = this.findPaneOfTypeByID("resources", ScrollingList.class);
        this.entityList = this.findPaneOfTypeByID("entities", ScrollingList.class);
    }

    private void showResClicked() {
        this.findPaneOfTypeByID("filter", TextField.class).show();
        this.findPaneOfTypeByID("showRes", Button.class).hide();
        this.updateResources();
    }

    private void removeEntity(Button button) {
        int x1 = Integer.parseInt(this.pos1x.getText());
        int y1 = Integer.parseInt(this.pos1y.getText());
        int z1 = Integer.parseInt(this.pos1z.getText());
        int x2 = Integer.parseInt(this.pos2x.getText());
        int y2 = Integer.parseInt(this.pos2y.getText());
        int z2 = Integer.parseInt(this.pos2z.getText());
        int row = this.entityList.getListElementIndexByPane(button);
        Entity entity = new ArrayList<Entity>(this.entities.values()).get(row);
        Network.getNetwork().sendToServer(new RemoveEntityMessage(new BlockPos(x1, y1, z1), new BlockPos(x2, y2, z2), entity.func_200200_C_().getString()));
        this.entities.remove(entity.func_200200_C_().getString());
        this.updateEntitylist();
    }

    private void removeBlock(Button button) {
        int x1 = Integer.parseInt(this.pos1x.getText());
        int y1 = Integer.parseInt(this.pos1y.getText());
        int z1 = Integer.parseInt(this.pos1z.getText());
        int x2 = Integer.parseInt(this.pos2x.getText());
        int y2 = Integer.parseInt(this.pos2y.getText());
        int z2 = Integer.parseInt(this.pos2z.getText());
        int row = this.resourceList.getListElementIndexByPane(button);
        ArrayList<ItemStorage> tempRes = new ArrayList<ItemStorage>(this.resources.values());
        ItemStack stack = ((ItemStorage)tempRes.get(row)).getItemStack();
        Network.getNetwork().sendToServer(new RemoveBlockMessage(new BlockPos(x1, y1, z1), new BlockPos(x2, y2, z2), stack));
        int hashCode = stack.func_77942_o() ? stack.func_77978_p().hashCode() : 0;
        this.resources.remove(stack.func_77977_a() + ":" + stack.func_77952_i() + "-" + hashCode);
        this.updateResourceList();
    }

    private void replaceBlock(Button button) {
        int x1 = Integer.parseInt(this.pos1x.getText());
        int y1 = Integer.parseInt(this.pos1y.getText());
        int z1 = Integer.parseInt(this.pos1z.getText());
        int x2 = Integer.parseInt(this.pos2x.getText());
        int y2 = Integer.parseInt(this.pos2y.getText());
        int z2 = Integer.parseInt(this.pos2z.getText());
        int row = this.resourceList.getListElementIndexByPane(button);
        ArrayList<ItemStorage> tempRes = new ArrayList<ItemStorage>(this.resources.values());
        new WindowReplaceBlock(((ItemStorage)tempRes.get(row)).getItemStack(), new BlockPos(x1, y1, z1), new BlockPos(x2, y2, z2), (Window)this).open();
    }

    @Override
    public void onOpened() {
        TileEntity tile;
        super.onOpened();
        if (!Minecraft.func_71410_x().field_71439_g.func_184812_l_()) {
            this.pos1x.disable();
            this.pos1y.disable();
            this.pos1z.disable();
            this.pos2x.disable();
            this.pos2y.disable();
            this.pos2z.disable();
        }
        this.pos1x.setText(String.valueOf(this.pos1.func_177958_n()));
        this.pos1y.setText(String.valueOf(this.pos1.func_177956_o()));
        this.pos1z.setText(String.valueOf(this.pos1.func_177952_p()));
        this.pos2x.setText(String.valueOf(this.pos2.func_177958_n()));
        this.pos2y.setText(String.valueOf(this.pos2.func_177956_o()));
        this.pos2z.setText(String.valueOf(this.pos2.func_177952_p()));
        Settings.instance.setAnchorPos(this.anchorPos);
        Settings.instance.setBox((Tuple<BlockPos, BlockPos>)new Tuple((Object)this.pos1, (Object)this.pos2));
        if (this.anchorPos.isPresent() && (tile = Minecraft.func_71410_x().field_71439_g.field_70170_p.func_175625_s(this.anchorPos.get())) instanceof IBlueprintDataProvider && !((IBlueprintDataProvider)tile).getSchematicName().isEmpty()) {
            this.findPaneOfTypeByID("name", TextField.class).setText(((IBlueprintDataProvider)tile).getSchematicName());
        }
        this.findPaneOfTypeByID("filter", TextField.class).setHandler(input -> {
            String name = this.findPaneOfTypeByID("filter", TextField.class).getText();
            if (!name.isEmpty()) {
                this.filter = name;
            }
            this.updateResources();
        });
    }

    private void discardClicked() {
        Settings.instance.setAnchorPos(Optional.empty());
        Settings.instance.setBox(null);
        this.close();
    }

    private void confirmClicked() {
        String name = this.findPaneOfTypeByID("name", TextField.class).getText();
        int x1 = Integer.parseInt(this.pos1x.getText());
        int y1 = Integer.parseInt(this.pos1y.getText());
        int z1 = Integer.parseInt(this.pos1z.getText());
        int x2 = Integer.parseInt(this.pos2x.getText());
        int y2 = Integer.parseInt(this.pos2y.getText());
        int z2 = Integer.parseInt(this.pos2z.getText());
        Network.getNetwork().sendToServer(new ScanOnServerMessage(new BlockPos(x1, y1, z1), new BlockPos(x2, y2, z2), name, true, Settings.instance.getAnchorPos()));
        Settings.instance.setAnchorPos(Optional.empty());
        Settings.instance.setBox(null);
        Settings.instance.setStructureName(null);
        this.close();
    }

    private void updateResources() {
        BlockPos def = Minecraft.func_71410_x().field_71439_g.func_233580_cy_();
        try {
            int x1 = this.pos1x.getText().isEmpty() ? def.func_177958_n() : Integer.parseInt(this.pos1x.getText());
            int y1 = this.pos1y.getText().isEmpty() ? def.func_177956_o() : Integer.parseInt(this.pos1y.getText());
            int z1 = this.pos1z.getText().isEmpty() ? def.func_177952_p() : Integer.parseInt(this.pos1z.getText());
            this.pos1 = new BlockPos(x1, y1, z1);
            int x2 = this.pos2x.getText().isEmpty() ? def.func_177958_n() : Integer.parseInt(this.pos2x.getText());
            int y2 = this.pos2y.getText().isEmpty() ? def.func_177956_o() : Integer.parseInt(this.pos2y.getText());
            int z2 = this.pos2z.getText().isEmpty() ? def.func_177952_p() : Integer.parseInt(this.pos2z.getText());
            this.pos2 = new BlockPos(x2, y2, z2);
        }
        catch (NumberFormatException e) {
            Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new StringTextComponent("Invalid Number - Closing!"), Minecraft.func_71410_x().field_71439_g.func_110124_au());
            this.close();
            return;
        }
        Settings.instance.setAnchorPos(this.anchorPos);
        Settings.instance.setBox((Tuple<BlockPos, BlockPos>)new Tuple((Object)this.pos1, (Object)this.pos2));
        Network.getNetwork().sendToServer(new UpdateScanToolMessage(this.pos1, this.pos2));
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        this.resources.clear();
        this.entities.clear();
        if (this.findPaneByID("showRes").isVisible()) {
            return;
        }
        for (int x = Math.min(this.pos1.func_177958_n(), this.pos2.func_177958_n()); x <= Math.max(this.pos1.func_177958_n(), this.pos2.func_177958_n()); ++x) {
            for (int y = Math.min(this.pos1.func_177956_o(), this.pos2.func_177956_o()); y <= Math.max(this.pos1.func_177956_o(), this.pos2.func_177956_o()); ++y) {
                for (int z = Math.min(this.pos1.func_177952_p(), this.pos2.func_177952_p()); z <= Math.max(this.pos1.func_177952_p(), this.pos2.func_177952_p()); ++z) {
                    BlockPos here = new BlockPos(x, y, z);
                    BlockState blockState = world.func_180495_p(here);
                    TileEntity tileEntity = world.func_175625_s(here);
                    List list = world.func_217357_a(Entity.class, new AxisAlignedBB(here));
                    for (Entity entity : list) {
                        if (this.entities.containsKey(entity.func_200200_C_().getString()) || !entity.func_200600_R().func_200715_a() && !entity.func_200600_R().equals(EntityType.field_200768_H) || !this.filter.isEmpty() && !entity.func_200200_C_().getString().toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US)) && !entity.toString().toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US))) continue;
                        this.entities.put(entity.func_200200_C_().getString(), entity);
                    }
                    @Nullable Block block = blockState.func_177230_c();
                    if (block == null) continue;
                    if (tileEntity != null) {
                        try {
                            ArrayList<ItemStack> itemList = new ArrayList<ItemStack>(ItemStackUtils.getItemStacksOfTileEntity(tileEntity.func_189515_b(new CompoundNBT()), blockState));
                            for (ItemStack stack : itemList) {
                                this.addNeededResource(stack, 1);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (block instanceof BedBlock && blockState.func_177229_b((Property)BedBlock.field_176472_a) == BedPart.HEAD || block instanceof DoorBlock && blockState.func_177229_b((Property)DoorBlock.field_176523_O) == DoubleBlockHalf.UPPER) continue;
                    if (block == Blocks.field_150350_a) {
                        this.addNeededResource(new ItemStack((IItemProvider)Blocks.field_150350_a, 1), 1);
                        continue;
                    }
                    this.addNeededResource(BlockUtils.getItemStackFromBlockState(blockState), 1);
                }
            }
        }
        this.window.findPaneOfTypeByID("resources", ScrollingList.class).refreshElementPanes();
        this.updateResourceList();
        this.updateEntitylist();
    }

    public void addNeededResource(@Nullable ItemStack res, int amount) {
        if (res == null || amount == 0) {
            return;
        }
        int hashCode = res.func_77942_o() ? res.func_77978_p().hashCode() : 0;
        ItemStorage resource = this.resources.get(res.func_77977_a() + ":" + res.func_77952_i() + "-" + hashCode);
        if (resource == null) {
            resource = new ItemStorage(res);
            resource.setAmount(amount);
        } else {
            resource.setAmount(resource.getAmount() + amount);
        }
        if (this.filter.isEmpty() || res.func_77977_a().toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US)) || res.func_200301_q().getString().toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US))) {
            this.resources.put(res.func_77977_a() + ":" + res.func_77952_i() + "-" + hashCode, resource);
        }
    }

    public void updateEntitylist() {
        this.entityList.enable();
        this.entityList.show();
        final ArrayList<Entity> tempEntities = new ArrayList<Entity>(this.entities.values());
        this.entityList.setDataProvider(new ScrollingList.DataProvider(){

            @Override
            public int getElementCount() {
                return tempEntities.size();
            }

            @Override
            public void updateElement(int index, @NotNull Pane rowPane) {
                rowPane.findPaneOfTypeByID("resourceName", Text.class).setText((IFormattableTextComponent)((Entity)tempEntities.get(index)).func_200200_C_());
                if (!Minecraft.func_71410_x().field_71439_g.func_184812_l_()) {
                    rowPane.findPaneOfTypeByID("removeEntity", Button.class).hide();
                }
            }
        });
    }

    public void updateResourceList() {
        this.resourceList.enable();
        this.resourceList.show();
        final ArrayList<ItemStorage> tempRes = new ArrayList<ItemStorage>(this.resources.values());
        this.resourceList.setDataProvider(new ScrollingList.DataProvider(){

            @Override
            public int getElementCount() {
                return tempRes.size();
            }

            @Override
            public void updateElement(int index, @NotNull Pane rowPane) {
                ItemStorage resource = (ItemStorage)tempRes.get(index);
                Text resourceLabel = rowPane.findPaneOfTypeByID("resourceName", Text.class);
                Text quantityLabel = rowPane.findPaneOfTypeByID("resourceQuantity", Text.class);
                resourceLabel.setText((IFormattableTextComponent)resource.getItemStack().func_200301_q());
                quantityLabel.setText(Integer.toString(resource.getAmount()));
                resourceLabel.setColors(WHITE);
                quantityLabel.setColors(WHITE);
                rowPane.findPaneOfTypeByID("resourceIcon", ItemIcon.class).setItem(new ItemStack((IItemProvider)resource.getItem(), 1, resource.getItemStack().func_77978_p()));
                if (!Minecraft.func_71410_x().field_71439_g.func_184812_l_()) {
                    rowPane.findPaneOfTypeByID("removeBlock", Button.class).hide();
                    rowPane.findPaneOfTypeByID("replaceBlock", Button.class).hide();
                }
            }
        });
    }
}

