/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.blocks.types;

import com.ldtteam.structurize.api.blocks.IBlockList;
import com.ldtteam.structurize.api.generation.ModBlockStateProvider;
import com.ldtteam.structurize.api.generation.ModBlockTagsProvider;
import com.ldtteam.structurize.api.generation.ModItemModelProvider;
import com.ldtteam.structurize.api.generation.ModItemTagsProvider;
import com.ldtteam.structurize.api.generation.ModLanguageProvider;
import com.ldtteam.structurize.api.generation.ModRecipeProvider;
import com.ldtteam.structurize.blocks.ModBlocks;
import com.ldtteam.structurize.blocks.decorative.BlockTimberFrame;
import com.ldtteam.structurize.blocks.types.TimberFrameCentreType;
import com.ldtteam.structurize.blocks.types.WoodType;
import com.ldtteam.structurize.items.ModItemGroups;
import com.ldtteam.structurize.items.ModItems;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.data.ShapelessRecipeBuilder;
import net.minecraft.data.TagsProvider;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.fml.RegistryObject;
import org.jetbrains.annotations.NotNull;

public enum TimberFrameType implements IBlockList<BlockTimberFrame>
{
    PLAIN("plain", "Vertical", false),
    DOUBLE_CROSSED("double_crossed", "Crossed", false),
    FRAMED("framed", "Plain", false),
    SIDE_FRAMED("side_framed", "Side Framed", true),
    UP_GATED("up_gated", "Up-Gate", true),
    DOWN_GATED("down_gated", "Down-Gate", true),
    ONE_CROSSED_LR("one_crossed_lr", "Right-Hand Slope", false),
    ONE_CROSSED_RL("one_crossed_rl", "Left-Hand Slope", false),
    HORIZONTAL_PLAIN("horizontal_plain", "Horizontal", false),
    SIDE_FRAMED_HORIZONTAL("side_framed_horizontal", "Side Framed Horizontal", true);

    private final String name;
    private final String langName;
    private final boolean rotatable;
    private final List<RegistryObject<BlockTimberFrame>> blocks = new LinkedList<RegistryObject<BlockTimberFrame>>();
    public static final Map<TimberFrameCentreType, Tuple<ITag.INamedTag<Block>, Map<WoodType, ITag.INamedTag<Block>>>> blockTags;
    public static final ITag.INamedTag<Block> BLOCK_TAG;

    private TimberFrameType(String name, String langName, boolean rotatable) {
        this.name = name;
        this.langName = langName;
        this.rotatable = rotatable;
        for (WoodType wood : WoodType.values()) {
            for (TimberFrameCentreType centre : TimberFrameCentreType.values()) {
                this.blocks.add(ModBlocks.register(BlockTimberFrame.getName(this, wood, centre), () -> new BlockTimberFrame(this, wood, centre), ModItemGroups.TIMBER_FRAMES));
            }
        }
    }

    public TimberFrameType getPrevious() {
        if (this.ordinal() - 1 < 0) {
            return TimberFrameType.values()[TimberFrameType.values().length - 1];
        }
        return TimberFrameType.values()[(this.ordinal() - 1) % TimberFrameType.values().length];
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public String getLangName() {
        return this.langName;
    }

    public boolean isRotatable() {
        return this.rotatable;
    }

    @Override
    public List<RegistryObject<BlockTimberFrame>> getRegisteredBlocks() {
        return this.blocks;
    }

    @Override
    public void generateBlockStates(ModBlockStateProvider states) {
        this.getRegisteredBlocks().forEach(block -> this.processStates(states, (BlockTimberFrame)block.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)states.models().getBuilder("block/timber_frames/" + ((BlockTimberFrame)block.get()).getRegistryName().func_110623_a())).parent((ModelFile)new ModelFile.UncheckedModelFile(states.modLoc("block/timber_frames/" + this.getName())))).texture("frame", ((BlockTimberFrame)block.get()).getFrameType() == WoodType.CACTUS ? "blocks/cactus/blockcactusplank" : "minecraft:block/" + ((BlockTimberFrame)block.get()).getFrameType().getMaterial().getRegistryName().func_110623_a())).texture("centre", ((BlockTimberFrame)block.get()).getCentreType().textureLocation)).texture("particle", ((BlockTimberFrame)block.get()).getCentreType().textureLocation)));
    }

    public void processStates(ModBlockStateProvider states, BlockTimberFrame block, ModelFile model) {
        states.getVariantBuilder((Block)block).forAllStates(state -> {
            Direction dir = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H);
            return ConfiguredModel.builder().modelFile(model).rotationX(!this.isRotatable() ? 0 : (dir == Direction.DOWN ? 180 : (dir.func_176740_k().func_176722_c() ? 90 : 0))).rotationY(!this.isRotatable() ? 0 : (dir.func_176740_k().func_200128_b() ? 0 : (int)dir.func_185119_l() % 360)).build();
        });
    }

    @Override
    public void generateItemModels(ModItemModelProvider models) {
        this.getBlocks().forEach(block -> {
            ItemModelBuilder cfr_ignored_0 = (ItemModelBuilder)((ItemModelBuilder)models.getBuilder(this.getRegistryPath((Block)block))).parent((ModelFile)new ModelFile.UncheckedModelFile(models.modLoc("block/timber_frames/" + this.getRegistryPath((Block)block))));
        });
    }

    @Override
    public void generateRecipes(ModRecipeProvider provider) {
        this.getRegisteredBlocks().forEach(block -> {
            BlockTimberFrame previous;
            if (this == PLAIN) {
                provider.add(consumer -> new ShapedRecipeBuilder((IItemProvider)block.get(), 4).func_200472_a("F").func_200472_a("C").func_200472_a("S").func_200462_a(Character.valueOf('F'), (IItemProvider)((BlockTimberFrame)block.get()).getFrameType().getMaterial()).func_200462_a(Character.valueOf('C'), ((BlockTimberFrame)block.get()).getCentreType().getMaterial()).func_200462_a(Character.valueOf('S'), (IItemProvider)ModItems.buildTool.get()).func_200465_a("has_" + ((BlockTimberFrame)block.get()).getRegistryName().func_110623_a(), provider.getCriterion((IItemProvider)block.get())).func_200467_a(consumer, new ResourceLocation("structurize", ((BlockTimberFrame)block.get()).getRegistryName().func_110623_a() + "_crafted")));
            }
            if ((previous = this.search((BlockTimberFrame)block.get())) == null) {
                return;
            }
            provider.add(consumer -> ShapelessRecipeBuilder.func_200486_a((IItemProvider)((IItemProvider)block.get())).func_200487_b((IItemProvider)previous).func_200483_a("has_" + ((BlockTimberFrame)block.get()).getRegistryName().func_110623_a(), provider.getCriterion((IItemProvider)block.get())).func_200482_a(consumer));
        });
    }

    private BlockTimberFrame search(BlockTimberFrame block) {
        for (BlockTimberFrame prev : this.getPrevious().getBlocks()) {
            if (prev.getCentreType() != block.getCentreType() || prev.getFrameType() != block.getFrameType()) continue;
            return prev;
        }
        return null;
    }

    @Override
    public void generateTags(ModBlockTagsProvider blocks, ModItemTagsProvider items) {
        this.getRegisteredBlocks().forEach(block -> {
            TimberFrameCentreType centre = ((BlockTimberFrame)block.get()).getCentreType();
            WoodType wood = ((BlockTimberFrame)block.get()).getFrameType();
            if (!blockTags.containsKey((Object)centre)) {
                ITag.INamedTag<Block> tag = blocks.createTag("timber_frames/" + centre.func_176610_l());
                blockTags.put(centre, (Tuple<ITag.INamedTag<Block>, Map<WoodType, ITag.INamedTag<Block>>>)new Tuple(tag, new LinkedHashMap()));
                blocks.buildTag(BLOCK_TAG).func_240531_a_(tag);
            }
            ((Map)blockTags.get((Object)centre).func_76340_b()).putIfAbsent(wood, blocks.createTag("timber_frames/" + centre.func_176610_l() + "/" + wood.func_176610_l()));
            blocks.buildTag((ITag.INamedTag<Block>)((ITag.INamedTag)((Map)blockTags.get((Object)centre).func_76340_b()).get((Object)wood))).func_240532_a_((Object)block.get());
        });
        if (this.ordinal() < TimberFrameType.values().length - 1) {
            return;
        }
        blockTags.forEach((c, pair) -> {
            TagsProvider.Builder<Block> builder = blocks.buildTag((ITag.INamedTag<Block>)((ITag.INamedTag)pair.func_76341_a()));
            ((Map)pair.func_76340_b()).values().forEach(arg_0 -> builder.func_240531_a_(arg_0));
            items.copy((ITag.INamedTag<Block>)((ITag.INamedTag)pair.func_76341_a()));
            ((Map)pair.func_76340_b()).values().forEach(items::copy);
        });
        items.copy(BLOCK_TAG);
    }

    @Override
    public void generateTranslations(ModLanguageProvider lang) {
        lang.translate(this.getBlocks(), block -> block.getTimberFrameType().getLangName() + " " + ModLanguageProvider.format(block.getFrameType().func_176610_l()) + " " + (block.getCentreType().func_176610_l().equals(block.getFrameType().func_176610_l()) ? "" : block.getCentreType().getLangName() + " ") + "Timber Frame");
    }

    public static List<TimberFrameType> getAll() {
        return Arrays.asList(TimberFrameType.values());
    }

    static {
        blockTags = new LinkedHashMap<TimberFrameCentreType, Tuple<ITag.INamedTag<Block>, Map<WoodType, ITag.INamedTag<Block>>>>();
        BLOCK_TAG = BlockTags.func_199894_a((String)"structurize:timber_frames/timber_frames");
    }
}

