/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.blocks;

import com.ldtteam.structurize.api.blocks.IBlockList;
import com.ldtteam.structurize.api.generation.ModBlockStateProvider;
import com.ldtteam.structurize.api.generation.ModBlockTagsProvider;
import com.ldtteam.structurize.api.generation.ModItemModelProvider;
import com.ldtteam.structurize.api.generation.ModItemTagsProvider;
import com.ldtteam.structurize.api.generation.ModRecipeProvider;
import com.ldtteam.structurize.blocks.ModBlocks;
import com.ldtteam.structurize.blocks.decorative.BlockShingleSlab;
import com.ldtteam.structurize.blocks.types.ShingleFaceType;
import com.ldtteam.structurize.blocks.types.ShingleSlabShapeType;
import com.ldtteam.structurize.items.ModItemGroups;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.data.ShapelessRecipeBuilder;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.Items;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockModelProvider;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.fml.RegistryObject;

public class ShingleSlabList
implements IBlockList<BlockShingleSlab> {
    public static final Map<ShingleFaceType, List<RegistryObject<BlockShingleSlab>>> SLABS = new HashMap<ShingleFaceType, List<RegistryObject<BlockShingleSlab>>>();
    public static final Map<ShingleFaceType, ITag.INamedTag<Block>> blockTags = new HashMap<ShingleFaceType, ITag.INamedTag<Block>>();

    public ShingleSlabList() {
        for (ShingleFaceType type : ShingleFaceType.values()) {
            LinkedList<RegistryObject<BlockShingleSlab>> typeList = new LinkedList<RegistryObject<BlockShingleSlab>>();
            for (int i = -1; i < type.getColors().length; ++i) {
                DyeColor color = i < 0 ? null : type.getColors()[i];
                typeList.add(ModBlocks.register((color == null ? "" : color.func_176610_l() + "_") + type.getGroup() + "_shingle_slab", () -> new BlockShingleSlab(type, color), ModItemGroups.SHINGLES));
            }
            SLABS.put(type, typeList);
        }
    }

    @Override
    public List<RegistryObject<BlockShingleSlab>> getRegisteredBlocks() {
        return SLABS.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    private ModelFile makeBlockModel(BlockModelProvider models, BlockShingleSlab shingle, String shape) {
        String location = (shingle.getColor() == null ? "" : shingle.getColor() + "_") + shingle.getFaceType().getGroup() + "_shingle";
        return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)models.withExistingParent("block/shingle_slab/" + location + "_slab_" + shape, models.modLoc("block/shingle_slab/shingle_slab_" + shape))).texture("1", "blocks/shingle/" + location + "_1")).texture("2", "blocks/shingle/" + location + "_2")).texture("3", "blocks/shingle/" + location + "_3")).texture("particle", "blocks/shingle/" + location + "_1");
    }

    @Override
    public void generateBlockStates(ModBlockStateProvider states) {
        this.getRegisteredBlocks().forEach(block -> {
            BlockShingleSlab shingle = (BlockShingleSlab)block.get();
            states.horizontalBlock((Block)shingle, state -> this.makeBlockModel(states.models(), shingle, ((ShingleSlabShapeType)((Object)((Object)((Object)state.func_177229_b(BlockShingleSlab.SHAPE))))).func_176610_l()));
        });
    }

    @Override
    public void generateItemModels(ModItemModelProvider models) {
        this.getBlocks().forEach(block -> {
            ItemModelBuilder cfr_ignored_0 = (ItemModelBuilder)((ItemModelBuilder)models.getBuilder(block.getRegistryName().func_110623_a())).parent((ModelFile)new ModelFile.UncheckedModelFile(models.modLoc("block/shingle_slab/" + block.getRegistryName().func_110623_a() + "_top")));
        });
    }

    @Override
    public void generateRecipes(ModRecipeProvider provider) {
        this.getRegisteredBlocks().forEach(slab -> provider.add(consumer -> {
            if (((BlockShingleSlab)slab.get()).getColor() == null) {
                new ShapedRecipeBuilder((IItemProvider)slab.get(), 8).func_200472_a("III").func_200472_a("SSS").func_200462_a(Character.valueOf('I'), ((BlockShingleSlab)slab.get()).getFaceType().getMaterial()).func_200462_a(Character.valueOf('S'), (IItemProvider)Items.field_151055_y).func_200465_a("has_" + ((BlockShingleSlab)slab.get()).getRegistryName().func_110623_a(), ModRecipeProvider.getDefaultCriterion((IItemProvider)slab.get())).func_200464_a(consumer);
            } else {
                new ShapelessRecipeBuilder((IItemProvider)slab.get(), 8).func_200491_b((IItemProvider)SLABS.get(((BlockShingleSlab)slab.get()).getFaceType()).get(0).get(), 8).func_200487_b((IItemProvider)DyeItem.func_195961_a((DyeColor)((BlockShingleSlab)slab.get()).getColor())).func_200483_a("has_" + ((BlockShingleSlab)slab.get()).getRegistryName().func_110623_a(), ModRecipeProvider.getDefaultCriterion((IItemProvider)slab.get())).func_200482_a(consumer);
            }
        }));
    }

    @Override
    public void generateTags(ModBlockTagsProvider blocks, ModItemTagsProvider items) {
        this.getRegisteredBlocks().forEach(block -> {
            blockTags.putIfAbsent(((BlockShingleSlab)block.get()).getFaceType(), blocks.createTag("shingle_slabs/" + ((BlockShingleSlab)block.get()).getFaceType().getGroup()));
            blocks.buildTag(blockTags.get(((BlockShingleSlab)block.get()).getFaceType())).func_240532_a_((Object)block.get());
        });
        blockTags.values().forEach(items::copy);
    }
}

