/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.blocks;

import com.ldtteam.structurize.api.blocks.IBlockList;
import com.ldtteam.structurize.api.generation.ModBlockStateProvider;
import com.ldtteam.structurize.api.generation.ModBlockTagsProvider;
import com.ldtteam.structurize.api.generation.ModItemModelProvider;
import com.ldtteam.structurize.api.generation.ModItemTagsProvider;
import com.ldtteam.structurize.api.generation.ModLanguageProvider;
import com.ldtteam.structurize.api.generation.ModRecipeProvider;
import com.ldtteam.structurize.blocks.ModBlocks;
import com.ldtteam.structurize.blocks.decorative.BlockPaperWall;
import com.ldtteam.structurize.blocks.types.WoodType;
import com.ldtteam.structurize.items.ModItemGroups;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.PaneBlock;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.fml.RegistryObject;

public class PaperWallList
implements IBlockList<BlockPaperWall> {
    public static final ITag.INamedTag<Block> BLOCK_TAG = BlockTags.func_199894_a((String)"structurize:paper_walls");
    public static final ITag.INamedTag<Item> ITEM_TAG = ItemTags.func_199901_a((String)"structurize:paper_walls");
    public static final Map<RegistryObject<BlockPaperWall>, WoodType> blocks = new HashMap<RegistryObject<BlockPaperWall>, WoodType>();

    public PaperWallList() {
        for (WoodType type : WoodType.values()) {
            RegistryObject<BlockPaperWall> block = ModBlocks.register(type.func_176610_l() + "_blockpaperwall", () -> new BlockPaperWall(type), ModItemGroups.CONSTRUCTION);
            blocks.put(block, type);
        }
    }

    @Override
    public List<RegistryObject<BlockPaperWall>> getRegisteredBlocks() {
        return new ArrayList<RegistryObject<BlockPaperWall>>(blocks.keySet());
    }

    @Override
    public void generateBlockStates(ModBlockStateProvider states) {
        this.getRegisteredBlocks().forEach(block -> states.paneBlock((PaneBlock)block.get(), new ResourceLocation("structurize", "blocks/paperwall/" + blocks.get(block).func_176610_l() + "_pane"), new ResourceLocation("structurize", "blocks/paperwall/" + blocks.get(block).func_176610_l() + "_edge")));
    }

    @Override
    public void generateItemModels(ModItemModelProvider models) {
        this.getRegisteredBlocks().forEach(block -> {
            ItemModelBuilder cfr_ignored_0 = (ItemModelBuilder)((ItemModelBuilder)models.withExistingParent(((BlockPaperWall)block.get()).getRegistryName().func_110623_a(), "item/generated")).texture("layer0", models.modLoc("blocks/paperwall/" + blocks.get(block).func_176610_l() + "_pane"));
        });
    }

    @Override
    public void generateRecipes(ModRecipeProvider provider) {
        this.getRegisteredBlocks().forEach(block -> provider.add(consumer -> ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)block.get()), (int)8).func_200472_a("###").func_200472_a("PPP").func_200472_a("###").func_200462_a(Character.valueOf('#'), (IItemProvider)blocks.get(block).getMaterial()).func_200462_a(Character.valueOf('P'), (IItemProvider)Items.field_151121_aF).func_200465_a("has_" + ((BlockPaperWall)block.get()).getRegistryName().func_110623_a(), provider.getCriterion((IItemProvider)block.get())).func_200464_a(consumer)));
    }

    @Override
    public void generateTags(ModBlockTagsProvider blocks, ModItemTagsProvider items) {
        blocks.buildTag(BLOCK_TAG).func_240534_a_((Object[])this.getBlocks().toArray(new Block[0]));
        items.func_240521_a_(BLOCK_TAG, ITEM_TAG);
    }

    @Override
    public void generateTranslations(ModLanguageProvider lang) {
        this.getBlocks().forEach(block -> lang.add((Block)block, ModLanguageProvider.format(block.getType().func_176610_l() + " Paper Wall")));
    }
}

