/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.api.blocks;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.item.Item;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Tags;

public enum BlockType {
    BLOCK("", Block::new, Collections.EMPTY_LIST, Collections.EMPTY_LIST, 4, "##", "##"),
    SLAB("slab", SlabBlock::new, (ITag.INamedTag<Block>)BlockTags.field_203292_x, (ITag.INamedTag<Item>)ItemTags.field_203442_w, 6, "###"),
    STAIRS("stairs", props -> new StairsBlock(() -> ((Block)Blocks.field_196584_bK).func_176223_P(), props), (ITag.INamedTag<Block>)BlockTags.field_203291_w, (ITag.INamedTag<Item>)ItemTags.field_203441_v, 4, "#  ", "## ", "###"),
    WALL("wall", WallBlock::new, (ITag.INamedTag<Block>)BlockTags.field_219757_z, (ITag.INamedTag<Item>)ItemTags.field_219778_z, 6, "###", "###"),
    PLANKS("planks", Block::new, (ITag.INamedTag<Block>)BlockTags.field_199898_b, (ITag.INamedTag<Item>)ItemTags.field_199905_b, 4, "#"),
    FENCE("fence", FenceBlock::new, (ITag.INamedTag<Block>)BlockTags.field_219748_G, (ITag.INamedTag<Item>)ItemTags.field_219772_G, 3, "#-#", "#-#"),
    FENCE_GATE("fence_gate", FenceGateBlock::new, (ITag.INamedTag<Block>)BlockTags.field_232868_aA_, (ITag.INamedTag<Item>)ItemTags.field_219772_G, 1, "-#-", "-#-"),
    TRAPDOOR("trapdoor", TrapDoorBlock::new, (ITag.INamedTag<Block>)BlockTags.field_212185_E, (ITag.INamedTag<Item>)ItemTags.field_212187_B, 3, "###", "###"),
    DOOR("door", DoorBlock::new, (ITag.INamedTag<Block>)BlockTags.field_200029_f, (ITag.INamedTag<Item>)ItemTags.field_200036_f, 3, "##", "##", "##");

    public final String suffix;
    public final Function<AbstractBlock.Properties, ? extends Block> constructor;
    public final List<ITag.INamedTag<Block>> blockTag;
    public final List<ITag.INamedTag<Item>> itemTag;
    private final int recipeYield;
    private final List<String> craftingPatterns;

    private BlockType(String suffix, Function<AbstractBlock.Properties, ? extends Block> constructor, List<ITag.INamedTag<Block>> blockTag, List<ITag.INamedTag<Item>> itemTag, int yield, String ... craftingPatterns) {
        this.suffix = suffix;
        this.constructor = constructor;
        this.blockTag = blockTag;
        this.itemTag = itemTag;
        this.recipeYield = yield;
        this.craftingPatterns = Arrays.asList(craftingPatterns.length < 4 ? craftingPatterns : new String[]{});
    }

    private BlockType(String suffix, Function<AbstractBlock.Properties, ? extends Block> constructor, ITag.INamedTag<Block> blockTag, ITag.INamedTag<Item> itemTag, int yield, String ... craftingPatterns) {
        this(suffix, constructor, Lists.newArrayList((Object[])new ITag.INamedTag[]{blockTag}), Lists.newArrayList((Object[])new ITag.INamedTag[]{itemTag}), yield, craftingPatterns);
    }

    public String withSuffix(String name, String pluralName) {
        String result;
        if (this == BLOCK) {
            name = pluralName;
        }
        String string = result = this.suffix.isEmpty() ? name : name + "_" + this.suffix;
        if (name.equals("blockcactus")) {
            result = result.replace("_", "").replace("stairs", "stair").replace("planks", "plank");
        }
        return result;
    }

    public ShapedRecipeBuilder formRecipe(IItemProvider result, IItemProvider material, ICriterionInstance criterion) {
        ShapedRecipeBuilder builder = new ShapedRecipeBuilder(result, this.recipeYield);
        for (String line : this.craftingPatterns) {
            builder.func_200472_a(line);
        }
        if (this == FENCE || this == FENCE_GATE) {
            builder.func_200469_a(Character.valueOf('-'), (ITag)Tags.Items.RODS_WOODEN);
        }
        return builder.func_200462_a(Character.valueOf('#'), material).func_200465_a("has_" + material.func_199767_j().getRegistryName().func_110623_a(), criterion);
    }

    public static BlockType fromSuffix(String path) {
        if (path.startsWith("blockcactus")) {
            path = path.replace("stair", "stairs").replace("plank", "planks").replace("fencegate", "fence_gate");
        }
        for (BlockType cut : BlockType.values()) {
            if (cut.suffix.isEmpty() || !path.endsWith(cut.suffix)) continue;
            return cut;
        }
        return BLOCK;
    }

    public static BlockType fromSuffix(Block block) {
        return block.getRegistryName() != null ? BlockType.fromSuffix(block.getRegistryName().func_110623_a()) : BLOCK;
    }

    public static String copySuffix(Block source, Block copycat) {
        ResourceLocation name = copycat.getRegistryName();
        if (name == null) {
            return "";
        }
        return BlockType.fromSuffix(source).withSuffix(name.func_110623_a(), "");
    }
}

