/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structures.lib;

import com.ldtteam.structures.blueprints.v1.Blueprint;
import com.ldtteam.structurize.blocks.interfaces.IBlueprintDataProvider;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public class BlueprintTagUtils {
    public static BlockPos getFirstPosForTag(Blueprint blueprint, String tagName) {
        BlockPos anchorPos = blueprint.getPrimaryBlockOffset();
        CompoundNBT nbt = blueprint.getBlockInfoAsMap().get(anchorPos).getTileEntityData();
        if (nbt != null) {
            Map<BlockPos, List<String>> tagPosMap = IBlueprintDataProvider.readTagPosMapFrom(nbt.func_74775_l("blueprintDataProvider"));
            for (Map.Entry<BlockPos, List<String>> entry : tagPosMap.entrySet()) {
                for (String tag : entry.getValue()) {
                    if (!tag.equals(tagName)) continue;
                    return entry.getKey();
                }
            }
        }
        return null;
    }

    public static int getNumberOfGroundLevels(@NotNull Blueprint blueprint, int defaultGroundLevels) {
        BlockPos groundLevelPos = BlueprintTagUtils.getFirstPosForTag(blueprint, "groundlevel");
        if (groundLevelPos != null) {
            return blueprint.getPrimaryBlockOffset().func_177956_o() + groundLevelPos.func_177956_o() + 1;
        }
        return defaultGroundLevels;
    }

    public static int getGroundAnchorOffset(@NotNull Blueprint blueprint, int defaultGroundOffset) {
        BlockPos groundLevelPos = BlueprintTagUtils.getFirstPosForTag(blueprint, "groundlevel");
        if (groundLevelPos != null) {
            return -groundLevelPos.func_177956_o();
        }
        return defaultGroundOffset;
    }

    public static int getGroundAnchorOffsetFromGroundLevels(@NotNull Blueprint blueprint, int groundLevels) {
        return blueprint.getPrimaryBlockOffset().func_177956_o() - groundLevels + 1;
    }
}

