/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structures.client;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundNBT;
import org.jetbrains.annotations.NotNull;

public class BlueprintEntityInfoTransformHandler {
    private static BlueprintEntityInfoTransformHandler ourInstance = new BlueprintEntityInfoTransformHandler();
    private Map<Predicate<CompoundNBT>, Function<CompoundNBT, CompoundNBT>> entityInfoTransformHandler = new HashMap<Predicate<CompoundNBT>, Function<CompoundNBT, CompoundNBT>>();

    public static BlueprintEntityInfoTransformHandler getInstance() {
        return ourInstance;
    }

    private BlueprintEntityInfoTransformHandler() {
    }

    public void AddTransformHandler(@NotNull Predicate<CompoundNBT> transformPredicate, @NotNull Function<CompoundNBT, CompoundNBT> transformHandler) {
        this.entityInfoTransformHandler.put(transformPredicate, transformHandler);
    }

    public CompoundNBT Transform(@NotNull CompoundNBT entityInfo) {
        return this.getTransformHandler(entityInfo).apply(entityInfo);
    }

    private Function<CompoundNBT, CompoundNBT> getTransformHandler(@NotNull CompoundNBT entityInfo) {
        return this.entityInfoTransformHandler.keySet().stream().filter(p -> p.test(entityInfo)).findFirst().map(p -> this.entityInfoTransformHandler.get(p)).orElse(Function.identity());
    }
}

