/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.views;

import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.PaneParams;
import com.ldtteam.blockout.views.View;
import net.minecraft.util.math.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SwitchView
extends View {
    @Nullable
    private Pane currentView;

    public SwitchView() {
    }

    public SwitchView(PaneParams params) {
        super(params);
    }

    @Override
    public void parseChildren(@NotNull PaneParams params) {
        super.parseChildren(params);
        String defaultView = params.getString("default");
        if (defaultView != null) {
            this.setView(defaultView);
        }
    }

    public boolean setView(String name) {
        for (Pane child : this.children) {
            if (!child.getID().equals(name)) continue;
            this.setCurrentView(child);
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public Pane findPaneForClick(double mx, double my) {
        if (this.currentView != null && this.currentView.canHandleClick(mx, my)) {
            return this.currentView;
        }
        return null;
    }

    @Override
    protected boolean childIsVisible(Pane child) {
        return child == this.currentView && super.childIsVisible(child);
    }

    @Override
    public void addChild(@NotNull Pane child) {
        super.addChild(child);
        if (this.children.size() == 1) {
            this.currentView = child;
            child.setVisible(true);
        } else {
            child.setVisible(false);
        }
    }

    @Override
    public void adjustChild(@NotNull Pane child) {
        if (child.getWidth() == 0 || child.getHeight() == 0) {
            child.setSize(this.width - child.getX(), this.height - child.getY());
        }
        super.adjustChild(child);
    }

    @Override
    public void removeChild(Pane child) {
        super.removeChild(child);
        if (child == this.currentView) {
            if (this.children.isEmpty()) {
                this.currentView = null;
            } else {
                this.currentView = (Pane)((Object)this.children.get(0));
                this.currentView.setVisible(true);
            }
        }
    }

    @Nullable
    public Pane getCurrentView() {
        return this.currentView;
    }

    private void setCurrentView(Pane pane) {
        if (this.currentView != null) {
            this.currentView.setVisible(false);
        }
        this.currentView = pane;
        this.currentView.setVisible(true);
    }

    public void nextView() {
        this.setView(true, 1);
    }

    public void previousView() {
        this.setView(true, -1);
    }

    public int setView(boolean relative, int shift) {
        if (this.children.isEmpty()) {
            return -1;
        }
        int newIndex = relative ? this.children.indexOf((Object)this.currentView) + shift : shift;
        newIndex = MathHelper.func_76125_a((int)newIndex, (int)0, (int)(this.getChildrenSize() - 1));
        this.setCurrentView((Pane)((Object)this.children.get(newIndex)));
        return newIndex;
    }

    public int getChildrenSize() {
        return this.children.size();
    }
}

