/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.controls;

import com.ldtteam.blockout.BOScreen;
import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.PaneParams;
import com.ldtteam.blockout.Parsers;
import com.ldtteam.blockout.views.ScrollingContainer;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.util.math.MathHelper;

public class Scrollbar
extends Pane {
    private static final int MAXIMUM_HEIGHT = 20;
    protected int scrollbarBackground = -16777216;
    protected int scrollbarColor = -4144960;
    protected int scrollbarColorHighlight = -8355712;
    protected ScrollingContainer container;
    protected double barClickY = 0.0;
    protected boolean barClicked = false;
    protected int offsetX = 0;
    protected int offsetY = 0;

    public Scrollbar(ScrollingContainer container, PaneParams params) {
        this(container);
        params.applyShorthand("scrollbarOffset", Parsers.INT, 2, a -> {
            this.offsetX = (Integer)a.get(0);
            this.offsetY = (Integer)a.get(1);
        });
    }

    public Scrollbar(ScrollingContainer container) {
        this.container = container;
    }

    public void dragScroll(double my) {
        if (this.container.getContentHeight() == 0) {
            return;
        }
        double barClickYNow = this.getScrollBarYPos() + this.barClickY;
        double deltaFromClickPos = my - barClickYNow;
        if (deltaFromClickPos == 0.0) {
            return;
        }
        double scaledY = deltaFromClickPos * (double)this.container.getMaxScrollY() / (double)this.getHeight();
        this.container.scrollBy(scaledY);
        if (this.container.getScrollY() == 0.0 || this.container.getScrollY() == (double)this.container.getMaxScrollY()) {
            this.barClickY = MathHelper.func_151237_a((double)(my - this.getScrollBarYPos()), (double)0.0, (double)(this.getBarHeight() - 1));
        }
    }

    @Override
    public void drawSelf(MatrixStack ms, double mx, double my) {
        boolean bl = this.barClicked = this.barClicked && (this.mc.field_71417_B.func_198030_b() || BOScreen.isMouseLeftDown);
        if (this.barClicked) {
            this.dragScroll(my - (double)this.y);
        }
        if (this.getContentHeightDiff() <= 0) {
            return;
        }
        int scrollBarBackX1 = this.x + this.offsetX;
        int scrollBarBackX2 = scrollBarBackX1 + (this.getWidth() - 2);
        Scrollbar.func_238467_a_((MatrixStack)ms, (int)scrollBarBackX2, (int)(this.y + this.getHeight() + this.offsetY), (int)scrollBarBackX1, (int)(this.y + this.offsetY), (int)this.scrollbarBackground);
        int scrollBarStartY = this.y + (int)this.getScrollBarYPos();
        int scrollBarEndY = scrollBarStartY + this.getBarHeight();
        Scrollbar.func_238467_a_((MatrixStack)ms, (int)scrollBarBackX2, (int)scrollBarEndY, (int)scrollBarBackX1, (int)scrollBarStartY, (int)this.scrollbarColorHighlight);
        Scrollbar.func_238467_a_((MatrixStack)ms, (int)(scrollBarBackX2 - 1), (int)(scrollBarEndY - 1), (int)scrollBarBackX1, (int)scrollBarStartY, (int)this.scrollbarColor);
    }

    @Override
    public boolean handleClick(double mx, double my) {
        if (this.getContentHeightDiff() <= 0) {
            return false;
        }
        int barHeight = this.getBarHeight();
        double scrollBarStartY = this.getScrollBarYPos();
        double scrollBarEndY = scrollBarStartY + (double)barHeight;
        if (my < scrollBarStartY) {
            this.container.scrollBy(-this.container.getScrollPageSize());
        } else if (my > scrollBarEndY) {
            this.container.scrollBy(this.container.getScrollPageSize());
        } else {
            this.barClickY = my - scrollBarStartY;
            this.barClicked = true;
        }
        return true;
    }

    private int getContentHeightDiff() {
        return this.container.getContentHeight() - this.getHeight();
    }

    private int getBarHeight() {
        return Math.max(Math.min(20, this.getHeight() / 2), this.getHeight() * this.getHeight() / this.container.getContentHeight());
    }

    private double getScrollBarYPos() {
        return this.container.getScrollY() * (double)(this.getHeight() - this.getBarHeight()) / (double)this.getContentHeightDiff();
    }

    public int getScrollOffsetX() {
        return this.offsetX;
    }

    @Override
    public boolean onMouseDrag(double mx, double my, int speed, double deltaX, double deltaY) {
        return true;
    }
}

